/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import { Divider, lighten } from '@material-ui/core';
export class ShadowedDivider extends React.Component {
    constructor() {
        super(...arguments);
        this.isLightMode = Global.themeManager == undefined || Global.themeManager.isLight(Global.themeManager.theme);
        this.render = () => {
            const darkColor = this.isLightMode ? '#bbbbbb' : 'rgba(255, 255, 255, 0.18)';
            const lightColor = this.isLightMode ? lighten(darkColor, 2 / 3) : 'rgba(255, 255, 255, 0.12)';
            return this.props.orientation === undefined || this.props.orientation === 'horizontal' ? (React.createElement(React.Fragment, null,
                React.createElement(Divider, { variant: 'fullWidth', style: { backgroundColor: darkColor } }),
                React.createElement(Divider, { variant: 'fullWidth', style: { backgroundColor: lightColor } }))) : this.props.orientation === 'vertical' && (React.createElement("div", { style: { display: 'flex', height: '100%' } },
                React.createElement(Divider, { orientation: 'vertical', variant: 'fullWidth', style: { backgroundColor: darkColor } }),
                React.createElement(Divider, { orientation: 'vertical', variant: 'fullWidth', style: { backgroundColor: lightColor } })));
        };
        this.handleThemeChange = () => { this.isLightMode = Global.themeManager == undefined || Global.themeManager.isLight(Global.themeManager.theme); this.forceUpdate(); };
        this.componentDidMount = () => {
            Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        this.componentWillUnmount = () => {
            Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
        };
    }
}
