/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
export class Label extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('LabelRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '100%', padding: '3px 0px' }, this.props.style) },
                React.createElement("div", { style: {
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: '24px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                        textAlign: this.props.align || 'center',
                    } }, this.props.label),
                React.createElement("div", { style: {
                        width: '100%',
                        height: '24px',
                        margin: '0px 6px',
                        lineHeight: '24px',
                    } },
                    React.createElement("div", { style: { padding: '0px 6px', fontSize: '12px' } }, this.props.styledUnitValue(this.props.getValue())))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}
Label.defaultProps = {
    styledUnitValue: (value) => { return value.toString(); },
};
