import * as React from 'react';
import { CSSProperties } from '@material-ui/core/styles/withStyles';
interface IProps {
    style?: CSSProperties;
    getValue: () => string;
    saveValue: (value: string) => Promise<string>;
    checkForError: (value: string) => string;
    password?: boolean;
    placeholder?: string;
    helperText?: string;
    typingText?: string;
    disabled?: boolean;
    multiline?: boolean;
}
interface IState {
    value: string;
    hidePassword: boolean;
    invalidTextMessage: string;
    focused: boolean;
}
export declare class FullWidthTextBox extends React.Component<IProps, IState> {
    StyledOutlinedInput: any;
    StyledDisabledErrorOutlinedInput: any;
    textField: React.RefObject<HTMLInputElement>;
    constructor(props: IProps);
    private getStyledOutlinedInput;
    private getStyledDisabledErrorOutlinedInput;
    private handleChange;
    private handleFocus;
    private handleBlur;
    render: () => JSX.Element;
    private handleMetadataChange;
    componentDidMount: () => void;
    componentWillUnmount: () => void;
    shouldComponentUpdate: (nextProps: IProps, nextState: IState) => boolean;
}
export {};
