/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../Global';
import { ServerConnection } from '@jupyterlab/services';
import { ChangePasswordPopup } from './ChangePasswordPopup';
import { CheckoutForm } from './CheckoutForm';
import { Header, Switch, TextBox, TextBoxDropdown } from '../../core';
import FormatUtils from '../../utils/FormatUtils';
import { Button } from '@material-ui/core';
import GetAppIcon from '@material-ui/icons/GetApp';
const emUpSub = 'Upgrade subscription to unlock';
const LABEL_WIDTH = '68px';
export class AccountGeneralSubMenu extends React.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            return (React.createElement(React.Fragment, null,
                React.createElement("div", { style: { padding: '6px' } },
                    React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        React.createElement(TextBox, { style: { flexGrow: 1 }, getValue: this.getPasswordValue, saveValue: this.savePasswordValue, label: 'Password', labelWidth: LABEL_WIDTH }),
                        React.createElement(ChangePasswordPopup, { style: { margin: '8px 0px', height: '20px' } })),
                    React.createElement(Switch, { getValue: this.getCompressFilesEnabledValue, saveValue: this.saveCompressFilesEnabledValue, label: 'Compress my files before uploading', labelWidth: LABEL_WIDTH }))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {};
    }
    getPasswordValue() { return '******'; }
    savePasswordValue(password) {
        Global.user.changePassword("", "", password);
    }
    getCompressFilesEnabledValue() { return Global.user.compressFilesEnabled; }
    saveCompressFilesEnabledValue(compressFilesEnabled) { Global.user.compressFilesEnabled = compressFilesEnabled; }
}
export class AccountLimitsSubMenu extends React.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            return (React.createElement(React.Fragment, null,
                React.createElement("div", { style: { padding: '6px' } },
                    Global.user.userExpertise > 0 ? (React.createElement(TextBox, { getValue: this.getUserBudgetValue, saveValue: this.saveUserBudgetValue, styledUnitValue: (value) => '$' + value.toFixed(2), unstyleUnitValue: (value) => { return value.replace('$', '').replace('.', '').replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value.replace('$', '')); }, label: 'Budget', labelWidth: LABEL_WIDTH, onFocus: () => this.setState({ budgetFocused: true }), onBlur: () => this.setState({ budgetFocused: false }), helperText: this.state.budgetFocused ? `Must be between $1 and $${Global.user.maxBudget}` : 'Max monthly spend', minValue: 1, maxValue: Global.user.maxBudget })) : (React.createElement(React.Fragment, null)),
                    React.createElement(TextBox, { getValue: this.getUserRecommendationsValue, saveValue: this.saveUserRecommendationsValue, label: 'Alternatives', labelWidth: LABEL_WIDTH, onFocus: () => this.setState({ recsFocused: true }), onBlur: () => this.setState({ recsFocused: false }), helperText: this.state.recsFocused ? `Must be between 1 and ${Global.user.maxRecommendations}` : 'Number of machines considered', minValue: 1, maxValue: Global.user.maxRecommendations, disabledMessage: Global.user.userExpertise < 2 ? emUpSub : '' }),
                    React.createElement(TextBox, { getValue: this.getMaxJobsValue, saveValue: this.saveMaxJobsValue, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, label: 'Jobs', labelWidth: LABEL_WIDTH, helperText: 'Max number of concurrent jobs', disabledMessage: emUpSub }),
                    React.createElement(TextBox, { getValue: this.getMaxMachinesValue, saveValue: this.saveMaxMachinesValue, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, label: 'Machines', labelWidth: LABEL_WIDTH, helperText: 'Max number of concurrent machines', disabledMessage: emUpSub }),
                    React.createElement(TextBoxDropdown, { getValue: this.getUserHoldoverTimeValue, saveValue: this.saveUserHoldoverTimeValue, unitValues: [
                            { unit: 'seconds', value: 1 },
                            { unit: 'minutes', value: 60 },
                            { unit: 'hours', value: 3600 },
                        ], label: 'Holdover', labelWidth: LABEL_WIDTH, onFocus: () => this.setState({ holdoverFocused: true }), onBlur: () => this.setState({ holdoverFocused: false }), helperText: this.state.holdoverFocused ? `Must be between 0 seconds and ${Global.user.maxHoldoverTime / 3600} hours` : 'Time before releasing idle machines', minValue: 0, maxValue: Global.user.maxHoldoverTime }))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            holdoverFocused: false,
            budgetFocused: false,
            recsFocused: false,
        };
    }
    getUserBudgetValue() { return Global.user.userBudget; }
    saveUserBudgetValue(userBudget) { Global.user.userBudget = userBudget; }
    getUserRecommendationsValue() { return Global.user.userRecommendations; }
    saveUserRecommendationsValue(userRecommendations) { Global.user.userRecommendations = userRecommendations; }
    getMaxJobsValue() { return Global.user.maxJobs; }
    saveMaxJobsValue(value) { Global.user.maxJobs = value; }
    getMaxMachinesValue() { return Global.user.maxMachines; }
    saveMaxMachinesValue(value) { Global.user.maxMachines = value; }
    getUserHoldoverTimeValue() { return Global.user.userHoldoverTime; }
    saveUserHoldoverTimeValue(userHoldoverTime) { Global.user.userHoldoverTime = userHoldoverTime; }
}
export class AccountPaymentSubMenu extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.getDuration = (record) => {
            var endTime = new Date(record.endTime);
            var startTime = new Date(record.startTime);
            var diff = endTime.getTime() - startTime.getTime();
            const stillRunning = diff < 0;
            if (stillRunning) {
                diff = new Date().getTime() - startTime.getTime();
            }
            var time = FormatUtils.msToTime(diff).split(':');
            var formatted;
            if (time.length == 3) {
                formatted = time[0] + 'h ' + time[1] + 'm ' + time[2] + 's';
            }
            else {
                formatted = time[0] + 'm ' + time[1] + 's';
            }
            return stillRunning ? formatted + ' (still running)' : formatted;
        };
        this.getCost = (record) => {
            var endTime = new Date(record.endTime);
            var startTime = new Date(record.startTime);
            var diff = endTime.getTime() - startTime.getTime();
            const stillRunning = diff < 0;
            if (stillRunning) {
                diff = new Date().getTime() - startTime.getTime();
            }
            var formatted = '$' + ((diff / 3600000) * record.machine.rate).toFixed(2);
            return stillRunning ? formatted + ' (still running)' : formatted;
        };
        this.render = () => {
            return (React.createElement(React.Fragment, null,
                React.createElement("div", { style: { padding: '6px' } },
                    React.createElement("div", { style: { display: 'inline-flex', width: '100%', padding: '3px 0px' } },
                        React.createElement("div", { style: {
                                lineHeight: '24px',
                                margin: '0px 12px',
                                flexGrow: 1,
                            } }, 'Remaining balance:'),
                        React.createElement("div", { style: { padding: '0px 6px 0px 6px' } }, '$' + (-this.state.balance).toFixed(2))),
                    React.createElement(CheckoutForm, null),
                    React.createElement("div", { style: { padding: '6px', width: '100%' } },
                        React.createElement(Button, { variant: "outlined", color: "primary", startIcon: React.createElement(GetAppIcon, null), style: { width: '100%' }, onClick: () => this.getDetailedBilling(true) }, "Billing records")))));
        };
        this.getDetailedBilling = (save) => {
            const settings = ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-detailed-billing";
            const now = new Date();
            const epoch = new Date(0);
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    startTime: epoch.toISOString(),
                    endTime: now.toISOString(),
                }),
            };
            ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (response.status !== 200 && response.status !== 201) {
                    if (response.status == 401) {
                        this.polling = false;
                        Global.user = null;
                    }
                    throw new ServerConnection.ResponseError(response);
                }
                return response.json();
            }).then((body) => {
                if (body) {
                    this.checkAndSetState({ billing: body.records });
                    if (save) {
                        const data = [];
                        var sorted = body.records.sort((n1, n2) => {
                            if (n1.startTime > n2.startTime) {
                                return -1;
                            }
                            if (n1.startTime < n2.startTime) {
                                return 1;
                            }
                            return 0;
                        });
                        for (let record of sorted) {
                            const machine = record.machine;
                            data.push([
                                new Date(record.startTime).toLocaleString().replace(/,/g, ''),
                                new Date(0).toISOString() == new Date(record.endTime).toISOString() ? 'Still running' : new Date(record.endTime).toLocaleString().replace(/,/g, ''),
                                this.getDuration(record),
                                '$' + machine.rate.toFixed(2),
                                this.getCost(record),
                                machine.graphicsNumCards > 0 ? (machine.graphicsNumCards + 'x' + machine.graphicsCardType) : 'No GPU',
                                machine.computeCores + ' cores',
                                FormatUtils.styleCapacityUnitValue()(machine.memorySize),
                                FormatUtils.styleCapacityUnitValue()(machine.storageSize)
                            ]);
                        }
                        const headers = [
                            ["Start Time", "End Time", "Duration", "Rate ($/hr)", "Cost", "GPU", "CPU", "RAM", "Disk"]
                        ];
                        const csvContent = "data:text/csv;charset=utf-8,"
                            + headers.map(e => e.join(",")).join("\n") + '\n'
                            + data.map(e => e.join(",")).join("\n") + '\n';
                        var encodedUri = encodeURI(csvContent);
                        var link = document.createElement("a");
                        link.setAttribute("href", encodedUri);
                        link.setAttribute("download", "billing_records.csv");
                        document.body.appendChild(link); // Required for FF
                        link.click();
                    }
                }
            });
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.getDetailedBilling(false);
            this.polling = true;
            this.receiveUpdate();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
            this.polling = false;
        };
        this.checkAndSetState = (map) => {
            if (this._isMounted) {
                this.setState(map);
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            balance: 0,
            billing: [],
        };
    }
    async receiveUpdate() {
        const settings = ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-total-billing";
        const now = new Date();
        const epoch = new Date(0);
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: epoch.toISOString(),
                endTime: now.toISOString(),
            }),
        };
        ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                setTimeout(() => this.receiveUpdate(), 2000);
            }
            if (response.status !== 200 && response.status !== 201) {
                if (response.status == 401) {
                    this.polling = false;
                    Global.user = null;
                }
                throw new ServerConnection.ResponseError(response);
            }
            return response.json();
        }).then((body) => {
            if (body) {
                this.checkAndSetState({ balance: body.balance });
            }
        });
    }
}
export class TeamSubMenu extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            return (React.createElement(Header, { title: 'Members' }));
        };
    }
}
