/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../Global';
import { Dialog, DialogContent, Button, IconButton, Divider, DialogActions } from '@material-ui/core';
import CloseIcon from '@material-ui/icons/Close';
import MuiDialogTitle from '@material-ui/core/DialogTitle';
import { withStyles } from '@material-ui/core/styles';
import { TextBox, ShadowedDivider } from '../../core';
const StyledDialog = withStyles({
    paper: {
        width: '300px',
        backgroundColor: 'var(--jp-layout-color1)',
    },
})(Dialog);
export class ChangePasswordPopup extends React.Component {
    constructor(props) {
        super(props);
        this.handleClickOpen = () => {
            if (this.props.onOpen !== undefined)
                this.props.onOpen();
            this.setState({ open: true });
        };
        this.handleClose = () => {
            this.setState({ open: false, loginName: '', oldPassword: '', newPassword: '', errorMessage: '' });
            if (this.props.onClose !== undefined)
                this.props.onClose();
        };
        this.changePassword = () => {
            Global.user.changePassword(this.state.loginName, this.state.oldPassword, this.state.newPassword).then(() => {
                this.handleClose();
            }, (reason) => {
                this.setState({ errorMessage: `Failed to change password...
Try checking your username/password` });
            });
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            open: false,
            loginName: '',
            oldPassword: '',
            newPassword: '',
            errorMessage: '',
        };
    }
    render() {
        if (Global.shouldLogOnRender)
            console.log('ChangePasswordPopupRender (' + new Date().getSeconds() + ')');
        return (React.createElement(React.Fragment, null,
            React.createElement(Button, { onClick: this.handleClickOpen, style: Object.assign({
                    minWidth: '0px',
                }, this.props.style), variant: "contained", color: "secondary", disableElevation: true }, "EDIT"),
            React.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                React.createElement(MuiDialogTitle, { disableTypography: true, style: {
                        display: 'inline-flex',
                        backgroundColor: 'var(--jp-layout-color2)',
                        height: '48px',
                        padding: '6px'
                    } },
                    React.createElement("div", { style: {
                            display: 'inline-flex',
                            width: '100%',
                            padding: '6px',
                            fontSize: '16px',
                            fontWeight: 'bold',
                            lineHeight: '24px'
                        } }, "Change Password"),
                    React.createElement(IconButton, { onClick: this.handleClose, style: {
                            display: 'inline-block',
                            width: '36px',
                            height: '36px',
                            padding: '3px',
                        } },
                        React.createElement(CloseIcon, { style: {
                                width: '30px',
                                height: '30px',
                                padding: '3px',
                            } }))),
                React.createElement(ShadowedDivider, null),
                React.createElement(DialogContent, { style: { padding: '0px' } },
                    React.createElement("div", { style: { padding: '6px' } },
                        React.createElement(TextBox, { label: 'Username', getValue: () => '', saveValue: (loginName) => {
                                this.setState({ loginName: loginName, errorMessage: '' });
                            }, placeholder: 'Username' }),
                        React.createElement(TextBox, { label: 'Old', getValue: () => '', saveValue: (oldPassword) => {
                                this.setState({ oldPassword: oldPassword, errorMessage: '' });
                            }, placeholder: 'Old Password', password: true }),
                        React.createElement(TextBox, { label: 'New', getValue: () => '', saveValue: (newPassword) => {
                                this.setState({ newPassword: newPassword, errorMessage: '' });
                            }, placeholder: 'New Password', password: true }))),
                React.createElement(Divider, { variant: 'middle' }),
                React.createElement(DialogActions, { style: { padding: '6px' } },
                    React.createElement(Button, { title: this.state.errorMessage, onClick: this.changePassword, color: 'primary', style: {
                            padding: '6px',
                            fontWeight: 'bold',
                            fontSize: '14px',
                            lineHeight: '14px',
                            margin: '0px',
                            color: this.state.errorMessage ? '#f48f8d' : '',
                        } }, "Confirm")))));
    }
}
