/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../Global';
import Ansi from 'ansi-to-react';
import NotebookUtils from '../../utils/NotebookUtils';
export class ScrollableDiv extends React.Component {
    constructor(props) {
        super(props);
        this.getFormattedContents = () => {
            var source = this.props.source;
            if (source.length == 0) {
                return (React.createElement("span", null, "No output to display."));
            }
            else {
                const lines = [];
                for (let outputLine of source) {
                    lines.push(outputLine.line);
                }
                var ansiText = NotebookUtils.fixOverwrittenChars(lines);
                return (React.createElement(Ansi, { key: lines[0] }, ansiText));
            }
            return (React.createElement(React.Fragment, null));
            // return content;
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ScrollableDivRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: { overflow: 'auto', width: '100%', height: '100%', padding: "12px", whiteSpace: 'pre' }, ref: this.element }, this.getFormattedContents()));
        };
        this.getSnapshotBeforeUpdate = (prevProps, prevState) => {
            if (this.props.autoScroll && this.element.current != null) {
                return {
                    "scrollTop": this.element.current.scrollTop,
                    "scrollHeight": this.element.current.scrollHeight,
                    "clientHeight": this.element.current.clientHeight
                };
            }
            return null;
        };
        this.componentDidUpdate = (prevProps, prevState, snapshot) => {
            if (this.props.autoScroll && snapshot != null) {
                // if (this.element.current != null) {
                var element = this.element.current;
                if (snapshot.scrollTop >= snapshot.scrollHeight - snapshot.clientHeight) {
                    element.scrollTo({
                        top: element.scrollHeight - element.clientHeight,
                        behavior: 'smooth'
                    });
                }
                // }
            }
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            if (this.props.autoScroll) {
                var element = this.element.current;
                element.scrollTo({
                    top: element.scrollHeight - element.clientHeight,
                    behavior: 'auto'
                });
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.element = React.createRef();
    }
}
