/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Button, Dialog, DialogContent, IconButton, InputAdornment, Tab, Tabs, TextField, withStyles } from '@material-ui/core';
import * as React from 'react';
import { Global } from '../../Global';
import PopupIcon from '@material-ui/icons/MoreVert';
import MuiDialogTitle from '@material-ui/core/DialogTitle';
import CloseIcon from '@material-ui/icons/Close';
import { ScrollableDiv } from './ScrollableDiv';
import { OutputFileList } from '../deploy/OutputFileList';
import CodeIcon from '@material-ui/icons/Code';
import { Status } from '../../models/Module';
import { MachineCapability } from '../../models/machine/MachineCapabilities';
import { ShadowedDivider } from '../../core';
import OpenInNewIcon from '@material-ui/icons/OpenInNew';
import Notebook from '../../core/notebook/Notebook';
import FileServerUtils from '../../utils/FileServerUtils';
const StyledDialog = withStyles({
    paper: {
        width: '80%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
export class DetailsDialog extends React.Component {
    constructor(props) {
        super(props);
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.setState({ open: true });
        };
        this.handleClose = () => {
            this.setState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleInputLineChange = (event) => {
            this.setState({ inputLine: event.target.value });
        };
        this.handleKeyDown = (event) => {
            if (event.key == 'Enter') {
                this.setState({ inputLine: '' }),
                    this.props.app.modules[0].pushModuleInput(this.state.inputLine);
            }
        };
        this.openSession = () => {
            window.open('http://localhost:' + this.props.app.sessionPort + '?token=' + this.props.app.sessionToken, '_blank');
        };
        this.openAsNewNotebook = () => {
            // ex. "1-21-2021@1:46:48PM"
            const formattedTime = new Date().toLocaleString().replace(/\//g, '-').replace(/,/g, '').replace(/ /, '@').replace(/ /, '');
            const path = this.props.app.name.replace('.ipynb', '-' + formattedTime + '.ipynb');
            var notebook = this.props.app.notebook;
            // Remove the 'installing requirements' cell
            notebook['cells'].shift();
            FileServerUtils.saveNotebook(path, notebook).then((success) => { Global.docManager.open(path); });
            // Close the dialog
            this.setState({ open: false });
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('DetailsDialogRender (' + new Date().getSeconds() + ')');
            return (React.createElement(React.Fragment, null,
                React.createElement(IconButton, { onClick: this.handleClickOpen, style: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '3px',
                    } },
                    React.createElement(PopupIcon, { style: {
                            width: '30px',
                            height: '30px',
                            padding: '3px',
                        } })),
                React.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    React.createElement(MuiDialogTitle, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        React.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '150px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            React.createElement("div", { style: { margin: 'auto', paddingLeft: '12px' } }, this.props.app.interactive ? "Session" : "Job")),
                        React.createElement("div", { style: { width: '100%', display: 'inline-flex', overflowX: 'hidden', fontSize: '16px', paddingLeft: '8px' } },
                            React.createElement("div", { style: { flexGrow: 1, margin: 'auto 0px' } }, this.props.app.name),
                            this.props.app.interactive && (React.createElement(Button, { disableElevation: true, variant: 'contained', color: 'primary', onClick: this.openSession, disabled: this.props.app.getAppStatus() == Status.Completed || !(this.props.app.modules.length > 0 && this.props.app.modules[0].sessionReady), endIcon: React.createElement(OpenInNewIcon, null) }, "OPEN SESSION")),
                            !this.props.app.interactive && (React.createElement(Button, { disableElevation: true, variant: 'contained', color: 'primary', onClick: this.openAsNewNotebook, disabled: this.props.app.getAppStatus() != Status.Completed, endIcon: React.createElement(OpenInNewIcon, null) }, "OPEN AS A NEW NOTEBOOK"))),
                        React.createElement(IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                            } },
                            React.createElement(CloseIcon, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    React.createElement(ShadowedDivider, null),
                    React.createElement("div", { style: { display: 'flex', height: 'calc(100% - 48px - 2px' } },
                        React.createElement("div", { style: { width: '150px' } },
                            React.createElement(DialogContent, { style: { padding: '0px' } },
                                React.createElement("div", { style: { padding: '6px' } },
                                    React.createElement(Tabs, { value: this.state.selectedPanel, onChange: (event, newValue) => this.setState({ selectedPanel: newValue }), orientation: 'vertical', variant: 'fullWidth', indicatorColor: 'primary', textColor: 'primary', style: { minHeight: '24px' } },
                                        React.createElement(Tab, { label: 'SUMMARY', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 0 /* SUMMARY */ }),
                                        !this.props.app.interactive && React.createElement(Tab, { label: 'NOTEBOOK', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 1 /* NOTEBOOK */ }),
                                        React.createElement(Tab, { label: 'FILES', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 2 /* FILES */ }),
                                        React.createElement(Tab, { label: 'MACHINE', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 3 /* MACHINE */ }),
                                        this.props.app.modules.length > 0 && this.props.app.interactive && React.createElement(Tab, { label: 'TERMINAL', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 4 /* TERMINAL */ }))))),
                        React.createElement(ShadowedDivider, { orientation: 'vertical' }),
                        React.createElement("div", { style: { display: 'flex', flexFlow: 'column', overflow: 'hidden', width: 'calc(100% - 150px)', height: '100%' } },
                            React.createElement(DialogContent, { style: {
                                    flexGrow: 1,
                                    overflowY: 'auto',
                                    width: '100%',
                                    height: '100%',
                                    padding: '0px',
                                    marginBottom: '0px',
                                } }, this.state.selectedPanel == 0 /* SUMMARY */ ? (React.createElement("div", { style: { padding: '12px' } },
                                this.props.app.interactive ? 'Session' : 'Job',
                                " launched at ",
                                this.props.app.timestamp.toLocaleTimeString('en-US', {
                                    hour: 'numeric', minute: 'numeric',
                                }),
                                " on ",
                                this.props.app.timestamp.toLocaleDateString('en-US', {
                                    weekday: 'long', year: 'numeric', month: 'long', day: 'numeric'
                                }),
                                React.createElement("br", null),
                                this.props.app.getTimeElapsed() ? (React.createElement(React.Fragment, null,
                                    "Duration: ",
                                    this.props.app.getTimeElapsed(),
                                    React.createElement("br", null))) : (React.createElement(React.Fragment, null)),
                                this.props.app.getCost() ? (React.createElement(React.Fragment, null,
                                    "Estimated cost: ",
                                    this.props.app.getCost(),
                                    React.createElement("br", null))) : (React.createElement(React.Fragment, null)),
                                React.createElement("br", null),
                                this.props.app.initializing.messages.map((value) => (React.createElement("span", { key: value },
                                    value,
                                    React.createElement("br", null)))),
                                this.props.app.uploading.messages.map((value) => (React.createElement("span", { key: value },
                                    value,
                                    React.createElement("br", null)))),
                                this.props.app.requisitioning.messages.map((value) => (React.createElement("span", { key: value },
                                    value,
                                    React.createElement("br", null)))),
                                this.props.app.running.messages.map((value) => (React.createElement("span", { key: value },
                                    value,
                                    React.createElement("br", null)))))) : this.state.selectedPanel == 1 /* NOTEBOOK */ ? (React.createElement("div", { style: { overflow: 'hidden', width: '100%', height: '100%' } },
                                React.createElement("div", { style: { width: '100%', height: 'calc(100% - 68px)', overflow: 'auto' } },
                                    React.createElement(Notebook, { notebook: this.props.app.notebook })),
                                React.createElement("div", { style: { padding: '6px', width: '100%' } },
                                    React.createElement(TextField, { variant: 'outlined', disabled: this.props.app.modules.length > 0 && this.props.app.modules[0].modStatus == Status.Completed, value: this.state.inputLine, onChange: this.handleInputLineChange, onKeyDown: this.handleKeyDown, style: { height: '56px', width: '100%' }, InputProps: { startAdornment: (React.createElement(InputAdornment, { position: "start" },
                                                React.createElement(CodeIcon, null)))
                                        } })))) : this.state.selectedPanel == 2 /* FILES */ ? (React.createElement("div", null, this.props.app.interactive && this.props.app.getAppStatus() != Status.Completed ? (React.createElement("div", { style: { padding: '12px' } }, "Files will appear here after your session has completed. Until then, you can upload/download files directly from the session tab.")) : (React.createElement(OutputFileList, { app: this.props.app })))) : this.state.selectedPanel == 3 /* MACHINE */ ? (React.createElement("div", null, this.props.app.machine ? (React.createElement(MachineCapability, { machine: this.props.app.machine })) : (React.createElement("div", { style: { padding: '12px' } },
                                "Machine information will appear when the ",
                                this.props.app.interactive ? ' session ' : ' job ',
                                " starts.")))) : this.state.selectedPanel == 4 /* TERMINAL */ && (React.createElement("div", { style: { overflow: 'hidden', width: '100%', height: '100%' } },
                                React.createElement(ScrollableDiv, { key: 'output', source: Object.assign([], this.props.app.modules[0].output), autoScroll: true })))))))));
        };
        this.state = {
            open: false,
            selectedPanel: 0 /* SUMMARY */,
            inputLine: ''
        };
    }
}
