/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../Global';
import { ServerConnection } from '@jupyterlab/services';
export class Rate extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('RateRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: { display: 'flex', margin: '6px' } },
                React.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '16px', lineHeight: '30px', fontWeight: 'bold' } }, "Rate"),
                React.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '14px', lineHeight: '30px', textAlign: 'right' } },
                    React.createElement("div", null,
                        "$",
                        this.state.cost.toFixed(2),
                        "/hr"))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.polling = true;
            this.receiveUpdate();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
            Global.lastMachineRate = this.state.cost;
            this.polling = false;
        };
        this.checkAndSetState = (map) => {
            if (this._isMounted) {
                this.setState(map);
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            cost: Global.lastMachineRate,
        };
    }
    async receiveUpdate() {
        const settings = ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-total-billing";
        const now = new Date();
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: now.toISOString(),
                endTime: now.toISOString(),
            }),
        };
        ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                setTimeout(() => this.receiveUpdate(), 2000);
            }
            if (response.status !== 200 && response.status !== 201) {
                if (response.status == 401) {
                    this.polling = false;
                    Global.user = null;
                }
                throw new ServerConnection.ResponseError(response);
            }
            return response.json();
        }).then((body) => {
            if (body) {
                this.checkAndSetState({ balance: body.balance, cost: body.total });
            }
        });
    }
}
