/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { Slider } from '../../../core';
import FormatUtils from '../../../utils/FormatUtils';
export class StorageComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('StorageComponentRender (' + new Date().getSeconds() + ')');
            var user = Global.user;
            return (React.createElement("div", { style: this.props.style },
                React.createElement(Slider, { getValue: this.getSizeValue, saveValue: this.saveSizeValue, minValue: -1, step: 1048576, maxValue: user.machines.absoluteStorageMaxSize, label: 'Size', color: '#89858b', showUnit: true, styledUnit: FormatUtils.styleCapacityUnit(), styledValue: FormatUtils.styleCapacityValue(), unstyledValue: FormatUtils.unstyleCapacityValue() }),
                React.createElement(Slider, { getValue: this.getIopsValue, saveValue: this.saveIopsValue, minValue: -1, maxValue: user.machines.absoluteStorageMaxIops, label: 'IOPS', color: '#89858b', showUnit: true }),
                React.createElement(Slider, { getValue: this.getThroughputValue, saveValue: this.saveThroughputValue, minValue: -1, step: 1000000, maxValue: user.machines.absoluteStorageMaxThroughput, label: 'Throughput', color: '#89858b', showUnit: true, styledUnit: FormatUtils.styleThroughputUnit(), styledValue: FormatUtils.styleThroughputValue(), unstyledValue: FormatUtils.unstyleThroughputValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getSizeValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        return storage.size[1];
        return 20;
    }
    async saveSizeValue(size) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        storage.size = [-1, size, -1];
        tracker.setMetadata(optumi);
    }
    getIopsValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        return storage.iops[1];
        return 20;
    }
    async saveIopsValue(iops) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        storage.iops = [-1, iops, -1];
        tracker.setMetadata(optumi);
    }
    getThroughputValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        return storage.throughput[1];
        return 20;
    }
    async saveThroughputValue(throughput) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        storage.throughput = [-1, throughput, -1];
        tracker.setMetadata(optumi);
    }
}
