/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { Switch } from '../../../core';
export class StorageBasic extends React.Component {
    constructor() {
        super(...arguments);
        this.handleChange = (event) => {
            const checked = event.target.checked;
            this.saveValue(checked);
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('StorageBasicRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: this.props.style },
                React.createElement(Switch, { label: 'Required', flip: true, getValue: this.getValue, saveValue: this.saveValue })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        return storage.required;
        return false;
    }
    async saveValue(checked) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        storage.required = checked;
        tracker.setMetadata(optumi);
    }
}
