/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { Divider, } from '@material-ui/core';
import { ResourceSelector } from './ResourceSelector';
import { GraphicsBasic } from './GraphicsBasic';
import { GraphicsRating } from './GraphicsRating';
import { GraphicsEquipment } from './GraphicsEquipment';
import { GraphicsComponent } from './GraphicsComponent';
import { ComputeBasic } from './ComputeBasic';
import { ComputeRating } from './ComputeRating';
import { ComputeComponent } from './ComputeComponent';
import { ComputeSimplified } from './ComputeSimplified';
import { MemoryBasic } from './MemoryBasic';
import { MemoryRating } from './MemoryRating';
import { MemoryComponent } from './MemoryComponent';
import { StorageBasic } from './StorageBasic';
import { StorageComponent } from './StorageComponent';
import { StorageRating } from './StorageRating';
import { Expertise } from '../../../models/OptumiMetadata';
import { Basic } from './Basic';
export class ResourcesPanel extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ResourcesPanelRender (' + new Date().getSeconds() + ')');
            // For non-experimental users, we only need to look at one resource to decide what mode they are in
            // const basic: boolean = Global.metadata.getMetadata().metadata.graphics.expertise == Expertise.BASIC;
            return (React.createElement("div", { style: this.props.style }, Global.user.userExpertise >= 2 ? (React.createElement(React.Fragment, null,
                React.createElement(ResourceSelector, { title: 'GPU', getValue: this.getGraphicsLevel, saveValue: this.saveGraphicsLevel, childrenLabels: [Expertise.BASIC, Expertise.RATING, Expertise.EQUIPMENT, Expertise.COMPONENT] },
                    React.createElement(GraphicsBasic, null),
                    React.createElement(GraphicsRating, null),
                    React.createElement(GraphicsEquipment, null),
                    Global.user.userExpertise >= 2 && React.createElement(GraphicsComponent, null)),
                React.createElement(Divider, { variant: 'middle' }),
                React.createElement(ResourceSelector, { title: 'CPU', getValue: this.getComputeLevel, saveValue: this.saveComputeLevel, childrenLabels: [Expertise.BASIC, Expertise.RATING, Expertise.SIMPLIFIED, Expertise.COMPONENT] },
                    React.createElement(ComputeBasic, null),
                    React.createElement(ComputeRating, null),
                    Global.user.userExpertise >= 2 && React.createElement(ComputeSimplified, null),
                    Global.user.userExpertise >= 2 && React.createElement(ComputeComponent, null)),
                React.createElement(Divider, { variant: 'middle' }),
                React.createElement(ResourceSelector, { title: 'RAM', getValue: this.getMemoryLevel, saveValue: this.saveMemoryLevel, childrenLabels: [Expertise.BASIC, Expertise.RATING, Expertise.COMPONENT] },
                    React.createElement(MemoryBasic, null),
                    React.createElement(MemoryRating, null),
                    Global.user.userExpertise >= 2 && React.createElement(MemoryComponent, null)),
                React.createElement(Divider, { variant: 'middle' }),
                React.createElement(ResourceSelector, { title: 'DSK', getValue: this.getStorageLevel, saveValue: this.saveStorageLevel, childrenLabels: [Expertise.BASIC, Expertise.RATING, Expertise.COMPONENT] },
                    React.createElement(StorageBasic, null),
                    React.createElement(StorageRating, null),
                    Global.user.userExpertise >= 2 && React.createElement(StorageComponent, null)))) : (React.createElement(React.Fragment, null,
                React.createElement(Basic, null)))));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            // This will cause the display to change when we change to a new notebook with a different level specified
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getGraphicsLevel(tracker) {
        const optumi = tracker.getMetadata();
        const graphics = optumi.metadata.graphics;
        return graphics.expertise;
    }
    async saveGraphicsLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const graphics = optumi.metadata.graphics;
        graphics.expertise = expertise;
        tracker.setMetadata(optumi);
    }
    getComputeLevel(tracker) {
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        return compute.expertise;
    }
    async saveComputeLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        compute.expertise = expertise;
        tracker.setMetadata(optumi);
    }
    getMemoryLevel(tracker) {
        const optumi = tracker.getMetadata();
        const memory = optumi.metadata.memory;
        return memory.expertise;
    }
    async saveMemoryLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const memory = optumi.metadata.memory;
        memory.expertise = expertise;
        tracker.setMetadata(optumi);
    }
    getStorageLevel(tracker) {
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        return storage.expertise;
    }
    async saveStorageLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const storage = optumi.metadata.storage;
        storage.expertise = expertise;
        tracker.setMetadata(optumi);
    }
}
