/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { IconButton } from '@material-ui/core';
import ChevronLeft from '@material-ui/icons/ChevronLeft';
import ChevronRight from '@material-ui/icons/ChevronRight';
export class ResourceSelector extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // This had to be written because ResourcePanel complained that a single element
        // was not an array, so we had to accept both and handle internally
        this.getChildren = () => {
            var children = this.props.children;
            if (children instanceof Array) {
                // The filter below allows us to remove levels conditionally (if they aren't added they evaluate as false)
                return children.filter(child => React.isValidElement(child));
            }
            else {
                var singleton = [];
                singleton.push(children);
                return singleton;
            }
        };
        this.decreaseExpertise = () => {
            const newLevel = this.state.currentLevel - 1;
            if (this.state.currentLevel > 0) {
                this.checkAndSetState({ currentLevel: newLevel });
            }
            this.props.saveValue(Global.metadata, this.props.childrenLabels[newLevel]);
        };
        this.increaseExpertise = () => {
            const newLevel = this.state.currentLevel + 1;
            if (this.state.currentLevel < this.getChildren().length - 1) {
                this.checkAndSetState({ currentLevel: newLevel });
            }
            this.props.saveValue(Global.metadata, this.props.childrenLabels[newLevel]);
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ResourceSelectorRender (' + new Date().getSeconds() + ')');
            this.props.children;
            // The padding is not in the div because the padding affects the ability to click the chevrons
            // The position and left/right on the icons is so all chevrons are aligned vertically no matter the size of the text
            // The title is in an inline-block div because we want the chevrons around the title and they use position: absolute
            // The lineHeight in the title centers the text vertically (24px comes from the chevron height from the inspector)
            return (React.createElement("div", { style: this.props.style },
                React.createElement("div", { style: { textAlign: 'center', margin: '6px' } },
                    React.createElement("div", { style: { position: 'relative', textAlign: 'center' } },
                        React.createElement(IconButton, { disabled: this.state.currentLevel <= 0 ? true : false, color: 'primary', onClick: () => this.decreaseExpertise(), style: { position: 'absolute', left: '25%', padding: '3px' } },
                            React.createElement(ChevronLeft, null)),
                        React.createElement("div", { style: { display: 'inline-block', fontSize: '16px', fontWeight: 'bold', lineHeight: '18px', margin: '6px' } }, this.props.title),
                        React.createElement(IconButton, { disabled: this.state.currentLevel >= this.getChildren().length - 1 ? true : false, color: 'primary', onClick: () => this.increaseExpertise(), style: { position: 'absolute', right: '25%', padding: '3px' } },
                            React.createElement(ChevronRight, null))),
                    this.getChildren()[this.state.currentLevel])));
        };
        this.handleMetadataChange = () => {
            this.checkAndSetState({ currentLevel: this.props.childrenLabels.indexOf(this.props.getValue(Global.metadata)) });
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.checkAndSetState = (map) => {
            if (this._isMounted) {
                this.setState(map);
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            currentLevel: this.props.childrenLabels.indexOf(this.props.getValue(Global.metadata)),
        };
    }
}
