/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { SubHeader } from '../../../core';
import { Global } from '../../../Global';
import { Expertise } from '../../../models/OptumiMetadata';
import { ComputeRating } from './ComputeRating';
import { GraphicsRating } from './GraphicsRating';
import { MemoryRating } from './MemoryRating';
import { StorageRating } from './StorageRating';
export class Rating extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('RatingRender (' + new Date().getSeconds() + ')');
            return (React.createElement(React.Fragment, null,
                React.createElement(SubHeader, { title: 'Ability' }),
                React.createElement(GraphicsRating, null),
                React.createElement(ComputeRating, null),
                React.createElement(MemoryRating, null),
                React.createElement(StorageRating, null)));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            const tracker = Global.metadata;
            const optumi = tracker.getMetadata();
            // Ser all resource levels to basic
            optumi.metadata.graphics.expertise = Expertise.RATING;
            optumi.metadata.compute.expertise = Expertise.RATING;
            optumi.metadata.memory.expertise = Expertise.RATING;
            optumi.metadata.storage.expertise = Expertise.RATING;
            tracker.setMetadata(optumi);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}
