/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { Slider } from '../../../core';
import FormatUtils from '../../../utils/FormatUtils';
export class MemoryComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('MemoryComponentRender (' + new Date().getSeconds() + ')');
            var user = Global.user;
            return (React.createElement("div", { style: this.props.style },
                React.createElement(Slider, { getValue: this.getSizeValue, saveValue: this.saveSizeValue, minValue: -1, step: 1048576, maxValue: user.machines.absoluteMemoryMaxSize, label: 'Size', color: '#89858b', showUnit: true, styledUnit: FormatUtils.styleCapacityUnit(), styledValue: FormatUtils.styleCapacityValue(), unstyledValue: FormatUtils.unstyleCapacityValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getSizeValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.metadata.memory;
        return memory.size[1];
    }
    async saveSizeValue(size) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.metadata.memory;
        memory.size = [-1, size, -1];
        tracker.setMetadata(optumi);
    }
}
