/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Switch } from '../../../core';
import { Global } from '../../../Global';
export class MemoryBasic extends React.Component {
    constructor() {
        super(...arguments);
        this.handleChange = (event) => {
            const checked = event.target.checked;
            this.saveValue(checked);
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('MemoryBasicRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: this.props.style },
                React.createElement(Switch, { label: 'Required', flip: true, getValue: this.getValue, saveValue: this.saveValue })));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.metadata.memory;
        return memory.required;
    }
    async saveValue(checked) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.metadata.memory;
        memory.required = checked;
        tracker.setMetadata(optumi);
    }
}
