/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { SubHeader } from '../../../core';
import { Global } from '../../../Global';
import { OutlinedResourceRadio } from '../OutlinedResourceRadio';
export class LaunchMode extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ComputeBasicRender (' + new Date().getSeconds() + ')');
            const value = this.getValue();
            return (React.createElement(React.Fragment, null,
                React.createElement(SubHeader, { title: 'Launch Mode' }),
                React.createElement("div", { style: {
                        alignItems: 'center',
                        marginBottom: '16px',
                        display: 'inline-flex',
                        width: '100%',
                    } },
                    React.createElement(OutlinedResourceRadio, { label: "Session", hexColor: '#afaab0', selected: value == "Session", handleClick: () => this.saveValue("Session") }),
                    React.createElement(OutlinedResourceRadio, { label: "Job", hexColor: '#afaab0', selected: value == "Job", handleClick: () => this.saveValue("Job") }))));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        return optumi.metadata.interactive ? "Session" : "Job";
    }
    saveValue(value) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.metadata.interactive = value == "Session" ? true : false;
        tracker.setMetadata(optumi);
    }
}
