/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { MenuItem, Select, withStyles } from '@material-ui/core';
const StyledSelect = withStyles({
    root: {
        fontSize: "var(--jp-ui-font-size1)",
        width: '68px',
    },
    iconOutlined: {
        right: '0px'
    }
})(Select);
const StyledMenuItem = withStyles({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        padding: '3px 3px 3px 6px',
        justifyContent: 'center',
    }
})(MenuItem);
export class GraphicsEquipment extends React.Component {
    constructor(props) {
        super(props);
        this.handleCardChange = (event) => {
            const value = event.target.value;
            this.setState({ selectedCard: value });
            this.saveCardValue(value);
            if (value != 'None') {
                const card = Global.user.machines.absoluteGraphicsMaxCards.filter(x => x.name == value).pop();
                for (var i = card.configs.length - 1; i >= 0; i--) {
                    if (this.state.selectedNumCard >= card.configs[i]) {
                        this.setState({ selectedNumCard: card.configs[i] });
                        break;
                    }
                }
            }
        };
        this.handleNumCardChange = (event) => {
            const value = event.target.value;
            if (value == -1) {
                this.setState({ selectedNumCard: value, selectedCard: 'None' });
                this.saveNumCardValue(value);
                this.saveCardValue('None');
            }
            else {
                this.setState({ selectedNumCard: value });
                this.saveNumCardValue(value);
            }
        };
        this.getCardItems = () => {
            var cardItems = new Array();
            cardItems.push(React.createElement(StyledMenuItem, { key: 'None', value: 'None' }, "Any"));
            const availableCards = Global.user.machines.absoluteGraphicsMaxCards;
            for (var i = 0; i < availableCards.length; i++) {
                var value = availableCards[i].name;
                cardItems.push(React.createElement(StyledMenuItem, { key: value, value: value }, value));
            }
            return cardItems;
        };
        this.getNumCardItems = (cardName) => {
            var numCardItems = new Array();
            numCardItems.push(React.createElement(StyledMenuItem, { key: -1, value: -1 }, 'At least 0'));
            if (cardName == 'None') {
                numCardItems.push(React.createElement(StyledMenuItem, { key: 1, value: 1 }, 'At least 1'));
                numCardItems.push(React.createElement(StyledMenuItem, { key: 2, value: 2 }, 'At least 2'));
                numCardItems.push(React.createElement(StyledMenuItem, { key: 4, value: 4 }, 'At least 4'));
            }
            else {
                const card = Global.user.machines.absoluteGraphicsMaxCards.filter(x => x.name == cardName).pop();
                if (card != undefined) {
                    for (var i = 0; i < card.configs.length; i++) {
                        var value = card.configs[i];
                        numCardItems.push(React.createElement(StyledMenuItem, { key: value, value: value }, 'At least ' + value));
                    }
                }
            }
            return numCardItems;
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('GraphicsBasicRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: { display: 'inline-flex', width: '100%', padding: '3px 0px' } },
                React.createElement("div", { style: { display: 'inline-flex', width: '100%', justifyContent: 'center' } },
                    React.createElement("div", { style: { padding: '0px 6px 0px 6px' } },
                        React.createElement(StyledSelect, { value: this.state.selectedNumCard, variant: 'outlined', onChange: this.handleNumCardChange, SelectDisplayProps: { style: { padding: '3px 20px 3px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '6px' } } } }, this.getNumCardItems(this.state.selectedCard))),
                    React.createElement("div", { style: { padding: '0px 6px 0px 6px' } },
                        React.createElement(StyledSelect, { disabled: this.state.selectedNumCard == -1, value: this.state.selectedCard, variant: 'outlined', onChange: this.handleCardChange, SelectDisplayProps: { style: { padding: '3px 20px 3px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '6px' } } } }, this.getCardItems()))),
                React.createElement("div", { 
                    // title={this.props.tooltip || ''}
                    style: {
                        minWidth: '68px',
                        lineHeight: '24px',
                        textAlign: 'center',
                        margin: '0px 6px',
                    } }, 'Cards')));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        var card = this.getCardValue();
        var numCard = this.getNumCardValue();
        // TODO:JJ Get this list of valid names/numbers from the available graphics cards
        card = ['None', 'K80', 'M60', 'P100', 'V100'].includes(card) ? card : 'None';
        numCard = [-1, 1, 2, 4].includes(numCard) ? numCard : -1;
        this.state = {
            selectedCard: numCard == -1 ? "None" : card,
            selectedNumCard: numCard,
        };
        this.saveCardValue(this.state.selectedCard);
        this.saveNumCardValue(this.state.selectedNumCard);
    }
    getCardValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.metadata.graphics;
        return graphics.boardType;
    }
    async saveCardValue(value) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.metadata.graphics;
        graphics.boardType = value;
        tracker.setMetadata(optumi);
    }
    getNumCardValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.metadata.graphics;
        return graphics.boardCount[0];
    }
    async saveNumCardValue(value) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.metadata.graphics;
        graphics.boardCount = [value, -1, -1];
        tracker.setMetadata(optumi);
    }
}
