/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { Slider } from '../../../core';
export class ComputeSimplified extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ComputeSimplifiedRender (' + new Date().getSeconds() + ')');
            var user = Global.user;
            return (React.createElement("div", { style: this.props.style },
                React.createElement(Slider, { getValue: this.getCoresValue, saveValue: this.saveCoresValue, minValue: -1, maxValue: user.machines.absoluteComputeMaxCores, label: 'Cores', color: '#f48f8d', showUnit: true })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getCoresValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        return compute.cores[0];
    }
    async saveCoresValue(cores) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        compute.cores = [cores, -1, -1];
        tracker.setMetadata(optumi);
    }
}
