/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../../Global';
import { Slider } from '../../../core';
import FormatUtils from '../../../utils/FormatUtils';
export class ComputeComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ComputeComponentRender (' + new Date().getSeconds() + ')');
            var user = Global.user;
            return (React.createElement("div", { style: this.props.style },
                React.createElement(Slider, { getValue: this.getCoresValue, saveValue: this.saveCoresValue, minValue: -1, maxValue: user.machines.absoluteComputeMaxCores, label: 'Cores', color: '#f48f8d', showUnit: true }),
                React.createElement(Slider, { getValue: this.getScoreValue, saveValue: this.saveScoreValue, minValue: -1, maxValue: user.machines.absoluteComputeMaxScore, label: 'Score', color: '#f48f8d', showUnit: true }),
                React.createElement(Slider, { getValue: this.getFrequencyValue, saveValue: this.saveFrequencyValue, minValue: -1, step: 1000000, maxValue: user.machines.absoluteComputeMaxFrequency, label: 'Frequency', color: '#f48f8d', showUnit: true, styledUnit: FormatUtils.styleFrequencyUnit(), styledValue: FormatUtils.styleFrequencyValue(), unstyledValue: FormatUtils.unstyleFrequencyValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getCoresValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        return compute.cores[1];
    }
    async saveCoresValue(cores) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        compute.cores = [-1, cores, -1];
        tracker.setMetadata(optumi);
    }
    getScoreValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        return compute.score[1];
    }
    async saveScoreValue(score) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        compute.score = [-1, score, -1];
        tracker.setMetadata(optumi);
    }
    getFrequencyValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        return compute.frequency[1];
    }
    async saveFrequencyValue(frequency) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.metadata.compute;
        compute.frequency = [-1, frequency, -1];
        tracker.setMetadata(optumi);
    }
}
