/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { SubHeader } from '../../../core';
import { Global } from '../../../Global';
import { Expertise } from '../../../models/OptumiMetadata';
import { OutlinedResourceRadio } from '../OutlinedResourceRadio';
export class Basic extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('BasicRender (' + new Date().getSeconds() + ')');
            const value = this.getValue();
            return (React.createElement(React.Fragment, null,
                React.createElement(SubHeader, { title: 'Resource Emphasis' }),
                React.createElement("div", { style: {
                        alignItems: 'center',
                        marginBottom: '16px'
                    } },
                    React.createElement(OutlinedResourceRadio, { label: "GPU", hexColor: '#ffba7d', selected: value == "GPU", handleClick: () => this.saveValue("GPU") }),
                    React.createElement(OutlinedResourceRadio, { label: "CPU", hexColor: '#f48f8d', selected: value == "CPU", handleClick: () => this.saveValue("CPU") }),
                    React.createElement(OutlinedResourceRadio, { label: "RAM", hexColor: '#afaab0', selected: value == "RAM", handleClick: () => this.saveValue("RAM") }))));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            const tracker = Global.metadata;
            const optumi = tracker.getMetadata();
            // Ser all resource levels to basic
            optumi.metadata.graphics.expertise = Expertise.BASIC;
            optumi.metadata.compute.expertise = Expertise.BASIC;
            optumi.metadata.memory.expertise = Expertise.BASIC;
            optumi.metadata.storage.expertise = Expertise.BASIC;
            // Make sure only one required flag is set to true
            if (optumi.metadata.graphics.required) {
                optumi.metadata.compute.required = false;
                optumi.metadata.memory.required = false;
                optumi.metadata.storage.required = false;
            }
            else if (optumi.metadata.compute.required) {
                optumi.metadata.graphics.required = false;
                optumi.metadata.memory.required = false;
                optumi.metadata.storage.required = false;
            }
            else if (optumi.metadata.memory.required) {
                optumi.metadata.graphics.required = false;
                optumi.metadata.compute.required = false;
                optumi.metadata.storage.required = false;
            }
            else { // By default we will set compute to required
                optumi.metadata.graphics.required = false;
                optumi.metadata.compute.required = true;
                optumi.metadata.memory.required = false;
                optumi.metadata.storage.required = false;
            }
            tracker.setMetadata(optumi);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        if (optumi.metadata.graphics.required == true)
            return "GPU";
        if (optumi.metadata.compute.required == true)
            return "CPU";
        if (optumi.metadata.memory.required == true)
            return "RAM";
        if (optumi.metadata.storage.required == true)
            return "DSK";
        return "CPU";
    }
    saveValue(value) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.metadata.graphics.required = value == "GPU" ? true : false;
        optumi.metadata.compute.required = value == "CPU" ? true : false;
        optumi.metadata.memory.required = value == "RAM" ? true : false;
        optumi.metadata.storage.required = value == "DSK" ? true : false;
        tracker.setMetadata(optumi);
    }
}
