import * as React from 'react';
import { CSSProperties } from '@material-ui/core/styles/withStyles';
export declare enum Mimetype {
    CSV = "text/csv",
    HTML5 = "text/html",
    JSON = "application/json",
    PNG = "image/png",
    PYTHON = "text/x-python",
    TEXT = "text/plain"
}
export interface FileMetadata {
    content: Array<File> | null;
    created: string;
    format: string | null;
    last_modified: string;
    mimetype: Mimetype | null;
    name: string;
    path: string;
    size: number | null;
    type: 'notebook' | 'file' | 'directory';
    writable: boolean;
}
interface IProps {
    style?: CSSProperties;
    getSelectedFiles: (getSelectedFiles: () => FileMetadata[]) => void;
}
interface IState {
    serverRoot: string;
    root: FileMetadata;
    path: FileMetadata[];
    files: FileMetadata[];
}
export default class FileBrowser extends React.Component<IProps, IState> {
    private oldOpen;
    componentDidMount: () => void;
    componentWillUnmount: () => void;
    private getSelected;
    constructor(props: IProps);
    private getSelectedFiles;
    request: (path: string) => Promise<any>;
    private handleOpen;
    render: () => JSX.Element;
}
export {};
