/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { fileIcon, folderIcon, html5Icon, imageIcon, notebookIcon, pythonIcon, spreadsheetIcon } from '@jupyterlab/ui-components';
import { Mimetype } from './FileBrowser';
export default class DirListingItemIcon extends React.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            return (React.createElement("span", { className: 'jp-DirListing-itemIcon' }, this.props.fileType === 'notebook' ? (React.createElement(notebookIcon.react, { display: 'block' })) : this.props.fileType === 'directory' ? (React.createElement(folderIcon.react, { display: 'block' })) : (() => {
                switch (this.props.mimetype) {
                    case Mimetype.CSV: return React.createElement(spreadsheetIcon.react, { display: 'block' });
                    case Mimetype.HTML5: return React.createElement(html5Icon.react, { display: 'block' });
                    case Mimetype.PNG: return React.createElement(imageIcon.react, { display: 'block' });
                    case Mimetype.PYTHON: return React.createElement(pythonIcon.react, { display: 'block' });
                    default: return React.createElement(fileIcon.react, { display: 'block' });
                }
            })()));
        };
    }
}
