/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import DirListingContent from './DirListingContent';
import { caretUpIcon, caretDownIcon } from '@jupyterlab/ui-components';
export default class DirListing extends React.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            const sort = (a, b) => {
                if (a.type !== b.type && (a.type === 'directory' || b.type === 'directory'))
                    return a.type.localeCompare(b.type);
                const sortDirection = (a, b) => a.localeCompare(b) * (this.state.sorted === 'forward' ? 1 : -1);
                if (this.state.selected === 'name') {
                    return sortDirection(a.name, b.name);
                }
                else if (this.state.selected === 'modified') {
                    return sortDirection(b.last_modified, a.last_modified);
                }
            };
            return (React.createElement("div", { className: 'jp-DirListing jp-FileBrowser-listing', style: { overflow: 'hidden' } },
                React.createElement("div", { className: 'jp-DirListing-header' },
                    React.createElement("div", { className: 'jp-DirListing-headerItem jp-id-name' + (this.state.selected === 'name' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'name') {
                                this.setState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.setState({ selected: 'name', sorted: 'forward' });
                            }
                        } },
                        React.createElement("span", { className: 'jp-DirListing-headerItemText' }, "Name"),
                        this.state.selected === 'name' && (React.createElement("span", { className: 'jp-DirListing-headerItemIcon', style: { float: 'right' } }, this.state.sorted === 'forward' ? (React.createElement(caretUpIcon.react, { container: React.createElement(React.Fragment, null) })) : (React.createElement(caretDownIcon.react, { container: React.createElement(React.Fragment, null) }))))),
                    React.createElement("div", { className: 'jp-DirListing-headerItem jp-id-modified' + (this.state.selected === 'modified' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'modified') {
                                this.setState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.setState({ selected: 'modified', sorted: 'forward' });
                            }
                        }, style: { textAlign: 'left' } },
                        React.createElement("span", { className: 'jp-DirListing-headerItemText' }, "Modified"),
                        this.state.selected === 'modified' && (React.createElement("span", { className: 'jp-DirListing-headerItemIcon', style: { float: 'right' } }, this.state.sorted === 'forward' ? (React.createElement(caretUpIcon.react, { container: React.createElement(React.Fragment, null) })) : (React.createElement(caretDownIcon.react, { container: React.createElement(React.Fragment, null) })))))),
                React.createElement(DirListingContent, { files: this.props.files, onOpen: this.props.onOpen, sort: sort, getSelected: this.props.getSelected })));
        };
        this.state = {
            selected: 'name',
            sorted: 'forward',
        };
    }
}
