/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../Global';
import { Tabs, Tab, } from '@material-ui/core';
import withStyles from '@material-ui/core/styles/withStyles';
const StyledTab = withStyles({
    root: {
        minHeight: "24px",
        padding: "6px"
    }
})(Tab);
export var Page;
(function (Page) {
    Page[Page["RESOURCES"] = 0] = "RESOURCES";
    Page[Page["FILES"] = 1] = "FILES";
})(Page || (Page = {}));
export class RequirementsBar extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleTabChange = (event, newValue) => {
            this.checkAndSetState({ page: newValue });
            Global.user.deploySubMenu = newValue;
        };
        this.handleCardChange = () => this.forceUpdate();
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            Global.user.deploySubMenuChanged.connect(this.handleCardChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.user.deploySubMenuChanged.disconnect(this.handleCardChange);
            this._isMounted = false;
        };
        this.checkAndSetState = (map) => {
            if (this._isMounted) {
                this.setState(map);
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            page: Global.user.deploySubMenu || Page.RESOURCES,
        };
    }
    render() {
        if (Global.shouldLogOnRender)
            console.log('RequirementsBarRender (' + new Date().getSeconds() + ')');
        return (React.createElement("div", { style: { width: '100%', textAlign: 'center' } },
            React.createElement(Tabs, { value: this.state.page, onChange: this.handleTabChange, variant: "fullWidth", indicatorColor: "primary", textColor: "primary", style: { padding: "0px 6px 0px 6px", minHeight: "24px" } },
                React.createElement(StyledTab, { label: "RESOURCES", style: { minWidth: "100px" } }),
                React.createElement(StyledTab, { label: "FILES", style: { minWidth: "100px" } }))));
    }
}
