/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../Global';
import withStyles from '@material-ui/core/styles/withStyles';
import { Button } from '@material-ui/core';
import RadioButtonUncheckedIcon from '@material-ui/icons/RadioButtonUnchecked';
import CheckCircleIcon from '@material-ui/icons/CheckCircle';
export class OutlinedResourceRadio extends React.Component {
    constructor(props) {
        super(props);
        this.getStyledButton = (color) => {
            return withStyles({
                root: {
                    textAlign: 'center',
                    textTransform: 'none',
                    display: 'inline-flex',
                    padding: '6px',
                    height: '40px',
                    border: '2px solid ' + color + '80',
                    borderRadius: '6px',
                    margin: '0px 6px 6px 6px',
                    width: 'calc(100% - 12px)',
                    transition: 'background-color 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms',
                    '&:hover': {
                        border: '2px solid ' + color + '80',
                        backgroundColor: color + '40'
                    },
                },
            })(Button);
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ResourceTextBoxRender (' + new Date().getSeconds() + ')');
            return (React.createElement(this.StyledButton, { style: Object.assign({
                    border: this.props.selected ? '2px solid ' + this.props.hexColor : '',
                    backgroundColor: this.props.selected ? this.props.hexColor + '40' : '',
                }, this.props.style), onClick: () => this.props.handleClick() },
                React.createElement("span", { style: { flexGrow: 1, lineHeight: '14px', margin: 'auto', textAlign: 'center' } }, this.props.label),
                this.props.selected ? (React.createElement(CheckCircleIcon, { style: { fill: this.props.hexColor, margin: 'auto' } })) : (React.createElement(RadioButtonUncheckedIcon, { style: { fill: this.props.hexColor + '80', margin: 'auto' } }))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledButton = this.getStyledButton(this.props.hexColor);
    }
}
