/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import withStyles from '@material-ui/core/styles/withStyles';
import { FullWidthTextBox, SubHeader } from '../../core';
import { OutlinedInput, IconButton } from '@material-ui/core';
import { Global } from '../../Global';
import { UploadVarMetadata } from '../../models/UploadVarMetadata';
import CloseIcon from '@material-ui/icons/Close';
import FileServerUtils from '../../utils/FileServerUtils';
import { AddFilesPopup } from './AddFilesPopup';
import DirListingItemIcon from './fileBrowser/DirListingItemIcon';
// const emDirNotFile = 'Path is a directory, not a file'
// const emDupPath = 'Duplicate file or directory'
// const emNoPath = 'Unable to find file or directory'
// const bounceAnimation = 'all 333ms cubic-bezier(0.33, 1.33, 0.66, 1) 0s'
const easeAnimation = 'all 150ms ease 0s';
export class FilesPanel extends React.Component {
    constructor(props) {
        super(props);
        this.getStyledOutlinedInput = () => {
            return withStyles({
                root: {
                    backgroundColor: 'var(--jp-layout-color1)'
                },
                input: {
                    fontSize: '12px',
                    padding: '3px 6px 3px 6px',
                },
            })(OutlinedInput);
        };
        this.getRequirementsValue = () => {
            const tracker = Global.metadata;
            const optumi = tracker.getMetadata();
            const uploads = optumi.metadata.upload;
            return uploads.requirements;
        };
        this.saveRequirements = async (value) => {
            const tracker = Global.metadata;
            const optumi = tracker.getMetadata();
            const uploads = optumi.metadata.upload;
            uploads.requirements = value;
            tracker.setMetadata(optumi);
            return '';
        };
        this.pathHasError = (path) => {
            const tracker = Global.metadata;
            const optumi = tracker.getMetadata();
            const upload = optumi.metadata.upload;
            const files = upload.fileVars;
            for (var i = 0; i < files.length; i++) {
                if (files[i].path === path)
                    return true;
            }
            return false;
        };
        this.render = () => {
            const fileVars = Global.metadata.getMetadata().metadata.upload.fileVars;
            return (React.createElement("div", { style: this.props.style },
                React.createElement("div", null,
                    React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        React.createElement(SubHeader, { title: 'Package Requirements', style: { flexGrow: 1 } }),
                        React.createElement("div", { style: { margin: 'auto 6px', opacity: 0.5, fontStyle: 'italic' } },
                            React.createElement("a", { href: 'https://pip.pypa.io/en/stable/user_guide/#requirements-files', target: '_blank' }, "learn more"))),
                    React.createElement("div", { style: { display: 'flex', width: '100%' } },
                        React.createElement(FullWidthTextBox, { multiline: true, getValue: this.getRequirementsValue, saveValue: this.saveRequirements, checkForError: () => '', placeholder: 'package==version', helperText: 'Copy requirements.txt or enter packages' }))),
                React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                    React.createElement(SubHeader, { style: { flexGrow: 1 }, title: 'File Uploads' }),
                    React.createElement(AddFilesPopup, { onFilesAdded: async (files) => {
                            for (let fileModel of files) {
                                // Don't try to add the same file/directory more than once
                                if (this.pathHasError(fileModel.path))
                                    continue;
                                const tracker = Global.metadata;
                                const optumi = tracker.getMetadata();
                                var fileVars = optumi.metadata.upload.fileVars;
                                if (fileModel.type != 'directory') {
                                    fileVars.push(new UploadVarMetadata({
                                        path: fileModel.path,
                                        type: fileModel.type,
                                        mimetype: fileModel.mimetype,
                                        files: [fileModel.path]
                                    }));
                                }
                                else {
                                    fileVars.push(new UploadVarMetadata({
                                        path: fileModel.path,
                                        type: fileModel.type,
                                        mimetype: fileModel.mimetype,
                                        files: (await FileServerUtils.getRecursiveTree(fileModel.path))
                                    }));
                                }
                                tracker.setMetadata(optumi);
                            }
                        } })),
                fileVars.length == 0 ? (React.createElement("div", { style: {
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                    } }, "No files.")) : (React.createElement(React.Fragment, null, fileVars.map((value) => (React.createElement(ResourceFile, { key: value.path, file: value, handleFileDelete: () => {
                        const tracker = Global.metadata;
                        const optumi = tracker.getMetadata();
                        const fileVars = optumi.metadata.upload.fileVars;
                        for (var i = 0; i < fileVars.length; i++) {
                            if (fileVars[i].path === value.path) {
                                fileVars.splice(i, 1);
                                break;
                            }
                        }
                        // optumi.upload.fileVars = (optumi.upload.fileVars as UploadVarMetadata[]).filter(x => x.path !== (event.currentTarget as HTMLButtonElement).id.replace('-delete', ''));
                        tracker.setMetadata(optumi);
                        if (this.state.problemFiles.includes(value.path))
                            this.setState({ problemFiles: this.state.problemFiles.filter(x => x != value.path) });
                    }, noLongerExists: this.state.problemFiles.includes(value.path) })))))));
        };
        this.refreshFiles = async () => {
            if (this.refreshingFiles) {
                setTimeout(this.refreshFiles, 60000);
                const metadata = Global.metadata.getMetadata();
                const fileVars = metadata.metadata.upload.fileVars;
                for (var file of fileVars) {
                    if (!this.refreshingFiles)
                        break;
                    if (!this.state.problemFiles.includes(file.path)) {
                        const barr = await FileServerUtils.checkIfPathExists(file.path);
                        if (!barr[0]) {
                            this.setState({ problemFiles: this.state.problemFiles.concat([file.path]) });
                        }
                    }
                }
            }
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        this.handleLabShellChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this.refreshingFiles = true;
            this.refreshFiles();
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            Global.labShell.currentChanged.connect(this.handleLabShellChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            Global.labShell.currentChanged.disconnect(this.handleLabShellChange);
            this.refreshingFiles = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledOutlinedInput = this.getStyledOutlinedInput();
        this.textField = React.createRef();
        this.state = {
            filePath: '',
            problemFiles: [],
        };
    }
}
class ResourceFile extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            return (React.createElement("div", { style: { display: 'flex', width: '100%', position: 'relative' }, onMouseOver: () => {
                    this.setState({ hovering: true });
                }, onMouseOut: () => {
                    this.setState({ hovering: false });
                } },
                React.createElement("div", { style: {
                        position: 'absolute',
                        right: '-16px',
                        display: 'inline-flex',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering ? '1' : '0',
                        transition: easeAnimation,
                    } },
                    React.createElement(IconButton, { onClick: this.props.handleFileDelete, style: {
                            width: '22px',
                            height: '22px',
                            padding: '0px',
                            position: 'relative',
                            display: 'inline-block',
                        } },
                        React.createElement(CloseIcon, { style: { position: 'relative', width: '16px', height: '16px' } }))),
                React.createElement("div", { style: {
                        width: '100%',
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                        display: 'inline-flex'
                    } },
                    React.createElement(DirListingItemIcon, { fileType: this.props.file.type, mimetype: this.props.file.mimetype }),
                    React.createElement("div", { style: {
                            margin: 'auto 0px',
                            overflow: 'hidden',
                            textOverflow: 'ellipsis',
                            whiteSpace: 'nowrap',
                            direction: 'rtl',
                            color: this.props.noLongerExists ? '#f48f8d' : ''
                        }, title: this.props.file.path }, this.props.file.path + (this.props.noLongerExists ? ' (no longer exists)' : '')))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            hovering: false,
        };
    }
}
