/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Button, Dialog, IconButton, withStyles } from '@material-ui/core';
import { Close, PlaylistAdd /*, Add*/ } from '@material-ui/icons';
import * as React from 'react';
import { Global } from '../../Global';
import MuiDialogTitle from '@material-ui/core/DialogTitle';
import { ShadowedDivider } from '../../core';
import FileBrowser from './fileBrowser/FileBrowser';
const StyledDialog = withStyles({
    paper: {
        width: 'calc(min(80%, 600px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
export class AddFilesPopup extends React.Component {
    constructor(props) {
        super(props);
        this.getSelectedFiles = () => [];
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.setState({ open: true });
        };
        this.handleClose = () => {
            this.setState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('AddFilesPopupRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: Object.assign({}, this.props.style) },
                React.createElement(IconButton, { onClick: this.handleClickOpen, style: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '3px',
                    } },
                    React.createElement(PlaylistAdd, { style: {
                            width: '30px',
                            height: '30px',
                            padding: '3px',
                        } })),
                React.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    React.createElement(MuiDialogTitle, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        React.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '225px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            React.createElement("div", { style: { margin: 'auto', paddingLeft: '12px' } }, "Select Files or Directories")),
                        React.createElement("div", { style: { width: '100%' } }),
                        React.createElement("div", { style: { width: '150px' } },
                            React.createElement(Button, { disableElevation: true, style: { width: '100%', height: '36px' }, variant: 'contained', color: 'primary', onClick: () => {
                                    this.props.onFilesAdded(this.getSelectedFiles());
                                    console.log(this.getSelectedFiles());
                                    this.handleClose();
                                } }, "ADD")),
                        React.createElement(IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                            } },
                            React.createElement(Close, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    React.createElement(ShadowedDivider, null),
                    React.createElement(FileBrowser, { style: { maxHeight: 'calc(100% - 48px - 2px)' }, getSelectedFiles: (getSelectedFiles) => this.getSelectedFiles = getSelectedFiles }))));
        };
        this.state = {
            open: false,
        };
    }
}
