/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Button, Dialog, DialogContent, IconButton, Tab, Tabs, withStyles } from '@material-ui/core';
import * as React from 'react';
import MuiDialogTitle from '@material-ui/core/DialogTitle';
import CloseIcon from '@material-ui/icons/Close';
import { Global } from '../Global';
import { ServerConnection } from '@jupyterlab/services';
import { AccountGeneralSubMenu, AccountLimitsSubMenu, AccountPaymentSubMenu } from './settings/SettingsMenu';
import { ShadowedDivider } from '../core';
import WarningPopup from '../core/WarningPopup';
const StyledDialog = withStyles({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
export class UserDialog extends React.Component {
    constructor(props) {
        super(props);
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.setState({ open: true, selectedPanel: 0 /* GENERAL */ });
        };
        this.handleClose = () => {
            this.setState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleStopClicked = (app) => {
            const settings = ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/stop-notebook";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuid: app.uuid,
                }),
            };
            ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (response.status !== 200 && response.status !== 201) {
                    if (response.status == 401)
                        Global.user = null;
                    throw new ServerConnection.ResponseError(response);
                }
            });
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('UsersDialogRender (' + new Date().getSeconds() + ')');
            var defaultProfilePicture = Global.user.name.replace(/(?<=\B)\w+/g, '').replace(/[ ]/g, '').toUpperCase();
            return (React.createElement("div", { style: Object.assign({}, this.props.style) },
                React.createElement(IconButton, { onClick: this.handleClickOpen, style: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '3px',
                    } },
                    React.createElement("div", { style: {
                            width: '24px',
                            height: '24px',
                            // margin: '6px auto',
                            borderRadius: '12px',
                            backgroundColor: '#10A0F9',
                            color: 'white',
                            fontSize: '18px',
                            fontWeight: 'bold',
                            lineHeight: '24px',
                            textAlign: 'center'
                        } }, defaultProfilePicture[defaultProfilePicture.length - 1])),
                React.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    React.createElement(MuiDialogTitle, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        React.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '150px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            React.createElement("div", { style: { margin: 'auto', paddingLeft: '12px' } }, "Settings")),
                        React.createElement("div", { style: { width: '100%' } }),
                        React.createElement("div", { style: { width: '150px' } },
                            React.createElement(WarningPopup, { open: this.state.showLogoutWithSessionPopup, headerText: "Are you sure?", bodyText: `You have a session that is currently active. If you log out, your session will be closed.`, cancel: {
                                    text: `Cancel`,
                                    onCancel: (prevent) => {
                                        this.setState({ showLogoutWithSessionPopup: false });
                                    },
                                }, continue: {
                                    text: `Close it`,
                                    onContinue: (prevent) => {
                                        this.setState({ showLogoutWithSessionPopup: false });
                                        for (let app of Global.user.appTracker.activeSessions) {
                                            this.handleStopClicked(app);
                                        }
                                        this.logout();
                                    },
                                    color: `error`,
                                } }),
                            React.createElement(Button, { disableElevation: true, style: { width: '100%', height: '36px' }, variant: "contained", color: "secondary", onClick: () => {
                                    const user = Global.user;
                                    if (user.appTracker.activeSessions.length != 0) {
                                        this.setState({ showLogoutWithSessionPopup: true });
                                    }
                                    else {
                                        this.logout();
                                    }
                                } }, "LOGOUT")),
                        React.createElement(IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                            } },
                            React.createElement(CloseIcon, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    React.createElement(ShadowedDivider, null),
                    React.createElement("div", { style: { display: 'flex', height: 'calc(100% - 48px - 2px' } },
                        React.createElement("div", { style: { width: '150px' } },
                            React.createElement(DialogContent, { style: { padding: '0px' } },
                                React.createElement("div", { style: { padding: '6px' } },
                                    React.createElement(Tabs, { value: this.state.selectedPanel, onChange: (event, newValue) => this.setState({ selectedPanel: newValue }), orientation: 'vertical', variant: 'fullWidth', indicatorColor: 'primary', textColor: 'primary', style: { minHeight: '24px' } },
                                        React.createElement(Tab, { label: 'GENERAL', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }),
                                        React.createElement(Tab, { label: 'LIMITS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }),
                                        React.createElement(Tab, { label: 'PAYMENTS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }))))),
                        React.createElement(ShadowedDivider, { orientation: 'vertical' }),
                        React.createElement("div", { style: { display: 'flex', flexFlow: 'column', overflow: 'hidden', width: 'calc(100% - 150px)', height: '100%' } },
                            React.createElement(DialogContent, { style: {
                                    flexGrow: 1,
                                    overflowY: 'auto',
                                    width: '100%',
                                    maxWidth: '450px',
                                    height: '100%',
                                    padding: '0px',
                                    marginBottom: '0px',
                                    // lineHeight: 'var(--jp-code-line-height)',
                                    fontSize: 'var(--jp-ui-font-size1)',
                                    fontFamily: 'var(--jp-ui-font-family)',
                                } },
                                React.createElement("div", { style: { display: 'flex', flexFlow: 'column', overflow: 'hidden' } }, this.state.selectedPanel == 0 /* GENERAL */ ? (React.createElement(React.Fragment, null,
                                    React.createElement("div", { style: { display: 'flex', padding: '6px 6px 0px 6px' } },
                                        React.createElement("div", { style: { width: '68px', margin: '0px 6px' } },
                                            React.createElement("div", { style: {
                                                    width: '48px',
                                                    height: '48px',
                                                    margin: '6px auto',
                                                    borderRadius: '24px',
                                                    backgroundColor: '#10A0F9',
                                                    color: 'white',
                                                    fontSize: (28 - defaultProfilePicture.length * 4) + 'px',
                                                    fontWeight: 'bold',
                                                    lineHeight: '48px',
                                                    textAlign: 'center'
                                                } }, defaultProfilePicture)),
                                        React.createElement("div", { style: { display: 'table', height: '48px', margin: '6px' } },
                                            React.createElement("div", { style: { display: 'table-cell', verticalAlign: 'middle' } },
                                                React.createElement("span", { style: { fontSize: '16px', lineHeight: '1', fontWeight: 'normal' } }, Global.user.name),
                                                React.createElement("br", null)))),
                                    React.createElement(AccountGeneralSubMenu, { style: { flexGrow: 1, overflowY: 'auto' } }))) : this.state.selectedPanel == 1 /* LIMITS */ ? (React.createElement(AccountLimitsSubMenu, { style: { flexGrow: 1, overflowY: 'auto' } })) : this.state.selectedPanel == 2 /* PAYMENT */ && (React.createElement(AccountPaymentSubMenu, { style: { flexGrow: 1, overflowY: 'auto' } })))))),
                    React.createElement("div", { style: { display: 'inline-flex' } }))));
        };
        this.state = {
            open: false,
            selectedPanel: 0 /* GENERAL */,
            showLogoutWithSessionPopup: false,
        };
    }
    // Log out of the REST interface
    logout() {
        const settings = ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/logout";
        const init = {
            method: 'GET',
        };
        ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (response.status !== 200 && response.status !== 201) {
                if (response.status == 401)
                    Global.user = null;
                throw new ServerConnection.ResponseError(response);
            }
            Global.user = null;
        });
    }
}
