/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import { Paper } from '@material-ui/core';
export var StatusColor;
(function (StatusColor) {
    StatusColor["RED"] = "#f48f8d";
    StatusColor["ORANGE"] = "#ffab61";
    StatusColor["YELLOW"] = "#fff21c";
    StatusColor["GREEN"] = "#68da7c";
    StatusColor["BLUE"] = "#10A0F9";
    StatusColor["LIGHT_BLUE"] = "#c3d7ff";
    StatusColor["PURPLE"] = "#934692";
    StatusColor["DARK_GRAY"] = "#89858b";
    StatusColor["LIGHT_GRAY"] = "#e7e5e7";
})(StatusColor || (StatusColor = {}));
export class StatusWrapper extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('StatusRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: this.props.style },
                React.createElement(Paper, { elevation: 0, style: { marginLeft: '-6px', background: this.props.statusColor } },
                    React.createElement("div", { style: { marginLeft: '6px', padding: '2px' } }, this.props.children))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}
