/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import { Divider, } from '@material-ui/core';
import { Header, SubHeader } from '../core';
// Defaults for this component
const DefaultState = {};
export class MonitorPage extends React.Component {
    constructor() {
        super(...arguments);
        this.state = DefaultState;
        this.generateActive = (apps) => {
            var sorted = apps.sort((n1, n2) => {
                if (n1.timestamp > n2.timestamp) {
                    return -1;
                }
                if (n1.timestamp < n2.timestamp) {
                    return 1;
                }
                return 0;
            });
            return sorted.map(value => (React.createElement("div", { key: value.uuid, style: { padding: '6px 0px 6px 6px' } }, value.getComponent())));
        };
        this.generateFinished = (apps) => {
            var sorted = apps.sort((n1, n2) => {
                if (n1.getEndTime() > n2.getEndTime()) {
                    return -1;
                }
                if (n1.getEndTime() < n2.getEndTime()) {
                    return 1;
                }
                return 0;
            });
            return sorted.map(value => (React.createElement("div", { key: value.uuid, style: { padding: '6px 0px 6px 6px' } }, value.getComponent())));
        };
        this.handleAppChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.user.appTracker.appsChanged.connect(this.handleAppChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.user.appTracker.appsChanged.disconnect(this.handleAppChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    // The contents of the component
    render() {
        if (Global.shouldLogOnRender)
            console.log('MonitorPageRender (' + new Date().getSeconds() + ')');
        const appTracker = Global.user.appTracker;
        return (React.createElement("div", { style: Object.assign({ overflowY: 'auto' }, this.props.style) },
            React.createElement("div", { style: { padding: '6px' } },
                React.createElement(Header, { title: "Active" }),
                appTracker.activeSessions.length != 0 ? (React.createElement(React.Fragment, null,
                    React.createElement(SubHeader, { title: "Sessions" }),
                    this.generateActive(appTracker.activeSessions))) : (React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                    React.createElement(SubHeader, { title: "Sessions" }),
                    React.createElement("div", { style: {
                            margin: '6px 0px',
                            fontSize: '14px',
                            lineHeight: '18px',
                            opacity: 0.5
                        } }, "(none)"))),
                appTracker.activeJobs.length != 0 ? (React.createElement(React.Fragment, null,
                    React.createElement(SubHeader, { title: "Jobs" }),
                    this.generateActive(appTracker.activeJobs))) : (React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                    React.createElement(SubHeader, { title: "Jobs" }),
                    React.createElement("div", { style: {
                            margin: '6px 0px',
                            fontSize: '14px',
                            lineHeight: '18px',
                            opacity: 0.5
                        } }, "(none)")))),
            (appTracker.finishedSessions.length != 0 || appTracker.finishedJobs.length == 0) && React.createElement(Divider, { variant: 'middle' }),
            React.createElement("div", { style: { padding: '6px' } },
                React.createElement(Header, { title: "Finished" }),
                appTracker.finishedSessions.length != 0 ? (React.createElement(React.Fragment, null,
                    React.createElement(SubHeader, { title: "Sessions" }),
                    this.generateFinished(appTracker.finishedSessions))) : (React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                    React.createElement(SubHeader, { title: "Sessions" }),
                    React.createElement("div", { style: {
                            margin: '6px 0px',
                            fontSize: '14px',
                            lineHeight: '18px',
                            opacity: 0.5
                        } }, "(none)"))),
                appTracker.finishedJobs.length != 0 ? (React.createElement(React.Fragment, null,
                    React.createElement(SubHeader, { title: "Jobs" }),
                    this.generateFinished(appTracker.finishedJobs))) : (React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                    React.createElement(SubHeader, { title: "Jobs" }),
                    React.createElement("div", { style: {
                            margin: '6px 0px',
                            fontSize: '14px',
                            lineHeight: '18px',
                            opacity: 0.5
                        } }, "(none)"))))));
    }
}
