///<reference path="../../node_modules/@types/node/index.d.ts"/>
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import { version } from '../widget';
import { User } from '../models/User';
import { Container, Button, TextField, Link, Typography, CircularProgress, } from '@material-ui/core';
import { ServerConnection } from '@jupyterlab/services';
// Element to display the Copyright with optumi.com link
function Copyright() {
    return (React.createElement(Typography, { style: { marginBottom: '10px' }, variant: "body2", color: "textSecondary", align: "center" },
        'Copyright © ',
        React.createElement(Link, { color: "inherit", href: "https://optumi.com/" }, "Optumi Inc")));
}
// The login screen
export class Login extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleDomainChange = (e) => {
            const value = e.target.value;
            if (new RegExp('^[A-Za-z0-9.:]*$').test(value)) {
                this.checkAndSetState({ domain: value, loginFailed: false, domainFailed: false });
            }
        };
        this.handleLoginNameChange = (e) => {
            this.checkAndSetState({ loginName: e.target.value, loginFailed: false, domainFailed: false });
        };
        this.handlePasswordChange = (e) => {
            this.checkAndSetState({ password: e.target.value, loginFailed: false, domainFailed: false });
        };
        this.handleKeyDown = (e) => {
            if (e.key === 'Enter') {
                this.login();
            }
        };
        this.checkAndSetState = (map) => {
            if (this._isMounted) {
                this.setState(map);
            }
        };
        this.handleGlobalDomainChange = () => this.checkAndSetState({ domain: Global.domain });
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            Global.onDomainChange.connect(this.handleGlobalDomainChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.onDomainChange.disconnect(this.handleGlobalDomainChange);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            domain: Global.domain,
            loginName: "",
            password: "",
            loginFailed: false,
            domainFailed: false,
            loginFailedMessage: "",
            waiting: false,
            spinning: false,
        };
    }
    // The contents of the component
    render() {
        if (Global.shouldLogOnRender)
            console.log('LoginRender (' + new Date().getSeconds() + ')');
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'jp-optumi-logo' }),
            React.createElement(Container, { style: { textAlign: 'center' }, maxWidth: "xs" },
                React.createElement(Typography, { component: "h1", variant: "h5" }, "Sign in"),
                React.createElement("form", null,
                    React.createElement(TextField, { fullWidth: true, required: true, style: { marginTop: "16px", marginBottom: "8px" }, label: "Domain", variant: "outlined", value: this.state.domain, onChange: this.handleDomainChange, onKeyDown: this.handleKeyDown, error: this.state.domainFailed, helperText: this.state.domainFailed ? "Unable to contact " + this.state.domain : "" }),
                    React.createElement(TextField, { id: 'username', name: 'username', fullWidth: true, required: true, style: { marginTop: "16px", marginBottom: "8px" }, label: "Username", variant: "outlined", value: this.state.loginName, onChange: this.handleLoginNameChange, onKeyDown: this.handleKeyDown, error: this.state.loginFailed, autoComplete: 'username' }),
                    React.createElement(TextField, { id: 'password', name: 'password', fullWidth: true, required: true, style: { marginTop: "16px", marginBottom: "8px" }, type: "password", label: "Password", variant: "outlined", value: this.state.password, onChange: this.handlePasswordChange, onKeyDown: this.handleKeyDown, error: this.state.loginFailed, helperText: this.state.loginFailed ? this.state.loginFailedMessage : "", autoComplete: 'current-password' }),
                    React.createElement(Button, { fullWidth: true, style: { marginTop: "16px", marginBottom: "8px" }, variant: "contained", color: "primary", disabled: this.state.waiting, onClick: () => this.login() }, this.state.waiting && this.state.spinning ? React.createElement(CircularProgress, { size: '1.75em' }) : 'Sign In')),
                React.createElement("div", { style: { marginTop: "30px" } }),
                React.createElement(Copyright, null))));
    }
    // Try to log into the REST interface and update state according to response
    async login() {
        this.checkAndSetState({ waiting: true, spinning: false });
        setTimeout(() => this.checkAndSetState({ spinning: true }), 1000);
        Global.domain = this.state.domain;
        const settings = ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/login";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                'domain': this.state.domain,
                'loginName': this.state.loginName,
                'password': this.state.password,
                'version': version,
            })
        };
        ServerConnection.makeRequest(url, init, settings).then((response) => {
            this.checkAndSetState({ waiting: false });
            if (response.status !== 200 && response.status !== 201) {
                this.checkAndSetState({ loginFailed: false, domainFailed: true });
                throw new ServerConnection.ResponseError(response);
            }
            return response.json();
        }, () => this.checkAndSetState({ waiting: false })).then((body) => {
            if (body.loginFailed || body.domainFailed) {
                this.checkAndSetState({ loginFailed: body.loginFailed || false, domainFailed: body.domainFailed || false, loginFailedMessage: body.loginFailedMessage || "" });
            }
            else {
                var user = User.handleLogin(body);
                Global.user = user;
                this.checkAndSetState({ loginFailed: false, domainFailed: false });
            }
        });
    }
}
