/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import { Paper } from '@material-ui/core';
export class InfoSkirt extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('StatusRender (' + new Date().getSeconds() + ')');
            return (React.createElement(Paper, { elevation: 1, style: Object.assign({ width: '100%', padding: '3px', backgroundColor: 'var(--jp-layout-color2)', borderRadius: '3px' }, this.props.style) },
                React.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                    React.createElement("div", { style: { width: '100%', margin: '3px 0px 3px 3px', overflow: 'hidden' } }, this.props.children),
                    React.createElement("div", { style: { display: 'inline-flex', minWidth: '82px', margin: '3px 3px 3px 0px' } },
                        React.createElement("div", { style: { margin: 'auto 0 auto auto' } }, this.props.leftButton),
                        React.createElement("div", { style: { margin: 'auto auto auto 0' } }, this.props.rightButton))),
                React.createElement("div", { style: { display: 'inline-flex', flexWrap: 'wrap', width: '100%' } },
                    React.createElement("div", { style: { display: 'inline-flex', flexGrow: 1 } }, this.props.tags.length == 0 ? React.createElement("div", { style: { minWidth: '74px', height: '20px' } }) : this.props.tags),
                    React.createElement("div", { style: { minWidth: '74px', justifyContent: 'right' } }, this.props.specialTag))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}
