/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import { PreviewLaunchButton } from './deploy/PreviewLaunchButton';
import { NotebookPanel } from '@jupyterlab/notebook';
import { Header, IntentSlider } from '../core';
import { FilesPanel } from './deploy/FilesPanel';
import { ResourcesPanel } from './deploy/resources/ResourcesPanel';
import { LaunchMode } from './deploy/resources/LaunchMode';
// Defaults for this component
const DefaultState = {};
export class DeployPage extends React.Component {
    constructor(props) {
        super(props);
        this.state = DefaultState;
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        this.handleLabShellChange = () => this.forceUpdate();
        this.handleTrackerChange = () => this.forceUpdate();
        this.handleMetadataChange = () => this.forceUpdate();
        this.handleUserChange = () => {
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            Global.labShell.currentChanged.connect(this.handleLabShellChange);
            Global.tracker.currentChanged.connect(this.handleTrackerChange);
            Global.tracker.selectionChanged.connect(this.handleTrackerChange);
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            Global.onUserChange.connect(this.handleUserChange);
            this.handleUserChange();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.labShell.currentChanged.disconnect(this.handleLabShellChange);
            Global.tracker.currentChanged.disconnect(this.handleTrackerChange);
            Global.tracker.selectionChanged.disconnect(this.handleTrackerChange);
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            Global.onUserChange.disconnect(this.handleUserChange);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        if (Global.tracker.currentWidget != null) {
            Global.tracker.currentWidget.context.ready.then(() => { if (this._isMounted)
                this.forceUpdate(); });
        }
    }
    getValue() {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        return optumi.metadata.intent;
    }
    async saveValue(intent) {
        const tracker = Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.metadata.intent = intent;
        tracker.setMetadata(optumi);
    }
    // The contents of the component
    render() {
        if (Global.shouldLogOnRender)
            console.log('DeployPageRender (' + new Date().getSeconds() + ')');
        return (React.createElement("div", { style: Object.assign({ overflow: 'auto' }, this.props.style) }, ((Global.labShell.currentWidget instanceof NotebookPanel) && (Global.tracker.currentWidget != null) && (Global.tracker.currentWidget.context.isReady)) ? (React.createElement(React.Fragment, null,
            React.createElement("div", { style: { padding: '6px 20px' } },
                React.createElement(Header, { title: 'Set up a new session or job' }),
                React.createElement("div", { title: Global.tracker.currentWidget.context.path, style: { margin: '6px', opacity: 0.5, fontStyle: 'italic', overflow: 'hidden', textOverflow: 'ellipsis' } }, 'Notebook: ' + Global.tracker.currentWidget.context.path.split('/').pop()),
                React.createElement(FilesPanel, null),
                React.createElement(LaunchMode, null),
                React.createElement(ResourcesPanel, null),
                React.createElement(IntentSlider, { color: '#10A0F9', getValue: this.getValue, saveValue: this.saveValue })),
            React.createElement(PreviewLaunchButton, { style: { padding: '14px 6px 6px 6px' } }))) : (React.createElement("div", { style: { textAlign: 'center', padding: "16px" } }, "Open a notebook to get started..."))));
    }
}
