/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Button, Checkbox, Divider } from '@material-ui/core';
import * as React from 'react';
import { Global } from '../Global';
import { ServerConnection } from '@jupyterlab/services';
export class Agreement extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // Log out of the REST interface (Copied from SettingsPage aside from setState call)
        this.logout = () => {
            const settings = ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/logout";
            const init = {
                method: 'GET',
            };
            ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (response.status !== 200 && response.status !== 201) {
                    if (response.status == 401)
                        Global.user = null;
                    this.checkAndSetState({ open: false });
                    throw new ServerConnection.ResponseError(response);
                }
                Global.user = null;
                this.checkAndSetState({ open: false });
            });
        };
        this.acceptAgreement = () => {
            const settings = ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/sign-agreement";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    timeOfSigning: new Date().toISOString(),
                }),
            };
            return ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (response.status !== 200 && response.status !== 201) {
                    if (response.status == 401)
                        Global.user = null;
                    throw new ServerConnection.ResponseError(response);
                }
                return response.text();
            }).then((body) => {
                Global.user.unsignedAgreement = false;
                this.props.callback();
            });
        };
        this.render = () => {
            return (React.createElement(React.Fragment, null,
                React.createElement("div", { className: 'jp-optumi-logo' }),
                React.createElement("div", { style: {
                        display: 'flex',
                        flexFlow: 'column',
                        overflow: 'hidden',
                        height: '100%',
                    } },
                    React.createElement("div", { style: {
                            padding: '0px',
                            flexGrow: 1,
                            // overflowY: 'auto',
                            overflowY: 'hidden',
                            whiteSpace: 'pre-wrap',
                            backgroundColor: 'white'
                        } },
                        React.createElement("embed", { src: Global.agreementURL, height: '100%', width: '100%' })),
                    React.createElement(Divider, { variant: 'middle' }),
                    React.createElement("div", { style: { padding: '6px', display: 'flex', justifyContent: 'center' } },
                        React.createElement(Checkbox, { checked: this.state.agreed, color: 'primary', onClick: () => this.checkAndSetState({ agreed: !this.state.agreed }), style: {
                                padding: '6px',
                                margin: '0px',
                                flexGrow: 1,
                            } }),
                        React.createElement("div", { style: {
                                padding: '6px',
                                margin: '0px',
                                flexGrow: 1,
                                fontWeight: 'bold'
                            } }, "I have read and I agree to the Optumi Terms and Conditions of Service")),
                    React.createElement("div", { style: { padding: '6px', display: 'flex', justifyContent: 'center' } },
                        React.createElement(Button, { onClick: this.logout, style: {
                                padding: '9px',
                                fontWeight: 'bold',
                                fontSize: '14px',
                                lineHeight: '14px',
                                margin: '0px',
                                flexGrow: 1,
                            } }, "LOGOUT"),
                        React.createElement(Button, { onClick: this.acceptAgreement, color: 'primary', variant: 'contained', disabled: !this.state.agreed, style: {
                                padding: '9px',
                                fontWeight: 'bold',
                                fontSize: '14px',
                                lineHeight: '14px',
                                margin: '0px',
                                flexGrow: 1,
                            } }, "I ACCEPT")))));
        };
        this.checkAndSetState = (map) => {
            if (this._isMounted) {
                this.setState(map);
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.state = {
            agreed: false,
        };
    }
}
