/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Signal } from '@lumino/signaling';
import { Machine } from "./models/machine/Machine";
import { ServerConnection } from '@jupyterlab/services';
import LogScaleUtils from "./utils/LogScaleUtils";
export class Global {
    static getStringWidth(text, font) {
        // re-use canvas object for better performance
        var context = this.canvas.getContext("2d");
        context.font = font;
        var metrics = context.measureText(text + ' ');
        return metrics.width + 1;
    }
    static get domain() { return Global._domain; }
    static set domain(domain) {
        Global._domain = domain;
        Global._onDomainChange.emit(domain);
    }
    static get onDomainChange() { return Global._onDomainChange; }
    static get shouldLogOnRender() { return Global._shouldLogOnRender; }
    static get inQuestionMode() { return Global._inQuestionMode; }
    static set inQuestionMode(inQuestionMode) {
        Global._inQuestionMode = inQuestionMode;
        Global._onInQuestionModeChange.emit(inQuestionMode);
    }
    static get jobLaunched() { return Global._jobLaunched; }
    static get onInQuestionModeChange() { return Global._onInQuestionModeChange; }
    static get lab() { return Global._lab; }
    static set lab(lab) { Global._lab = lab; }
    static get labShell() { return Global._labShell; }
    static set labShell(labShell) { Global._labShell = labShell; }
    static get themeManager() { return Global._themeManager; }
    static set themeManager(themeManager) { Global._themeManager = themeManager; }
    static get tracker() { return Global._tracker; }
    static set tracker(tracker) { Global._tracker = tracker; }
    static get metadata() { return Global._metadata; }
    static set metadata(metadata) { Global._metadata = metadata; }
    static get docManager() { return Global._docManager; }
    static set docManager(docManager) { Global._docManager = docManager; }
    static get user() { return Global._user; }
    static set user(user) {
        if (user == null)
            Global._onNullUser.emit(null);
        Global._user = user;
        // Reset cached info
        Global.lastMachines = [];
        Global.lastMachineRate = 0;
        Global.lastCreditsCost = 0;
        Global.lastCreditsBalance = 0;
        Global.lastBudgetCost = 0;
        // Signal
        Global._onUserChange.emit(user);
    }
    static get onUserChange() { return Global._onUserChange; }
    static get onNullUser() { return Global._onNullUser; }
}
Global.emitter = new Global();
Global.canvas = document.createElement("canvas");
Global._domain = "";
Global._onDomainChange = new Signal(Global.emitter);
Global._shouldLogOnRender = false;
Global._inQuestionMode = false;
Global._jobLaunched = new Signal(Global.emitter);
Global._onInQuestionModeChange = new Signal(Global.emitter);
Global._lab = undefined;
Global._labShell = undefined;
Global._themeManager = undefined;
Global._tracker = undefined;
Global._metadata = undefined;
Global._docManager = undefined;
Global._user = null; // If we are logged in we will have a user, otherwise it will be null
Global._onUserChange = new Signal(Global.emitter);
Global._onNullUser = new Signal(Global.emitter);
Global.snackbarChange = new Signal(Global.emitter);
// We will keep some state here to avoid having no information to show before a request returns
Global.lastMachines = [];
Global.lastMachineRate = 0;
Global.lastCreditsCost = 0;
Global.lastCreditsBalance = 0;
Global.lastBudgetCost = 0;
// We will use these for the steps for fractions
Global.generateFractionSteps = () => {
    const steps = new LogScaleUtils(0, 1, 0.01, 1, true).getMarks();
    steps.unshift({
        value: -1,
    });
    return steps;
};
Global.fractionMarks = Global.generateFractionSteps();
// Poll for machines in the background
Global.updateMachines = () => {
    setTimeout(Global.updateMachines, 30000);
    if (Global.user != null) {
        const settings = ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-machines";
        const init = {
            method: 'GET',
        };
        ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (response.status !== 200 && response.status !== 201) {
                throw new ServerConnection.ResponseError(response);
            }
            return response.json();
        }).then((body) => {
            var machines = [];
            for (var i = 0; i < body.machines.length; i++) {
                machines.push(Object.setPrototypeOf(body.machines[i], Machine.prototype));
            }
            Global.lastMachines = machines;
        });
    }
};
