import { User } from "./models/User";
import { Signal } from '@lumino/signaling';
import { ILabShell, JupyterFrontEnd } from "@jupyterlab/application";
import { IThemeManager } from "@jupyterlab/apputils";
import { IDocumentManager } from '@jupyterlab/docmanager';
import { Machine } from "./models/machine/Machine";
import { OptumiMetadataTracker } from "./models/OptumiMetadataTracker";
import { NotebookTracker } from "@jupyterlab/notebook";
import { Snackbar } from "./models/Snackbar";
export declare class Global {
    private static emitter;
    private static canvas;
    static getStringWidth(text: string, font: string): number;
    private static _domain;
    static get domain(): string;
    static set domain(domain: string);
    private static _onDomainChange;
    static get onDomainChange(): Signal<Global, string>;
    private static _shouldLogOnRender;
    static get shouldLogOnRender(): boolean;
    private static _inQuestionMode;
    static get inQuestionMode(): boolean;
    static set inQuestionMode(inQuestionMode: boolean);
    private static _jobLaunched;
    static get jobLaunched(): Signal<Global, void>;
    private static _onInQuestionModeChange;
    static get onInQuestionModeChange(): Signal<Global, boolean>;
    private static _lab;
    static get lab(): JupyterFrontEnd;
    static set lab(lab: JupyterFrontEnd);
    private static _labShell;
    static get labShell(): ILabShell;
    static set labShell(labShell: ILabShell);
    private static _themeManager;
    static get themeManager(): IThemeManager;
    static set themeManager(themeManager: IThemeManager);
    private static _tracker;
    static get tracker(): NotebookTracker;
    static set tracker(tracker: NotebookTracker);
    private static _metadata;
    static get metadata(): OptumiMetadataTracker;
    static set metadata(metadata: OptumiMetadataTracker);
    private static _docManager;
    static get docManager(): IDocumentManager;
    static set docManager(docManager: IDocumentManager);
    private static _user;
    static get user(): User;
    static set user(user: User);
    private static _onUserChange;
    static get onUserChange(): Signal<Global, User>;
    private static _onNullUser;
    static get onNullUser(): Signal<Global, User>;
    static agreementURL: string;
    static snackbarChange: Signal<Global, Snackbar>;
    static lastMachines: Machine[];
    static lastMachineRate: number;
    static lastCreditsCost: number;
    static lastCreditsBalance: number;
    static lastBudgetCost: number;
    private static generateFractionSteps;
    static fractionMarks: any[];
    static updateMachines: () => void;
}
