import { TerraformModule } from 'cdktf';
import { Construct } from 'constructs';
export interface TerraformAwsModulesVpcAwsOptions {
    /**
     * The Autonomous System Number (ASN) for the Amazon side of the gateway. By default the virtual private gateway is created with the current default Amazon ASN.
     * @default 64512
     */
    readonly amazonSideAsn?: string;
    /**
     * Assign IPv6 address on subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly assignIpv6AddressOnCreation?: boolean;
    /**
     * A list of availability zones names or ids in the region
     * @default
     */
    readonly azs?: string[];
    /**
     * The CIDR block for the VPC. Default value is a valid CIDR, but not acceptable by AWS and should be overridden
     * @default 0.0.0.0/0
     */
    readonly cidr?: string;
    /**
     * Controls if an internet gateway route for public database access should be created
     */
    readonly createDatabaseInternetGatewayRoute?: boolean;
    /**
     * Controls if a nat gateway route should be created to give internet access to the database subnets
     */
    readonly createDatabaseNatGatewayRoute?: boolean;
    /**
     * Controls if database subnet group should be created (n.b. database_subnets must also be set)
     * @default true
     */
    readonly createDatabaseSubnetGroup?: boolean;
    /**
     * Controls if separate route table for database should be created
     */
    readonly createDatabaseSubnetRouteTable?: boolean;
    /**
     * Controls if an Egress Only Internet Gateway is created and its related routes.
     * @default true
     */
    readonly createEgressOnlyIgw?: boolean;
    /**
     * Controls if elasticache subnet group should be created
     * @default true
     */
    readonly createElasticacheSubnetGroup?: boolean;
    /**
     * Controls if separate route table for elasticache should be created
     */
    readonly createElasticacheSubnetRouteTable?: boolean;
    /**
     * Whether to create IAM role for VPC Flow Logs
     */
    readonly createFlowLogCloudwatchIamRole?: boolean;
    /**
     * Whether to create CloudWatch log group for VPC Flow Logs
     */
    readonly createFlowLogCloudwatchLogGroup?: boolean;
    /**
     * Controls if an Internet Gateway is created for public subnets and the related routes that connect them.
     * @default true
     */
    readonly createIgw?: boolean;
    /**
     * Controls if redshift subnet group should be created
     * @default true
     */
    readonly createRedshiftSubnetGroup?: boolean;
    /**
     * Controls if separate route table for redshift should be created
     */
    readonly createRedshiftSubnetRouteTable?: boolean;
    /**
     * Controls if VPC should be created (it affects almost all resources)
     * @default true
     */
    readonly createVpc?: boolean;
    /**
     * Additional tags for the Customer Gateway
     * @default [object Object]
     */
    readonly customerGatewayTags?: {
        [key: string]: string;
    };
    /**
     * Maps of Customer Gateway's attributes (BGP ASN and Gateway's Internet-routable external IP address)
     * @default [object Object]
     */
    readonly customerGateways?: {
        [key: string]: {
            [key: string]: any;
        };
    };
    /**
     * Additional tags for the database subnets network ACL
     * @default [object Object]
     */
    readonly databaseAclTags?: {
        [key: string]: string;
    };
    /**
     * Whether to use dedicated network ACL (not default) and custom rules for database subnets
     */
    readonly databaseDedicatedNetworkAcl?: boolean;
    /**
     * Database subnets inbound network ACL rules
     * @default [object Object]
     */
    readonly databaseInboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Database subnets outbound network ACL rules
     * @default [object Object]
     */
    readonly databaseOutboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Additional tags for the database route tables
     * @default [object Object]
     */
    readonly databaseRouteTableTags?: {
        [key: string]: string;
    };
    /**
     * Assign IPv6 address on database subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly databaseSubnetAssignIpv6AddressOnCreation?: boolean;
    /**
     * Name of database subnet group
     */
    readonly databaseSubnetGroupName?: string;
    /**
     * Additional tags for the database subnet group
     * @default [object Object]
     */
    readonly databaseSubnetGroupTags?: {
        [key: string]: string;
    };
    /**
     * Assigns IPv6 database subnet id based on the Amazon provided /56 prefix base 10 integer (0-256). Must be of equal length to the corresponding IPv4 subnet list
     * @default
     */
    readonly databaseSubnetIpv6Prefixes?: string[];
    /**
     * Suffix to append to database subnets name
     * @default db
     */
    readonly databaseSubnetSuffix?: string;
    /**
     * Additional tags for the database subnets
     * @default [object Object]
     */
    readonly databaseSubnetTags?: {
        [key: string]: string;
    };
    /**
     * A list of database subnets
     * @default
     */
    readonly databaseSubnets?: string[];
    /**
     * List of maps of egress rules to set on the Default Network ACL
     * @default [object Object],[object Object]
     */
    readonly defaultNetworkAclEgress?: {
        [key: string]: string;
    }[];
    /**
     * List of maps of ingress rules to set on the Default Network ACL
     * @default [object Object],[object Object]
     */
    readonly defaultNetworkAclIngress?: {
        [key: string]: string;
    }[];
    /**
     * Name to be used on the Default Network ACL
     */
    readonly defaultNetworkAclName?: string;
    /**
     * Additional tags for the Default Network ACL
     * @default [object Object]
     */
    readonly defaultNetworkAclTags?: {
        [key: string]: string;
    };
    /**
     * List of virtual gateways for propagation
     * @default
     */
    readonly defaultRouteTablePropagatingVgws?: string[];
    /**
     * Configuration block of routes. See https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/default_route_table#route
     * @default
     */
    readonly defaultRouteTableRoutes?: {
        [key: string]: string;
    }[];
    /**
     * Additional tags for the default route table
     * @default [object Object]
     */
    readonly defaultRouteTableTags?: {
        [key: string]: string;
    };
    /**
     * List of maps of egress rules to set on the default security group
     */
    readonly defaultSecurityGroupEgress?: {
        [key: string]: string;
    }[];
    /**
     * List of maps of ingress rules to set on the default security group
     */
    readonly defaultSecurityGroupIngress?: {
        [key: string]: string;
    }[];
    /**
     * Name to be used on the default security group
     * @default default
     */
    readonly defaultSecurityGroupName?: string;
    /**
     * Additional tags for the default security group
     * @default [object Object]
     */
    readonly defaultSecurityGroupTags?: {
        [key: string]: string;
    };
    /**
     * Should be true to enable ClassicLink in the Default VPC
     */
    readonly defaultVpcEnableClassiclink?: boolean;
    /**
     * Should be true to enable DNS hostnames in the Default VPC
     */
    readonly defaultVpcEnableDnsHostnames?: boolean;
    /**
     * Should be true to enable DNS support in the Default VPC
     * @default true
     */
    readonly defaultVpcEnableDnsSupport?: boolean;
    /**
     * Name to be used on the Default VPC
     */
    readonly defaultVpcName?: string;
    /**
     * Additional tags for the Default VPC
     * @default [object Object]
     */
    readonly defaultVpcTags?: {
        [key: string]: string;
    };
    /**
     * Specifies DNS name for DHCP options set (requires enable_dhcp_options set to true)
     */
    readonly dhcpOptionsDomainName?: string;
    /**
     * Specify a list of DNS server addresses for DHCP options set, default to AWS provided (requires enable_dhcp_options set to true)
     * @default AmazonProvidedDNS
     */
    readonly dhcpOptionsDomainNameServers?: string[];
    /**
     * Specify a list of netbios servers for DHCP options set (requires enable_dhcp_options set to true)
     * @default
     */
    readonly dhcpOptionsNetbiosNameServers?: string[];
    /**
     * Specify netbios node_type for DHCP options set (requires enable_dhcp_options set to true)
     */
    readonly dhcpOptionsNetbiosNodeType?: string;
    /**
     * Specify a list of NTP servers for DHCP options set (requires enable_dhcp_options set to true)
     * @default
     */
    readonly dhcpOptionsNtpServers?: string[];
    /**
     * Additional tags for the DHCP option set (requires enable_dhcp_options set to true)
     * @default [object Object]
     */
    readonly dhcpOptionsTags?: {
        [key: string]: string;
    };
    /**
     * Additional tags for the elasticache subnets network ACL
     * @default [object Object]
     */
    readonly elasticacheAclTags?: {
        [key: string]: string;
    };
    /**
     * Whether to use dedicated network ACL (not default) and custom rules for elasticache subnets
     */
    readonly elasticacheDedicatedNetworkAcl?: boolean;
    /**
     * Elasticache subnets inbound network ACL rules
     * @default [object Object]
     */
    readonly elasticacheInboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Elasticache subnets outbound network ACL rules
     * @default [object Object]
     */
    readonly elasticacheOutboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Additional tags for the elasticache route tables
     * @default [object Object]
     */
    readonly elasticacheRouteTableTags?: {
        [key: string]: string;
    };
    /**
     * Assign IPv6 address on elasticache subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly elasticacheSubnetAssignIpv6AddressOnCreation?: boolean;
    /**
     * Name of elasticache subnet group
     */
    readonly elasticacheSubnetGroupName?: string;
    /**
     * Additional tags for the elasticache subnet group
     * @default [object Object]
     */
    readonly elasticacheSubnetGroupTags?: {
        [key: string]: string;
    };
    /**
     * Assigns IPv6 elasticache subnet id based on the Amazon provided /56 prefix base 10 integer (0-256). Must be of equal length to the corresponding IPv4 subnet list
     * @default
     */
    readonly elasticacheSubnetIpv6Prefixes?: string[];
    /**
     * Suffix to append to elasticache subnets name
     * @default elasticache
     */
    readonly elasticacheSubnetSuffix?: string;
    /**
     * Additional tags for the elasticache subnets
     * @default [object Object]
     */
    readonly elasticacheSubnetTags?: {
        [key: string]: string;
    };
    /**
     * A list of elasticache subnets
     * @default
     */
    readonly elasticacheSubnets?: string[];
    /**
     * Should be true to enable ClassicLink for the VPC. Only valid in regions and accounts that support EC2 Classic.
     */
    readonly enableClassiclink?: boolean;
    /**
     * Should be true to enable ClassicLink DNS Support for the VPC. Only valid in regions and accounts that support EC2 Classic.
     */
    readonly enableClassiclinkDnsSupport?: boolean;
    /**
     * Should be true if you want to specify a DHCP options set with a custom domain name, DNS servers, NTP servers, netbios servers, and/or netbios server type
     */
    readonly enableDhcpOptions?: boolean;
    /**
     * Should be true to enable DNS hostnames in the VPC
     */
    readonly enableDnsHostnames?: boolean;
    /**
     * Should be true to enable DNS support in the VPC
     * @default true
     */
    readonly enableDnsSupport?: boolean;
    /**
     * Whether or not to enable VPC Flow Logs
     */
    readonly enableFlowLog?: boolean;
    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.
     */
    readonly enableIpv6?: boolean;
    /**
     * Should be true if you want to provision NAT Gateways for each of your private networks
     */
    readonly enableNatGateway?: boolean;
    /**
     * Controls if redshift should have public routing table
     */
    readonly enablePublicRedshift?: boolean;
    /**
     * Should be true if you want to create a new VPN Gateway resource and attach it to the VPC
     */
    readonly enableVpnGateway?: boolean;
    /**
     * List of EIP IDs to be assigned to the NAT Gateways (used in combination with reuse_nat_ips)
     * @default
     */
    readonly externalNatIpIds?: string[];
    /**
     * List of EIPs to be used for `nat_public_ips` output (used in combination with reuse_nat_ips and external_nat_ip_ids)
     * @default
     */
    readonly externalNatIps?: string[];
    /**
     * The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group. When flow_log_destination_arn is set to ARN of Cloudwatch Logs, this argument needs to be provided.
     */
    readonly flowLogCloudwatchIamRoleArn?: string;
    /**
     * The ARN of the KMS Key to use when encrypting log data for VPC flow logs.
     */
    readonly flowLogCloudwatchLogGroupKmsKeyId?: string;
    /**
     * Specifies the name prefix of CloudWatch Log Group for VPC flow logs.
     * @default /aws/vpc-flow-log/
     */
    readonly flowLogCloudwatchLogGroupNamePrefix?: string;
    /**
     * Specifies the number of days you want to retain log events in the specified log group for VPC flow logs.
     */
    readonly flowLogCloudwatchLogGroupRetentionInDays?: number;
    /**
     * The ARN of the CloudWatch log group or S3 bucket where VPC Flow Logs will be pushed. If this ARN is a S3 bucket the appropriate permissions need to be set on that bucket's policy. When create_flow_log_cloudwatch_log_group is set to false this argument must be provided.
     */
    readonly flowLogDestinationArn?: string;
    /**
     * Type of flow log destination. Can be s3 or cloud-watch-logs.
     * @default cloud-watch-logs
     */
    readonly flowLogDestinationType?: string;
    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     */
    readonly flowLogLogFormat?: string;
    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. Valid Values: `60` seconds or `600` seconds.
     * @default 600
     */
    readonly flowLogMaxAggregationInterval?: number;
    /**
     * The type of traffic to capture. Valid values: ACCEPT, REJECT, ALL.
     * @default ALL
     */
    readonly flowLogTrafficType?: string;
    /**
     * Additional tags for the internet gateway
     * @default [object Object]
     */
    readonly igwTags?: {
        [key: string]: string;
    };
    /**
     * A tenancy option for instances launched into the VPC
     * @default default
     */
    readonly instanceTenancy?: string;
    /**
     * Additional tags for the intra subnets network ACL
     * @default [object Object]
     */
    readonly intraAclTags?: {
        [key: string]: string;
    };
    /**
     * Whether to use dedicated network ACL (not default) and custom rules for intra subnets
     */
    readonly intraDedicatedNetworkAcl?: boolean;
    /**
     * Intra subnets inbound network ACLs
     * @default [object Object]
     */
    readonly intraInboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Intra subnets outbound network ACLs
     * @default [object Object]
     */
    readonly intraOutboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Additional tags for the intra route tables
     * @default [object Object]
     */
    readonly intraRouteTableTags?: {
        [key: string]: string;
    };
    /**
     * Assign IPv6 address on intra subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly intraSubnetAssignIpv6AddressOnCreation?: boolean;
    /**
     * Assigns IPv6 intra subnet id based on the Amazon provided /56 prefix base 10 integer (0-256). Must be of equal length to the corresponding IPv4 subnet list
     * @default
     */
    readonly intraSubnetIpv6Prefixes?: string[];
    /**
     * Suffix to append to intra subnets name
     * @default intra
     */
    readonly intraSubnetSuffix?: string;
    /**
     * Additional tags for the intra subnets
     * @default [object Object]
     */
    readonly intraSubnetTags?: {
        [key: string]: string;
    };
    /**
     * A list of intra subnets
     * @default
     */
    readonly intraSubnets?: string[];
    /**
     * Should be true to adopt and manage Default Network ACL
     */
    readonly manageDefaultNetworkAcl?: boolean;
    /**
     * Should be true to manage default route table
     */
    readonly manageDefaultRouteTable?: boolean;
    /**
     * Should be true to adopt and manage default security group
     */
    readonly manageDefaultSecurityGroup?: boolean;
    /**
     * Should be true to adopt and manage Default VPC
     */
    readonly manageDefaultVpc?: boolean;
    /**
     * Should be false if you do not want to auto-assign public IP on launch
     * @default true
     */
    readonly mapPublicIpOnLaunch?: boolean;
    /**
     * Name to be used on all the resources as identifier
     */
    readonly name?: string;
    /**
     * Additional tags for the NAT EIP
     * @default [object Object]
     */
    readonly natEipTags?: {
        [key: string]: string;
    };
    /**
     * Additional tags for the NAT gateways
     * @default [object Object]
     */
    readonly natGatewayTags?: {
        [key: string]: string;
    };
    /**
     * Should be true if you want only one NAT Gateway per availability zone. Requires `var.azs` to be set, and the number of `public_subnets` created to be greater than or equal to the number of availability zones specified in `var.azs`.
     */
    readonly oneNatGatewayPerAz?: boolean;
    /**
     * Additional tags for the outpost subnets network ACL
     * @default [object Object]
     */
    readonly outpostAclTags?: {
        [key: string]: string;
    };
    /**
     * ARN of Outpost you want to create a subnet in.
     */
    readonly outpostArn?: string;
    /**
     * AZ where Outpost is anchored.
     */
    readonly outpostAz?: string;
    /**
     * Whether to use dedicated network ACL (not default) and custom rules for outpost subnets
     */
    readonly outpostDedicatedNetworkAcl?: boolean;
    /**
     * Outpost subnets inbound network ACLs
     * @default [object Object]
     */
    readonly outpostInboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Outpost subnets outbound network ACLs
     * @default [object Object]
     */
    readonly outpostOutboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Assign IPv6 address on outpost subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly outpostSubnetAssignIpv6AddressOnCreation?: boolean;
    /**
     * Assigns IPv6 outpost subnet id based on the Amazon provided /56 prefix base 10 integer (0-256). Must be of equal length to the corresponding IPv4 subnet list
     * @default
     */
    readonly outpostSubnetIpv6Prefixes?: string[];
    /**
     * Suffix to append to outpost subnets name
     * @default outpost
     */
    readonly outpostSubnetSuffix?: string;
    /**
     * Additional tags for the outpost subnets
     * @default [object Object]
     */
    readonly outpostSubnetTags?: {
        [key: string]: string;
    };
    /**
     * A list of outpost subnets inside the VPC
     * @default
     */
    readonly outpostSubnets?: string[];
    /**
     * Additional tags for the private subnets network ACL
     * @default [object Object]
     */
    readonly privateAclTags?: {
        [key: string]: string;
    };
    /**
     * Whether to use dedicated network ACL (not default) and custom rules for private subnets
     */
    readonly privateDedicatedNetworkAcl?: boolean;
    /**
     * Private subnets inbound network ACLs
     * @default [object Object]
     */
    readonly privateInboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Private subnets outbound network ACLs
     * @default [object Object]
     */
    readonly privateOutboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Additional tags for the private route tables
     * @default [object Object]
     */
    readonly privateRouteTableTags?: {
        [key: string]: string;
    };
    /**
     * Assign IPv6 address on private subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly privateSubnetAssignIpv6AddressOnCreation?: boolean;
    /**
     * Assigns IPv6 private subnet id based on the Amazon provided /56 prefix base 10 integer (0-256). Must be of equal length to the corresponding IPv4 subnet list
     * @default
     */
    readonly privateSubnetIpv6Prefixes?: string[];
    /**
     * Suffix to append to private subnets name
     * @default private
     */
    readonly privateSubnetSuffix?: string;
    /**
     * Additional tags for the private subnets
     * @default [object Object]
     */
    readonly privateSubnetTags?: {
        [key: string]: string;
    };
    /**
     * A list of private subnets inside the VPC
     * @default
     */
    readonly privateSubnets?: string[];
    /**
     * Should be true if you want route table propagation
     */
    readonly propagateIntraRouteTablesVgw?: boolean;
    /**
     * Should be true if you want route table propagation
     */
    readonly propagatePrivateRouteTablesVgw?: boolean;
    /**
     * Should be true if you want route table propagation
     */
    readonly propagatePublicRouteTablesVgw?: boolean;
    /**
     * Additional tags for the public subnets network ACL
     * @default [object Object]
     */
    readonly publicAclTags?: {
        [key: string]: string;
    };
    /**
     * Whether to use dedicated network ACL (not default) and custom rules for public subnets
     */
    readonly publicDedicatedNetworkAcl?: boolean;
    /**
     * Public subnets inbound network ACLs
     * @default [object Object]
     */
    readonly publicInboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Public subnets outbound network ACLs
     * @default [object Object]
     */
    readonly publicOutboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Additional tags for the public route tables
     * @default [object Object]
     */
    readonly publicRouteTableTags?: {
        [key: string]: string;
    };
    /**
     * Assign IPv6 address on public subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly publicSubnetAssignIpv6AddressOnCreation?: boolean;
    /**
     * Assigns IPv6 public subnet id based on the Amazon provided /56 prefix base 10 integer (0-256). Must be of equal length to the corresponding IPv4 subnet list
     * @default
     */
    readonly publicSubnetIpv6Prefixes?: string[];
    /**
     * Suffix to append to public subnets name
     * @default public
     */
    readonly publicSubnetSuffix?: string;
    /**
     * Additional tags for the public subnets
     * @default [object Object]
     */
    readonly publicSubnetTags?: {
        [key: string]: string;
    };
    /**
     * A list of public subnets inside the VPC
     * @default
     */
    readonly publicSubnets?: string[];
    /**
     * Additional tags for the redshift subnets network ACL
     * @default [object Object]
     */
    readonly redshiftAclTags?: {
        [key: string]: string;
    };
    /**
     * Whether to use dedicated network ACL (not default) and custom rules for redshift subnets
     */
    readonly redshiftDedicatedNetworkAcl?: boolean;
    /**
     * Redshift subnets inbound network ACL rules
     * @default [object Object]
     */
    readonly redshiftInboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Redshift subnets outbound network ACL rules
     * @default [object Object]
     */
    readonly redshiftOutboundAclRules?: {
        [key: string]: string;
    }[];
    /**
     * Additional tags for the redshift route tables
     * @default [object Object]
     */
    readonly redshiftRouteTableTags?: {
        [key: string]: string;
    };
    /**
     * Assign IPv6 address on redshift subnet, must be disabled to change IPv6 CIDRs. This is the IPv6 equivalent of map_public_ip_on_launch
     */
    readonly redshiftSubnetAssignIpv6AddressOnCreation?: boolean;
    /**
     * Name of redshift subnet group
     */
    readonly redshiftSubnetGroupName?: string;
    /**
     * Additional tags for the redshift subnet group
     * @default [object Object]
     */
    readonly redshiftSubnetGroupTags?: {
        [key: string]: string;
    };
    /**
     * Assigns IPv6 redshift subnet id based on the Amazon provided /56 prefix base 10 integer (0-256). Must be of equal length to the corresponding IPv4 subnet list
     * @default
     */
    readonly redshiftSubnetIpv6Prefixes?: string[];
    /**
     * Suffix to append to redshift subnets name
     * @default redshift
     */
    readonly redshiftSubnetSuffix?: string;
    /**
     * Additional tags for the redshift subnets
     * @default [object Object]
     */
    readonly redshiftSubnetTags?: {
        [key: string]: string;
    };
    /**
     * A list of redshift subnets
     * @default
     */
    readonly redshiftSubnets?: string[];
    /**
     * Should be true if you don't want EIPs to be created for your NAT Gateways and will instead pass them in via the 'external_nat_ip_ids' variable
     */
    readonly reuseNatIps?: boolean;
    /**
     * List of secondary CIDR blocks to associate with the VPC to extend the IP Address pool
     * @default
     */
    readonly secondaryCidrBlocks?: string[];
    /**
     * Should be true if you want to provision a single shared NAT Gateway across all of your private networks
     */
    readonly singleNatGateway?: boolean;
    /**
     * A map of tags to add to all resources
     * @default [object Object]
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * The ARN of the Permissions Boundary for the VPC Flow Log IAM Role
     */
    readonly vpcFlowLogPermissionsBoundary?: string;
    /**
     * Additional tags for the VPC Flow Logs
     * @default [object Object]
     */
    readonly vpcFlowLogTags?: {
        [key: string]: string;
    };
    /**
     * Additional tags for the VPC
     * @default [object Object]
     */
    readonly vpcTags?: {
        [key: string]: string;
    };
    /**
     * The Availability Zone for the VPN Gateway
     */
    readonly vpnGatewayAz?: string;
    /**
     * ID of VPN Gateway to attach to the VPC
     */
    readonly vpnGatewayId?: string;
    /**
     * Additional tags for the VPN gateway
     * @default [object Object]
     */
    readonly vpnGatewayTags?: {
        [key: string]: string;
    };
}
export declare class TerraformAwsModulesVpcAws extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, options?: TerraformAwsModulesVpcAwsOptions);
    get amazonSideAsn(): string | undefined;
    set amazonSideAsn(value: string | undefined);
    get assignIpv6AddressOnCreation(): boolean | undefined;
    set assignIpv6AddressOnCreation(value: boolean | undefined);
    get azs(): string[] | undefined;
    set azs(value: string[] | undefined);
    get cidr(): string | undefined;
    set cidr(value: string | undefined);
    get createDatabaseInternetGatewayRoute(): boolean | undefined;
    set createDatabaseInternetGatewayRoute(value: boolean | undefined);
    get createDatabaseNatGatewayRoute(): boolean | undefined;
    set createDatabaseNatGatewayRoute(value: boolean | undefined);
    get createDatabaseSubnetGroup(): boolean | undefined;
    set createDatabaseSubnetGroup(value: boolean | undefined);
    get createDatabaseSubnetRouteTable(): boolean | undefined;
    set createDatabaseSubnetRouteTable(value: boolean | undefined);
    get createEgressOnlyIgw(): boolean | undefined;
    set createEgressOnlyIgw(value: boolean | undefined);
    get createElasticacheSubnetGroup(): boolean | undefined;
    set createElasticacheSubnetGroup(value: boolean | undefined);
    get createElasticacheSubnetRouteTable(): boolean | undefined;
    set createElasticacheSubnetRouteTable(value: boolean | undefined);
    get createFlowLogCloudwatchIamRole(): boolean | undefined;
    set createFlowLogCloudwatchIamRole(value: boolean | undefined);
    get createFlowLogCloudwatchLogGroup(): boolean | undefined;
    set createFlowLogCloudwatchLogGroup(value: boolean | undefined);
    get createIgw(): boolean | undefined;
    set createIgw(value: boolean | undefined);
    get createRedshiftSubnetGroup(): boolean | undefined;
    set createRedshiftSubnetGroup(value: boolean | undefined);
    get createRedshiftSubnetRouteTable(): boolean | undefined;
    set createRedshiftSubnetRouteTable(value: boolean | undefined);
    get createVpc(): boolean | undefined;
    set createVpc(value: boolean | undefined);
    get customerGatewayTags(): {
        [key: string]: string;
    } | undefined;
    set customerGatewayTags(value: {
        [key: string]: string;
    } | undefined);
    get customerGateways(): {
        [key: string]: {
            [key: string]: any;
        };
    } | undefined;
    set customerGateways(value: {
        [key: string]: {
            [key: string]: any;
        };
    } | undefined);
    get databaseAclTags(): {
        [key: string]: string;
    } | undefined;
    set databaseAclTags(value: {
        [key: string]: string;
    } | undefined);
    get databaseDedicatedNetworkAcl(): boolean | undefined;
    set databaseDedicatedNetworkAcl(value: boolean | undefined);
    get databaseInboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set databaseInboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get databaseOutboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set databaseOutboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get databaseRouteTableTags(): {
        [key: string]: string;
    } | undefined;
    set databaseRouteTableTags(value: {
        [key: string]: string;
    } | undefined);
    get databaseSubnetAssignIpv6AddressOnCreation(): boolean | undefined;
    set databaseSubnetAssignIpv6AddressOnCreation(value: boolean | undefined);
    get databaseSubnetGroupName(): string | undefined;
    set databaseSubnetGroupName(value: string | undefined);
    get databaseSubnetGroupTags(): {
        [key: string]: string;
    } | undefined;
    set databaseSubnetGroupTags(value: {
        [key: string]: string;
    } | undefined);
    get databaseSubnetIpv6Prefixes(): string[] | undefined;
    set databaseSubnetIpv6Prefixes(value: string[] | undefined);
    get databaseSubnetSuffix(): string | undefined;
    set databaseSubnetSuffix(value: string | undefined);
    get databaseSubnetTags(): {
        [key: string]: string;
    } | undefined;
    set databaseSubnetTags(value: {
        [key: string]: string;
    } | undefined);
    get databaseSubnets(): string[] | undefined;
    set databaseSubnets(value: string[] | undefined);
    get defaultNetworkAclEgress(): {
        [key: string]: string;
    }[] | undefined;
    set defaultNetworkAclEgress(value: {
        [key: string]: string;
    }[] | undefined);
    get defaultNetworkAclIngress(): {
        [key: string]: string;
    }[] | undefined;
    set defaultNetworkAclIngress(value: {
        [key: string]: string;
    }[] | undefined);
    get defaultNetworkAclName(): string | undefined;
    set defaultNetworkAclName(value: string | undefined);
    get defaultNetworkAclTags(): {
        [key: string]: string;
    } | undefined;
    set defaultNetworkAclTags(value: {
        [key: string]: string;
    } | undefined);
    get defaultRouteTablePropagatingVgws(): string[] | undefined;
    set defaultRouteTablePropagatingVgws(value: string[] | undefined);
    get defaultRouteTableRoutes(): {
        [key: string]: string;
    }[] | undefined;
    set defaultRouteTableRoutes(value: {
        [key: string]: string;
    }[] | undefined);
    get defaultRouteTableTags(): {
        [key: string]: string;
    } | undefined;
    set defaultRouteTableTags(value: {
        [key: string]: string;
    } | undefined);
    get defaultSecurityGroupEgress(): {
        [key: string]: string;
    }[] | undefined;
    set defaultSecurityGroupEgress(value: {
        [key: string]: string;
    }[] | undefined);
    get defaultSecurityGroupIngress(): {
        [key: string]: string;
    }[] | undefined;
    set defaultSecurityGroupIngress(value: {
        [key: string]: string;
    }[] | undefined);
    get defaultSecurityGroupName(): string | undefined;
    set defaultSecurityGroupName(value: string | undefined);
    get defaultSecurityGroupTags(): {
        [key: string]: string;
    } | undefined;
    set defaultSecurityGroupTags(value: {
        [key: string]: string;
    } | undefined);
    get defaultVpcEnableClassiclink(): boolean | undefined;
    set defaultVpcEnableClassiclink(value: boolean | undefined);
    get defaultVpcEnableDnsHostnames(): boolean | undefined;
    set defaultVpcEnableDnsHostnames(value: boolean | undefined);
    get defaultVpcEnableDnsSupport(): boolean | undefined;
    set defaultVpcEnableDnsSupport(value: boolean | undefined);
    get defaultVpcName(): string | undefined;
    set defaultVpcName(value: string | undefined);
    get defaultVpcTags(): {
        [key: string]: string;
    } | undefined;
    set defaultVpcTags(value: {
        [key: string]: string;
    } | undefined);
    get dhcpOptionsDomainName(): string | undefined;
    set dhcpOptionsDomainName(value: string | undefined);
    get dhcpOptionsDomainNameServers(): string[] | undefined;
    set dhcpOptionsDomainNameServers(value: string[] | undefined);
    get dhcpOptionsNetbiosNameServers(): string[] | undefined;
    set dhcpOptionsNetbiosNameServers(value: string[] | undefined);
    get dhcpOptionsNetbiosNodeType(): string | undefined;
    set dhcpOptionsNetbiosNodeType(value: string | undefined);
    get dhcpOptionsNtpServers(): string[] | undefined;
    set dhcpOptionsNtpServers(value: string[] | undefined);
    get dhcpOptionsTags(): {
        [key: string]: string;
    } | undefined;
    set dhcpOptionsTags(value: {
        [key: string]: string;
    } | undefined);
    get elasticacheAclTags(): {
        [key: string]: string;
    } | undefined;
    set elasticacheAclTags(value: {
        [key: string]: string;
    } | undefined);
    get elasticacheDedicatedNetworkAcl(): boolean | undefined;
    set elasticacheDedicatedNetworkAcl(value: boolean | undefined);
    get elasticacheInboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set elasticacheInboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get elasticacheOutboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set elasticacheOutboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get elasticacheRouteTableTags(): {
        [key: string]: string;
    } | undefined;
    set elasticacheRouteTableTags(value: {
        [key: string]: string;
    } | undefined);
    get elasticacheSubnetAssignIpv6AddressOnCreation(): boolean | undefined;
    set elasticacheSubnetAssignIpv6AddressOnCreation(value: boolean | undefined);
    get elasticacheSubnetGroupName(): string | undefined;
    set elasticacheSubnetGroupName(value: string | undefined);
    get elasticacheSubnetGroupTags(): {
        [key: string]: string;
    } | undefined;
    set elasticacheSubnetGroupTags(value: {
        [key: string]: string;
    } | undefined);
    get elasticacheSubnetIpv6Prefixes(): string[] | undefined;
    set elasticacheSubnetIpv6Prefixes(value: string[] | undefined);
    get elasticacheSubnetSuffix(): string | undefined;
    set elasticacheSubnetSuffix(value: string | undefined);
    get elasticacheSubnetTags(): {
        [key: string]: string;
    } | undefined;
    set elasticacheSubnetTags(value: {
        [key: string]: string;
    } | undefined);
    get elasticacheSubnets(): string[] | undefined;
    set elasticacheSubnets(value: string[] | undefined);
    get enableClassiclink(): boolean | undefined;
    set enableClassiclink(value: boolean | undefined);
    get enableClassiclinkDnsSupport(): boolean | undefined;
    set enableClassiclinkDnsSupport(value: boolean | undefined);
    get enableDhcpOptions(): boolean | undefined;
    set enableDhcpOptions(value: boolean | undefined);
    get enableDnsHostnames(): boolean | undefined;
    set enableDnsHostnames(value: boolean | undefined);
    get enableDnsSupport(): boolean | undefined;
    set enableDnsSupport(value: boolean | undefined);
    get enableFlowLog(): boolean | undefined;
    set enableFlowLog(value: boolean | undefined);
    get enableIpv6(): boolean | undefined;
    set enableIpv6(value: boolean | undefined);
    get enableNatGateway(): boolean | undefined;
    set enableNatGateway(value: boolean | undefined);
    get enablePublicRedshift(): boolean | undefined;
    set enablePublicRedshift(value: boolean | undefined);
    get enableVpnGateway(): boolean | undefined;
    set enableVpnGateway(value: boolean | undefined);
    get externalNatIpIds(): string[] | undefined;
    set externalNatIpIds(value: string[] | undefined);
    get externalNatIps(): string[] | undefined;
    set externalNatIps(value: string[] | undefined);
    get flowLogCloudwatchIamRoleArn(): string | undefined;
    set flowLogCloudwatchIamRoleArn(value: string | undefined);
    get flowLogCloudwatchLogGroupKmsKeyId(): string | undefined;
    set flowLogCloudwatchLogGroupKmsKeyId(value: string | undefined);
    get flowLogCloudwatchLogGroupNamePrefix(): string | undefined;
    set flowLogCloudwatchLogGroupNamePrefix(value: string | undefined);
    get flowLogCloudwatchLogGroupRetentionInDays(): number | undefined;
    set flowLogCloudwatchLogGroupRetentionInDays(value: number | undefined);
    get flowLogDestinationArn(): string | undefined;
    set flowLogDestinationArn(value: string | undefined);
    get flowLogDestinationType(): string | undefined;
    set flowLogDestinationType(value: string | undefined);
    get flowLogLogFormat(): string | undefined;
    set flowLogLogFormat(value: string | undefined);
    get flowLogMaxAggregationInterval(): number | undefined;
    set flowLogMaxAggregationInterval(value: number | undefined);
    get flowLogTrafficType(): string | undefined;
    set flowLogTrafficType(value: string | undefined);
    get igwTags(): {
        [key: string]: string;
    } | undefined;
    set igwTags(value: {
        [key: string]: string;
    } | undefined);
    get instanceTenancy(): string | undefined;
    set instanceTenancy(value: string | undefined);
    get intraAclTags(): {
        [key: string]: string;
    } | undefined;
    set intraAclTags(value: {
        [key: string]: string;
    } | undefined);
    get intraDedicatedNetworkAcl(): boolean | undefined;
    set intraDedicatedNetworkAcl(value: boolean | undefined);
    get intraInboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set intraInboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get intraOutboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set intraOutboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get intraRouteTableTags(): {
        [key: string]: string;
    } | undefined;
    set intraRouteTableTags(value: {
        [key: string]: string;
    } | undefined);
    get intraSubnetAssignIpv6AddressOnCreation(): boolean | undefined;
    set intraSubnetAssignIpv6AddressOnCreation(value: boolean | undefined);
    get intraSubnetIpv6Prefixes(): string[] | undefined;
    set intraSubnetIpv6Prefixes(value: string[] | undefined);
    get intraSubnetSuffix(): string | undefined;
    set intraSubnetSuffix(value: string | undefined);
    get intraSubnetTags(): {
        [key: string]: string;
    } | undefined;
    set intraSubnetTags(value: {
        [key: string]: string;
    } | undefined);
    get intraSubnets(): string[] | undefined;
    set intraSubnets(value: string[] | undefined);
    get manageDefaultNetworkAcl(): boolean | undefined;
    set manageDefaultNetworkAcl(value: boolean | undefined);
    get manageDefaultRouteTable(): boolean | undefined;
    set manageDefaultRouteTable(value: boolean | undefined);
    get manageDefaultSecurityGroup(): boolean | undefined;
    set manageDefaultSecurityGroup(value: boolean | undefined);
    get manageDefaultVpc(): boolean | undefined;
    set manageDefaultVpc(value: boolean | undefined);
    get mapPublicIpOnLaunch(): boolean | undefined;
    set mapPublicIpOnLaunch(value: boolean | undefined);
    get name(): string | undefined;
    set name(value: string | undefined);
    get natEipTags(): {
        [key: string]: string;
    } | undefined;
    set natEipTags(value: {
        [key: string]: string;
    } | undefined);
    get natGatewayTags(): {
        [key: string]: string;
    } | undefined;
    set natGatewayTags(value: {
        [key: string]: string;
    } | undefined);
    get oneNatGatewayPerAz(): boolean | undefined;
    set oneNatGatewayPerAz(value: boolean | undefined);
    get outpostAclTags(): {
        [key: string]: string;
    } | undefined;
    set outpostAclTags(value: {
        [key: string]: string;
    } | undefined);
    get outpostArn(): string | undefined;
    set outpostArn(value: string | undefined);
    get outpostAz(): string | undefined;
    set outpostAz(value: string | undefined);
    get outpostDedicatedNetworkAcl(): boolean | undefined;
    set outpostDedicatedNetworkAcl(value: boolean | undefined);
    get outpostInboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set outpostInboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get outpostOutboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set outpostOutboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get outpostSubnetAssignIpv6AddressOnCreation(): boolean | undefined;
    set outpostSubnetAssignIpv6AddressOnCreation(value: boolean | undefined);
    get outpostSubnetIpv6Prefixes(): string[] | undefined;
    set outpostSubnetIpv6Prefixes(value: string[] | undefined);
    get outpostSubnetSuffix(): string | undefined;
    set outpostSubnetSuffix(value: string | undefined);
    get outpostSubnetTags(): {
        [key: string]: string;
    } | undefined;
    set outpostSubnetTags(value: {
        [key: string]: string;
    } | undefined);
    get outpostSubnets(): string[] | undefined;
    set outpostSubnets(value: string[] | undefined);
    get privateAclTags(): {
        [key: string]: string;
    } | undefined;
    set privateAclTags(value: {
        [key: string]: string;
    } | undefined);
    get privateDedicatedNetworkAcl(): boolean | undefined;
    set privateDedicatedNetworkAcl(value: boolean | undefined);
    get privateInboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set privateInboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get privateOutboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set privateOutboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get privateRouteTableTags(): {
        [key: string]: string;
    } | undefined;
    set privateRouteTableTags(value: {
        [key: string]: string;
    } | undefined);
    get privateSubnetAssignIpv6AddressOnCreation(): boolean | undefined;
    set privateSubnetAssignIpv6AddressOnCreation(value: boolean | undefined);
    get privateSubnetIpv6Prefixes(): string[] | undefined;
    set privateSubnetIpv6Prefixes(value: string[] | undefined);
    get privateSubnetSuffix(): string | undefined;
    set privateSubnetSuffix(value: string | undefined);
    get privateSubnetTags(): {
        [key: string]: string;
    } | undefined;
    set privateSubnetTags(value: {
        [key: string]: string;
    } | undefined);
    get privateSubnets(): string[] | undefined;
    set privateSubnets(value: string[] | undefined);
    get propagateIntraRouteTablesVgw(): boolean | undefined;
    set propagateIntraRouteTablesVgw(value: boolean | undefined);
    get propagatePrivateRouteTablesVgw(): boolean | undefined;
    set propagatePrivateRouteTablesVgw(value: boolean | undefined);
    get propagatePublicRouteTablesVgw(): boolean | undefined;
    set propagatePublicRouteTablesVgw(value: boolean | undefined);
    get publicAclTags(): {
        [key: string]: string;
    } | undefined;
    set publicAclTags(value: {
        [key: string]: string;
    } | undefined);
    get publicDedicatedNetworkAcl(): boolean | undefined;
    set publicDedicatedNetworkAcl(value: boolean | undefined);
    get publicInboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set publicInboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get publicOutboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set publicOutboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get publicRouteTableTags(): {
        [key: string]: string;
    } | undefined;
    set publicRouteTableTags(value: {
        [key: string]: string;
    } | undefined);
    get publicSubnetAssignIpv6AddressOnCreation(): boolean | undefined;
    set publicSubnetAssignIpv6AddressOnCreation(value: boolean | undefined);
    get publicSubnetIpv6Prefixes(): string[] | undefined;
    set publicSubnetIpv6Prefixes(value: string[] | undefined);
    get publicSubnetSuffix(): string | undefined;
    set publicSubnetSuffix(value: string | undefined);
    get publicSubnetTags(): {
        [key: string]: string;
    } | undefined;
    set publicSubnetTags(value: {
        [key: string]: string;
    } | undefined);
    get publicSubnets(): string[] | undefined;
    set publicSubnets(value: string[] | undefined);
    get redshiftAclTags(): {
        [key: string]: string;
    } | undefined;
    set redshiftAclTags(value: {
        [key: string]: string;
    } | undefined);
    get redshiftDedicatedNetworkAcl(): boolean | undefined;
    set redshiftDedicatedNetworkAcl(value: boolean | undefined);
    get redshiftInboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set redshiftInboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get redshiftOutboundAclRules(): {
        [key: string]: string;
    }[] | undefined;
    set redshiftOutboundAclRules(value: {
        [key: string]: string;
    }[] | undefined);
    get redshiftRouteTableTags(): {
        [key: string]: string;
    } | undefined;
    set redshiftRouteTableTags(value: {
        [key: string]: string;
    } | undefined);
    get redshiftSubnetAssignIpv6AddressOnCreation(): boolean | undefined;
    set redshiftSubnetAssignIpv6AddressOnCreation(value: boolean | undefined);
    get redshiftSubnetGroupName(): string | undefined;
    set redshiftSubnetGroupName(value: string | undefined);
    get redshiftSubnetGroupTags(): {
        [key: string]: string;
    } | undefined;
    set redshiftSubnetGroupTags(value: {
        [key: string]: string;
    } | undefined);
    get redshiftSubnetIpv6Prefixes(): string[] | undefined;
    set redshiftSubnetIpv6Prefixes(value: string[] | undefined);
    get redshiftSubnetSuffix(): string | undefined;
    set redshiftSubnetSuffix(value: string | undefined);
    get redshiftSubnetTags(): {
        [key: string]: string;
    } | undefined;
    set redshiftSubnetTags(value: {
        [key: string]: string;
    } | undefined);
    get redshiftSubnets(): string[] | undefined;
    set redshiftSubnets(value: string[] | undefined);
    get reuseNatIps(): boolean | undefined;
    set reuseNatIps(value: boolean | undefined);
    get secondaryCidrBlocks(): string[] | undefined;
    set secondaryCidrBlocks(value: string[] | undefined);
    get singleNatGateway(): boolean | undefined;
    set singleNatGateway(value: boolean | undefined);
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcFlowLogPermissionsBoundary(): string | undefined;
    set vpcFlowLogPermissionsBoundary(value: string | undefined);
    get vpcFlowLogTags(): {
        [key: string]: string;
    } | undefined;
    set vpcFlowLogTags(value: {
        [key: string]: string;
    } | undefined);
    get vpcTags(): {
        [key: string]: string;
    } | undefined;
    set vpcTags(value: {
        [key: string]: string;
    } | undefined);
    get vpnGatewayAz(): string | undefined;
    set vpnGatewayAz(value: string | undefined);
    get vpnGatewayId(): string | undefined;
    set vpnGatewayId(value: string | undefined);
    get vpnGatewayTags(): {
        [key: string]: string;
    } | undefined;
    set vpnGatewayTags(value: {
        [key: string]: string;
    } | undefined);
    get azsOutput(): string;
    get cgwArnsOutput(): string;
    get cgwIdsOutput(): string;
    get databaseInternetGatewayRouteIdOutput(): string;
    get databaseIpv6EgressRouteIdOutput(): string;
    get databaseNatGatewayRouteIdsOutput(): string;
    get databaseNetworkAclArnOutput(): string;
    get databaseNetworkAclIdOutput(): string;
    get databaseRouteTableAssociationIdsOutput(): string;
    get databaseRouteTableIdsOutput(): string;
    get databaseSubnetArnsOutput(): string;
    get databaseSubnetGroupOutput(): string;
    get databaseSubnetGroupNameOutput(): string;
    get databaseSubnetsOutput(): string;
    get databaseSubnetsCidrBlocksOutput(): string;
    get databaseSubnetsIpv6CidrBlocksOutput(): string;
    get defaultNetworkAclIdOutput(): string;
    get defaultRouteTableIdOutput(): string;
    get defaultSecurityGroupIdOutput(): string;
    get defaultVpcArnOutput(): string;
    get defaultVpcCidrBlockOutput(): string;
    get defaultVpcDefaultNetworkAclIdOutput(): string;
    get defaultVpcDefaultRouteTableIdOutput(): string;
    get defaultVpcDefaultSecurityGroupIdOutput(): string;
    get defaultVpcEnableDnsHostnamesOutput(): string;
    get defaultVpcEnableDnsSupportOutput(): string;
    get defaultVpcIdOutput(): string;
    get defaultVpcInstanceTenancyOutput(): string;
    get defaultVpcMainRouteTableIdOutput(): string;
    get dhcpOptionsIdOutput(): string;
    get egressOnlyInternetGatewayIdOutput(): string;
    get elasticacheNetworkAclArnOutput(): string;
    get elasticacheNetworkAclIdOutput(): string;
    get elasticacheRouteTableAssociationIdsOutput(): string;
    get elasticacheRouteTableIdsOutput(): string;
    get elasticacheSubnetArnsOutput(): string;
    get elasticacheSubnetGroupOutput(): string;
    get elasticacheSubnetGroupNameOutput(): string;
    get elasticacheSubnetsOutput(): string;
    get elasticacheSubnetsCidrBlocksOutput(): string;
    get elasticacheSubnetsIpv6CidrBlocksOutput(): string;
    get igwArnOutput(): string;
    get igwIdOutput(): string;
    get intraNetworkAclArnOutput(): string;
    get intraNetworkAclIdOutput(): string;
    get intraRouteTableAssociationIdsOutput(): string;
    get intraRouteTableIdsOutput(): string;
    get intraSubnetArnsOutput(): string;
    get intraSubnetsOutput(): string;
    get intraSubnetsCidrBlocksOutput(): string;
    get intraSubnetsIpv6CidrBlocksOutput(): string;
    get nameOutput(): string;
    get natIdsOutput(): string;
    get natPublicIpsOutput(): string;
    get natgwIdsOutput(): string;
    get outpostNetworkAclArnOutput(): string;
    get outpostNetworkAclIdOutput(): string;
    get outpostSubnetArnsOutput(): string;
    get outpostSubnetsOutput(): string;
    get outpostSubnetsCidrBlocksOutput(): string;
    get outpostSubnetsIpv6CidrBlocksOutput(): string;
    get privateIpv6EgressRouteIdsOutput(): string;
    get privateNatGatewayRouteIdsOutput(): string;
    get privateNetworkAclArnOutput(): string;
    get privateNetworkAclIdOutput(): string;
    get privateRouteTableAssociationIdsOutput(): string;
    get privateRouteTableIdsOutput(): string;
    get privateSubnetArnsOutput(): string;
    get privateSubnetsOutput(): string;
    get privateSubnetsCidrBlocksOutput(): string;
    get privateSubnetsIpv6CidrBlocksOutput(): string;
    get publicInternetGatewayIpv6RouteIdOutput(): string;
    get publicInternetGatewayRouteIdOutput(): string;
    get publicNetworkAclArnOutput(): string;
    get publicNetworkAclIdOutput(): string;
    get publicRouteTableAssociationIdsOutput(): string;
    get publicRouteTableIdsOutput(): string;
    get publicSubnetArnsOutput(): string;
    get publicSubnetsOutput(): string;
    get publicSubnetsCidrBlocksOutput(): string;
    get publicSubnetsIpv6CidrBlocksOutput(): string;
    get redshiftNetworkAclArnOutput(): string;
    get redshiftNetworkAclIdOutput(): string;
    get redshiftPublicRouteTableAssociationIdsOutput(): string;
    get redshiftRouteTableAssociationIdsOutput(): string;
    get redshiftRouteTableIdsOutput(): string;
    get redshiftSubnetArnsOutput(): string;
    get redshiftSubnetGroupOutput(): string;
    get redshiftSubnetsOutput(): string;
    get redshiftSubnetsCidrBlocksOutput(): string;
    get redshiftSubnetsIpv6CidrBlocksOutput(): string;
    get thisCustomerGatewayOutput(): string;
    get vgwArnOutput(): string;
    get vgwIdOutput(): string;
    get vpcArnOutput(): string;
    get vpcCidrBlockOutput(): string;
    get vpcEnableDnsHostnamesOutput(): string;
    get vpcEnableDnsSupportOutput(): string;
    get vpcFlowLogCloudwatchIamRoleArnOutput(): string;
    get vpcFlowLogDestinationArnOutput(): string;
    get vpcFlowLogDestinationTypeOutput(): string;
    get vpcFlowLogIdOutput(): string;
    get vpcIdOutput(): string;
    get vpcInstanceTenancyOutput(): string;
    get vpcIpv6AssociationIdOutput(): string;
    get vpcIpv6CidrBlockOutput(): string;
    get vpcMainRouteTableIdOutput(): string;
    get vpcOwnerIdOutput(): string;
    get vpcSecondaryCidrBlocksOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
