/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.RaphtoryStringUtils;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.holders.NullableVarCharHolder;

public abstract class SchemaFieldAccessor {
    protected int _fieldIndex;

    protected void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
        this._fieldIndex = n;
    }

    public abstract void store(EntityFieldAccessor var1, int var2);

    public abstract void load(EntityFieldAccessor var1, int var2);

    public static final class StringFieldAccessor
    extends SchemaFieldAccessor {
        private VarCharVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof VarCharVector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (VarCharVector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                NullableVarCharHolder nullableVarCharHolder = RaphtoryStringUtils.getTmpVarCharHolder();
                byte[] byArray = RaphtoryStringUtils.copy(entityFieldAccessor.getString(), nullableVarCharHolder);
                int n2 = nullableVarCharHolder.end - nullableVarCharHolder.start;
                this._vector.setSafe(n, byArray, nullableVarCharHolder.start, nullableVarCharHolder.end - nullableVarCharHolder.start);
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            NullableVarCharHolder nullableVarCharHolder = RaphtoryStringUtils.getTmpVarCharHolder();
            this._vector.get(n, nullableVarCharHolder);
            if (nullableVarCharHolder.isSet != 0) {
                StringBuilder stringBuilder = entityFieldAccessor.getString();
                stringBuilder.setLength(0);
                RaphtoryStringUtils.copy(nullableVarCharHolder, stringBuilder);
            } else {
                entityFieldAccessor.reset();
            }
        }
    }

    public static final class BooleanFieldAccessor
    extends SchemaFieldAccessor {
        private BitVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof BitVector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (BitVector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                this._vector.setSafe(n, entityFieldAccessor.getBoolean() ? 1 : 0);
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                entityFieldAccessor.set(this._vector.get(n) != 0);
            } else {
                entityFieldAccessor.reset();
            }
        }
    }

    public static final class DoubleFieldAccessor
    extends SchemaFieldAccessor {
        private Float8Vector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof Float8Vector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (Float8Vector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                this._vector.setSafe(n, entityFieldAccessor.getDouble());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                entityFieldAccessor.set(this._vector.get(n));
            } else {
                entityFieldAccessor.reset();
            }
        }
    }

    public static final class FloatFieldAccessor
    extends SchemaFieldAccessor {
        private Float4Vector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof Float4Vector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (Float4Vector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                this._vector.setSafe(n, entityFieldAccessor.getFloat());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                entityFieldAccessor.set(this._vector.get(n));
            } else {
                entityFieldAccessor.reset();
            }
        }
    }

    public static final class LongFieldAccessor
    extends SchemaFieldAccessor {
        private BigIntVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof BigIntVector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (BigIntVector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                this._vector.setSafe(n, entityFieldAccessor.getLong());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                entityFieldAccessor.set(this._vector.get(n));
            } else {
                entityFieldAccessor.reset();
            }
        }
    }

    public static final class IntFieldAccessor
    extends SchemaFieldAccessor {
        private IntVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof IntVector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (IntVector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                this._vector.setSafe(n, entityFieldAccessor.getInt());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                entityFieldAccessor.set(this._vector.get(n));
            } else {
                entityFieldAccessor.reset();
            }
        }
    }

    public static final class ShortFieldAccessor
    extends SchemaFieldAccessor {
        private SmallIntVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof SmallIntVector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (SmallIntVector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                this._vector.setSafe(n, entityFieldAccessor.getShort());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                entityFieldAccessor.set(this._vector.get(n));
            } else {
                entityFieldAccessor.reset();
            }
        }
    }

    public static final class ByteFieldAccessor
    extends SchemaFieldAccessor {
        private TinyIntVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot, int n) {
            super.initialise(vectorSchemaRoot, n);
            FieldVector fieldVector = vectorSchemaRoot.getVector(n);
            if (fieldVector == null || !(fieldVector instanceof TinyIntVector)) {
                throw new IllegalArgumentException();
            }
            this._vector = (TinyIntVector)fieldVector;
        }

        @Override
        public void store(EntityFieldAccessor entityFieldAccessor, int n) {
            if (entityFieldAccessor.isSet()) {
                this._vector.setSafe(n, entityFieldAccessor.getByte());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(EntityFieldAccessor entityFieldAccessor, int n) {
            if (!this._vector.isNull(n)) {
                entityFieldAccessor.set(this._vector.get(n));
            } else {
                entityFieldAccessor.reset();
            }
        }
    }
}

