/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VersionedPropertyStore;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class PropertyStore {
    protected VectorSchemaRoot _entityRoot;
    protected BigIntVector _localIds;
    protected BitVector _initialValues;
    protected BigIntVector _creationTimes;
    protected IntVector _prevPtrs;
    protected int _maxRow = 0;
    protected VersionedPropertyStore _accessor;
    protected int _partitionId;

    public static List<Field> createBasePropertySchema() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new Field("local_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("initial_value", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("creation_time", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("prev_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        return arrayList;
    }

    protected void init(int n, VectorSchemaRoot vectorSchemaRoot, VersionedPropertyStore versionedPropertyStore) {
        this._partitionId = n;
        this._entityRoot = vectorSchemaRoot;
        this._accessor = versionedPropertyStore;
        if (this._entityRoot != null) {
            this._localIds = (BigIntVector)this._entityRoot.getVector("local_id");
            this._initialValues = (BitVector)this._entityRoot.getVector("initial_value");
            this._creationTimes = (BigIntVector)this._entityRoot.getVector("creation_time");
            this._prevPtrs = (IntVector)this._entityRoot.getVector("prev_ptr");
        } else {
            this._localIds = null;
            this._initialValues = null;
            this._creationTimes = null;
            this._prevPtrs = null;
        }
        this._accessor.initialise(vectorSchemaRoot);
    }

    protected int addProperty(long l, boolean bl, long l2, int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        int n2 = this._maxRow++;
        this._localIds.setSafe(n2, l);
        this._initialValues.setSafe(n2, bl ? 1 : 0);
        this._creationTimes.setSafe(n2, l2);
        this._prevPtrs.setSafe(n2, n);
        this._accessor.store(versionedEntityPropertyAccessor, n2);
        return n2;
    }

    public void loadProperty(int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        this._accessor.load(versionedEntityPropertyAccessor, n);
    }
}

