/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.pojograph.entities.external.vertex;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.ConcreteExplodedEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedEdge;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.internals.storage.pojograph.entities.external.edge.PojoExEdge;
import com.raphtory.internals.storage.pojograph.entities.external.edge.PojoExReducedEdgeBase;
import com.raphtory.internals.storage.pojograph.entities.external.vertex.PojoExVertex;
import com.raphtory.internals.storage.pojograph.entities.external.vertex.PojoReducedUndirectedVertexView$;
import com.raphtory.internals.storage.pojograph.entities.external.vertex.PojoUndirectedVertexView;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.View;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000594Q!\u0004\b\u0001)yA\u0001b\u0004\u0001\u0003\u0006\u0004%\t\u0005\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005k!)\u0011\b\u0001C\u0001u\u0015!Q\b\u0001\u0011?\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015y\u0006\u0001\"\u0011a\u000f\u0019!g\u0002#\u0001\u0015K\u001a1QB\u0004E\u0001)\u0019DQ!\u000f\u0006\u0005\u0002)DQa\u001b\u0006\u0005\u00021\u0014q\u0004U8k_J+G-^2fIVsG-\u001b:fGR,GMV3si\u0016Dh+[3x\u0015\ty\u0001#\u0001\u0004wKJ$X\r\u001f\u0006\u0003#I\t\u0001\"\u001a=uKJt\u0017\r\u001c\u0006\u0003'Q\t\u0001\"\u001a8uSRLWm\u001d\u0006\u0003+Y\t\u0011\u0002]8k_\u001e\u0014\u0018\r\u001d5\u000b\u0005]A\u0012aB:u_J\fw-\u001a\u0006\u00033i\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005ma\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003u\t1aY8n'\r\u0001q$\u000b\t\u0004A\u0005\u001aS\"\u0001\b\n\u0005\tr!\u0001\u0007)pU>,f\u000eZ5sK\u000e$X\r\u001a,feR,\u0007PV5foB\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t!Aj\u001c8h!\tQ\u0013'D\u0001,\u0015\taS&A\u0004wSNLGo\u001c:\u000b\u00059z\u0013\u0001C1oC2L8/[:\u000b\u0005AR\u0012aA1qS&\u0011!g\u000b\u0002\u000e%\u0016$WoY3e-\u0016\u0014H/\u001a=\u0004\u0001U\tQ\u0007\u0005\u0002!m%\u0011qG\u0004\u0002\r!>Tw.\u0012=WKJ$X\r_\u0001\bm\u0016\u0014H/\u001a=!\u0003\u0019a\u0014N\\5u}Q\u00111\b\u0010\t\u0003A\u0001AQaD\u0002A\u0002U\u0012A!\u00123hKB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tE\u0001\u0005K\u0012<W-\u0003\u0002D\u0001\n)\u0002k\u001c6p\u000bb\u0014V\rZ;dK\u0012,EmZ3CCN,\u0017aC4fi>+H/\u00123hKN$2A\u0012(Q!\r9%\nT\u0007\u0002\u0011*\u0011\u0011*J\u0001\u000bG>dG.Z2uS>t\u0017BA&I\u0005\u00111\u0016.Z<\u0011\u00055#Q\"\u0001\u0001\t\u000f=+\u0001\u0013!a\u0001G\u0005)\u0011M\u001a;fe\"9\u0011+\u0002I\u0001\u0002\u0004\u0019\u0013A\u00022fM>\u0014X-\u0001\u0006hKRLe.\u00123hKN$2A\u0012+V\u0011\u001dye\u0001%AA\u0002\rBq!\u0015\u0004\u0011\u0002\u0003\u00071%\u0001\u0006hKR|U\u000f^#eO\u0016$B\u0001W.^=B\u0019A%\u0017'\n\u0005i+#AB(qi&|g\u000eC\u0003]\u000f\u0001\u00071%\u0001\u0002jI\"9qj\u0002I\u0001\u0002\u0004\u0019\u0003bB)\b!\u0003\u0005\raI\u0001\nO\u0016$\u0018J\\#eO\u0016$B\u0001W1cG\")A\f\u0003a\u0001G!9q\n\u0003I\u0001\u0002\u0004\u0019\u0003bB)\t!\u0003\u0005\raI\u0001 !>TwNU3ek\u000e,G-\u00168eSJ,7\r^3e-\u0016\u0014H/\u001a=WS\u0016<\bC\u0001\u0011\u000b'\tQq\r\u0005\u0002%Q&\u0011\u0011.\n\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0015\fQ!\u00199qYf$\"aO7\t\u000b=a\u0001\u0019A\u001b")
public class PojoReducedUndirectedVertexView
extends PojoUndirectedVertexView<Object>
implements ReducedVertex {
    private final PojoExVertex vertex;

    public static PojoReducedUndirectedVertexView apply(PojoExVertex vertex) {
        return PojoReducedUndirectedVertexView$.MODULE$.apply(vertex);
    }

    @Override
    @Scaladoc(value="/** Return all edges starting or ending at this vertex\n    * @param after only return edges that are active after time `after`\n    * @param before only return edges that are active before time `before`\n    *\n    * The `after` and `before` parameters also restrict the history of the returned edges such that it only\n    * contains events within the window.\n    */")
    public View<ReducedEdge> getAllEdges(long after, long before) {
        return ReducedVertex.getAllEdges$(this, after, before);
    }

    @Override
    @Scaladoc(value="/** Return specified edge if it is an in-edge or an out-edge of this vertex\n    *\n    * This function returns a list of edges, where the list is empty if neither an in-edge nor an out-edge\n    * with this id exists, contains one element if either an in-edge or an out-edge with the id exists, or\n    * contains two elements if both in-edge and out-edge exist.\n    *\n    * @param id ID of edge to return\n    * @param after only return edge if it is active after time `after`\n    * @param before only return edge if it is active before time `before`\n    *\n    * The `after` and `before` parameters also restrict the history of the returned edges such that it only\n    * contains events within the window.\n    */")
    public List<ReducedEdge> getEdge(long id, long after, long before) {
        return ReducedVertex.getEdge$(this, id, after, before);
    }

    @Override
    @Scaladoc(value="/** Return all exploded [[com.raphtory.api.analysis.visitor.ExplodedEdge ExplodedEdge]] views for each time point\n    * that an in- or out-edge of this vertex is active\n    *\n    * @param after  only return views for activity after time `after`\n    * @param before only return view for activity before time `before`\n    */")
    public List<ConcreteExplodedEdge> explodeAllEdges(long after, long before) {
        return ReducedVertex.explodeAllEdges$(this, after, before);
    }

    @Override
    @Scaladoc(value="/** Return all exploded [[com.raphtory.api.analysis.visitor.ExplodedEdge ExplodedEdge]] views for each time point\n    * that an out-edge of this vertex is active\n    *\n    * @param after  only return views for activity after time `after`\n    * @param before only return view for activity before time `before`\n    */")
    public List<ConcreteExplodedEdge> explodeOutEdges(long after, long before) {
        return ReducedVertex.explodeOutEdges$(this, after, before);
    }

    @Override
    @Scaladoc(value="/** Return all exploded [[com.raphtory.api.analysis.visitor.ExplodedEdge ExplodedEdge]] views for each time point\n    * that an in-edge of this vertex is active\n    *\n    * @param after  only return views for activity after time `after`\n    * @param before only return view for activity before time `before`\n    */")
    public List<ConcreteExplodedEdge> explodeInEdges(long after, long before) {
        return ReducedVertex.explodeInEdges$(this, after, before);
    }

    @Override
    @Scaladoc(value="/** Return an individual exploded [[com.raphtory.api.analysis.visitor.ExplodedEdge ExplodedEdge]] views for an individual edge\n    * if it is an out-edge of this vertex\n    *\n    * @param id ID of edge to explode\n    * @param after  only return views for activity after time `after`\n    * @param before only return view for activity before time `before`\n    */")
    public Option<List<ConcreteExplodedEdge>> explodeOutEdge(long id, long after, long before) {
        return ReducedVertex.explodeOutEdge$(this, id, after, before);
    }

    @Override
    @Scaladoc(value="/** Return exploded [[com.raphtory.api.analysis.visitor.ExplodedEdge ExplodedEdge]] views for an individual edge\n    * if it is an in-edge of this vertex\n    *\n    * @param id ID of edge to explode\n    * @param after  only return views for activity after time `after`\n    * @param before only return view for activity before time `before`\n    */")
    public Option<List<ConcreteExplodedEdge>> explodeInEdge(long id, long after, long before) {
        return ReducedVertex.explodeInEdge$(this, id, after, before);
    }

    @Override
    @Scaladoc(value="/** Return an individual exploded [[com.raphtory.api.analysis.visitor.ExplodedEdge ExplodedEdge]] views for an individual edge\n    * if it is an in- or out-edge of this vertex\n    *\n    * @param id ID of edge to explode\n    * @param after  only return views for activity after time `after`\n    * @param before only return view for activity before time `before`\n    */")
    public Option<List<ConcreteExplodedEdge>> explodedEdge(long id, long after, long before) {
        return ReducedVertex.explodedEdge$(this, id, after, before);
    }

    @Override
    public long getAllEdges$default$1() {
        return ReducedVertex.getAllEdges$default$1$(this);
    }

    @Override
    public long getAllEdges$default$2() {
        return ReducedVertex.getAllEdges$default$2$(this);
    }

    @Override
    public long getOutEdges$default$1() {
        return ReducedVertex.getOutEdges$default$1$(this);
    }

    @Override
    public long getOutEdges$default$2() {
        return ReducedVertex.getOutEdges$default$2$(this);
    }

    @Override
    public long getInEdges$default$1() {
        return ReducedVertex.getInEdges$default$1$(this);
    }

    @Override
    public long getInEdges$default$2() {
        return ReducedVertex.getInEdges$default$2$(this);
    }

    @Override
    public long getOutEdge$default$2() {
        return ReducedVertex.getOutEdge$default$2$(this);
    }

    @Override
    public long getOutEdge$default$3() {
        return ReducedVertex.getOutEdge$default$3$(this);
    }

    @Override
    public long getInEdge$default$2() {
        return ReducedVertex.getInEdge$default$2$(this);
    }

    @Override
    public long getInEdge$default$3() {
        return ReducedVertex.getInEdge$default$3$(this);
    }

    @Override
    public long getEdge$default$2() {
        return ReducedVertex.getEdge$default$2$(this);
    }

    @Override
    public long getEdge$default$3() {
        return ReducedVertex.getEdge$default$3$(this);
    }

    @Override
    public long explodeAllEdges$default$1() {
        return ReducedVertex.explodeAllEdges$default$1$(this);
    }

    @Override
    public long explodeAllEdges$default$2() {
        return ReducedVertex.explodeAllEdges$default$2$(this);
    }

    @Override
    public long explodeOutEdges$default$1() {
        return ReducedVertex.explodeOutEdges$default$1$(this);
    }

    @Override
    public long explodeOutEdges$default$2() {
        return ReducedVertex.explodeOutEdges$default$2$(this);
    }

    @Override
    public long explodeInEdges$default$1() {
        return ReducedVertex.explodeInEdges$default$1$(this);
    }

    @Override
    public long explodeInEdges$default$2() {
        return ReducedVertex.explodeInEdges$default$2$(this);
    }

    @Override
    public long explodeOutEdge$default$2() {
        return ReducedVertex.explodeOutEdge$default$2$(this);
    }

    @Override
    public long explodeOutEdge$default$3() {
        return ReducedVertex.explodeOutEdge$default$3$(this);
    }

    @Override
    public long explodeInEdge$default$2() {
        return ReducedVertex.explodeInEdge$default$2$(this);
    }

    @Override
    public long explodeInEdge$default$3() {
        return ReducedVertex.explodeInEdge$default$3$(this);
    }

    @Override
    public long explodedEdge$default$2() {
        return ReducedVertex.explodedEdge$default$2$(this);
    }

    @Override
    public long explodedEdge$default$3() {
        return ReducedVertex.explodedEdge$default$3$(this);
    }

    @Override
    public PojoExVertex vertex() {
        return this.vertex;
    }

    public View<PojoExReducedEdgeBase> getOutEdges(long after, long before) {
        return (View)((IterableOps)this.vertex().getInEdges(after, before).map((Function1 & Serializable)inEdge -> {
            EntityVisitor entityVisitor;
            Option<PojoExEdge> option = this.vertex().getOutEdge(inEdge.ID(), after, before);
            if (option instanceof Some) {
                Some some = (Some)option;
                PojoExEdge outEdge = (PojoExEdge)some.value();
                entityVisitor = inEdge.combineUndirected(outEdge, false);
            } else if (None$.MODULE$.equals(option)) {
                entityVisitor = inEdge.reversed();
            } else {
                throw new MatchError(option);
            }
            return entityVisitor;
        })).$plus$plus((IterableOnce)this.vertex().getOutEdges(after, before).filterNot((Function1 & Serializable)outEdge -> BoxesRunTime.boxToBoolean((boolean)PojoReducedUndirectedVertexView.$anonfun$getOutEdges$2(this, after, before, outEdge))));
    }

    public View<PojoExReducedEdgeBase> getInEdges(long after, long before) {
        return (View)((IterableOps)this.vertex().getOutEdges(after, before).map((Function1 & Serializable)outEdge -> {
            EntityVisitor entityVisitor;
            Option<PojoExEdge> option = this.vertex().getInEdge(outEdge.ID(), after, before);
            if (option instanceof Some) {
                Some some = (Some)option;
                PojoExEdge inEdge = (PojoExEdge)some.value();
                entityVisitor = outEdge.combineUndirected(inEdge, true);
            } else if (None$.MODULE$.equals(option)) {
                entityVisitor = outEdge.reversed();
            } else {
                throw new MatchError(option);
            }
            return entityVisitor;
        })).$plus$plus((IterableOnce)this.vertex().getInEdges(after, before).filterNot((Function1 & Serializable)inEdge -> BoxesRunTime.boxToBoolean((boolean)PojoReducedUndirectedVertexView.$anonfun$getInEdges$2(this, after, before, inEdge))));
    }

    public Option<PojoExReducedEdgeBase> getOutEdge(long id, long after, long before) {
        return this.getOutEdge(BoxesRunTime.boxToLong((long)id)).collect((PartialFunction)new Serializable(null, after, before){
            private static final long serialVersionUID = 0L;
            private final long after$3;
            private final long before$3;

            public final <A1 extends PojoExReducedEdgeBase, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = ((EntityVisitor)((Object)A1)).active(this.after$3, this.before$3) ? A1.viewBetween(this.after$3, this.before$3) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(PojoExReducedEdgeBase x1) {
                PojoExReducedEdgeBase pojoExReducedEdgeBase = x1;
                boolean bl = ((EntityVisitor)((Object)pojoExReducedEdgeBase)).active(this.after$3, this.before$3);
                return bl;
            }
            {
                this.after$3 = after$3;
                this.before$3 = before$3;
            }
        });
    }

    public Option<PojoExReducedEdgeBase> getInEdge(long id, long after, long before) {
        return this.getInEdge(BoxesRunTime.boxToLong((long)id)).collect((PartialFunction)new Serializable(null, after, before){
            private static final long serialVersionUID = 0L;
            private final long after$4;
            private final long before$4;

            public final <A1 extends PojoExReducedEdgeBase, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = ((EntityVisitor)((Object)A1)).active(this.after$4, this.before$4) ? A1.viewBetween(this.after$4, this.before$4) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(PojoExReducedEdgeBase x1) {
                PojoExReducedEdgeBase pojoExReducedEdgeBase = x1;
                boolean bl = ((EntityVisitor)((Object)pojoExReducedEdgeBase)).active(this.after$4, this.before$4);
                return bl;
            }
            {
                this.after$4 = after$4;
                this.before$4 = before$4;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$getOutEdges$2(PojoReducedUndirectedVertexView $this, long after$1, long before$1, PojoExEdge outEdge) {
        return $this.vertex().getInEdge(outEdge.ID(), after$1, before$1).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getInEdges$2(PojoReducedUndirectedVertexView $this, long after$2, long before$2, PojoExEdge inEdge) {
        return $this.vertex().getOutEdge(inEdge.ID(), after$2, before$2).isDefined();
    }

    public PojoReducedUndirectedVertexView(PojoExVertex vertex) {
        this.vertex = vertex;
        super(vertex);
        ReducedVertex.$init$(this);
    }
}

