/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.arrow.entities;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.ConcreteExplodedEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.ReducedEdge;
import com.raphtory.arrowcore.model.Edge;
import com.raphtory.arrowcore.model.Entity;
import com.raphtory.arrowcore.model.PropertySchema;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.components.querymanager.VertexMessage;
import com.raphtory.internals.storage.arrow.ArrowEntityStateRepository;
import com.raphtory.internals.storage.arrow.entities.ArrowExEntity;
import java.io.Serializable;
import java.util.Collection;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001\u0002\n\u0014\u0001\u0001B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003>\u0011!1\u0005A!b\u0001\n#9\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b5\u0003A\u0011\u0001(\u0006\tM\u0003\u0001\u0005\u000e\u0005\u0006)\u0002!\te\r\u0005\u0006G\u0002!\te\r\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006s\u0002!\tE\u001f\u0005\u0006}\u0002!\te`\u0003\u0007\u0003C\u0001\u0001%a\t\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011\u0011\n\u0001\u0005B\u0005-#aC!se><X\t_#eO\u0016T!\u0001F\u000b\u0002\u0011\u0015tG/\u001b;jKNT!AF\f\u0002\u000b\u0005\u0014(o\\<\u000b\u0005aI\u0012aB:u_J\fw-\u001a\u0006\u00035m\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005qi\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003y\t1aY8n\u0007\u0001\u0019B\u0001A\u0011,]A\u0011!%K\u0007\u0002G)\u0011A%J\u0001\bm&\u001c\u0018\u000e^8s\u0015\t1s%\u0001\u0005b]\u0006d\u0017p]5t\u0015\tA3$A\u0002ba&L!AK\u0012\u0003\u001b\u0015sG/\u001b;z-&\u001c\u0018\u000e^8s!\t\u0011C&\u0003\u0002.G\tY!+\u001a3vG\u0016$W\tZ4f!\ty\u0003'D\u0001\u0014\u0013\t\t4CA\u0007BeJ|w/\u0012=F]RLG/_\u0001\u0003\u0013\u0012+\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0005\u0019>tw-A\u0002J\t\u0002\nA!\u001a3hKV\tQ\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006)Qn\u001c3fY*\u0011!iG\u0001\nCJ\u0014xn^2pe\u0016L!\u0001R \u0003\t\u0015#w-Z\u0001\u0006K\u0012<W\rI\u0001\u0005e\u0016\u0004x.F\u0001I!\tI%*D\u0001\u0016\u0013\tYUC\u0001\u000eBeJ|w/\u00128uSRL8\u000b^1uKJ+\u0007o\\:ji>\u0014\u00180A\u0003sKB|\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001fB\u000b&\u000b\u0005\u00020\u0001!)!g\u0002a\u0001i!)1h\u0002a\u0001{!)ai\u0002a\u0001\u0011\n1\u0011\n\u0012+za\u0016\f1a\u001d:dQ\u0011Ia\u000bY1\u0011\u0005]sV\"\u0001-\u000b\u0005eS\u0016\u0001C:dC2\fGm\\2\u000b\u0005mc\u0016a\u0002;bW\u0016Tx.\u001a\u0006\u0003;v\taaZ5uQV\u0014\u0017BA0Y\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%\u00012\u0002U=R#\u0006I%EA=4\u0007\u0005\u001e5fAM|WO]2fAY,'\u000f^3yA=4\u0007\u0005\u001e5fA\u0015$w-\u001a\u0011+_\u0005\u0019Am\u001d;)\t)1\u0006-Z\u0011\u0002M\u0006ysF\u000b\u0016!\u0013\u0012\u0003sN\u001a\u0011uQ\u0016\u0004C-Z:uS:\fG/[8oAY,'\u000f^3yA=4\u0007\u0005\u001e5fA\u0015$w-\u001a\u0011+_\u00051!/Z7pm\u0016$\u0012!\u001b\t\u0003k)L!a\u001b\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0017Y\u0003W.I\u0001o\u0003Mz#F\u000b\u0011GS2$XM\u001d\u0011uQ\u0016\u0004S\rZ4fA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004\u0003m\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3a]\u0001Rs&\u0001\u0003tK:$GCA5r\u0011\u0015\u0011H\u00021\u0001t\u0003\u0011!\u0017\r^1\u0011\u0005U\"\u0018BA;7\u0005\r\te.\u001f\u0015\u0005\u0019Y\u0003w/I\u0001y\u0003q|#F\u000b\u0011TK:$\u0007%\u0019\u0011nKN\u001c\u0018mZ3!i>\u0004C\u000f[3!m\u0016\u0014H/\u001a=!G>tg.Z2uK\u0012\u0004sN\u001c\u0011uQ\u0016\u0004s\u000e\u001e5fe\u0002\u001a\u0018\u000eZ3!_\u001a\u0004C\u000f[3!K\u0012<WM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004C-\u0019;bA5+7o]1hK\u0002\"\u0017\r^1!i>\u00043/\u001a8e\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003\u0019)g\u000e^5usV\t1\u0010\u0005\u0002?y&\u0011Qp\u0010\u0002\u0007\u000b:$\u0018\u000e^=\u0002\u0015\rdW-\u0019:Ti\u0006$X\rF\u0002j\u0003\u0003Aq!a\u0001\u000f\u0001\u0004\t)!A\u0002lKf\u0004B!a\u0002\u0002\u00169!\u0011\u0011BA\t!\r\tYAN\u0007\u0003\u0003\u001bQ1!a\u0004 \u0003\u0019a$o\\8u}%\u0019\u00111\u0003\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t9\"!\u0007\u0003\rM#(/\u001b8h\u0015\r\t\u0019B\u000e\u0015\u0006\u001dY\u0003\u0017QD\u0011\u0003\u0003?\t\u0011h\f\u0016+AI+Wn\u001c<fA\u0005t\u0007%\u001a8uef\u0004\u0013N\u001c\u0011uQ\u0016\u0004SM\u001c;jif<3\u000fI1mO>\u0014\u0018\u000e\u001e5nS\u000e\u00043\u000f^1uK:\u0002#f\f\u0002\r\u000bb\u0004Hn\u001c3fI\u0016#w-\u001a\t\u0005E\u0005\u0015B'C\u0002\u0002(\r\u0012AcQ8oGJ,G/Z#ya2|G-\u001a3FI\u001e,\u0017aB3ya2|G-\u001a\u000b\u0003\u0003[\u0001b!a\f\u0002:\u0005}b\u0002BA\u0019\u0003kqA!a\u0003\u00024%\tq'C\u0002\u00028Y\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0005u\"\u0001\u0002'jgRT1!a\u000e7!\r\t\teD\u0007\u0002\u0001!*\u0001C\u00161\u0002F\u0005\u0012\u0011qI\u0001k_)R\u0003EU3ukJt\u0007%\u00198!7n+\u0005\u0010\u001d7pI\u0016$W\tZ4f;v\u0003\u0013N\\:uC:\u001cW\r\t4pe\u0002*\u0017m\u00195!i&lW\r\t;iK\u0002*GmZ3!SNT\u0001\u0005\t\u0011!U\u0001\n7\r^5wK\u0002Jg\u000e\t;iK\u0002\u001aWO\u001d:f]R\u0004c/[3x])\u0001\u0003\u0005\t\u0011+_\u0005qq-\u001a;Qe>\u0004XM\u001d;z'\u0016$HCAA'!\u0019\ty#!\u000f\u0002\u0006!*\u0011C\u00161\u0002R\u0005\u0012\u00111K\u0001E_)R\u0003EU3ukJt\u0007%\u0019\u0011mSN$\be\u001c4!W\u0016L8\u000f\t4pe\u0002\ng/Y5mC\ndW\r\t9s_B,'\u000f^5fg\u00022wN\u001d\u0011uQ\u0016\u0004SM\u001c;jif\u0004#f\f")
public class ArrowExEdge
extends EntityVisitor
implements ReducedEdge,
ArrowExEntity {
    private final long ID;
    private final Edge edge;
    private final ArrowEntityStateRepository repo;

    @Override
    @Scaladoc(value="/** Return the type of the entity */")
    public String Type() {
        return ArrowExEntity.Type$(this);
    }

    @Override
    @Scaladoc(value="/** Return the next event (addition or deletion) after the given timestamp `time` as an\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]]. This is wrapped in an option as\n    * it is possible that no activity occurred after the given time. An optional `strict` Boolean argument is also\n    * available which allows events exactly at the given time to be returned if set to `false`.\n    *\n    * @param time   The time after which to return the next occurring event\n    * @param strict Whether events occurring exactly at the given time should be excluded or not\n    * @return an optional historic event containing the event if one exists\n    */")
    public Option<HistoricEvent> firstActivityAfter(long time, boolean strict) {
        return ArrowExEntity.firstActivityAfter$(this, time, strict);
    }

    @Override
    @Scaladoc(value="/** Return the last event (addition or deletion) before the given timestamp `time` as an\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]].  The result is wrapped in an option as it is\n    * possible that no activity occurred before the given time. An optional `strict` Boolean argument is also\n    * available which allows events exactly at the given time to be returned if set to `false`.\n    *\n    * @param time   The time before which to return the latest occurring event\n    * @param strict Whether events occurring exactly at the given time should be excluded or not\n    * @return an optional historic event containing the event if one exists\n    */")
    public Option<HistoricEvent> lastActivityBefore(long time, boolean strict) {
        return ArrowExEntity.lastActivityBefore$(this, time, strict);
    }

    @Override
    @Scaladoc(value="/** Return the most recent event (addition or deletion) in the current view as a\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]]\n    */")
    public HistoricEvent latestActivity() {
        return ArrowExEntity.latestActivity$(this);
    }

    @Override
    @Scaladoc(value="/** Return the first event (addition or deltion) in the current view as a\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]]\n    */")
    public HistoricEvent earliestActivity() {
        return ArrowExEntity.earliestActivity$(this);
    }

    @Override
    @Scaladoc(value="/** Returns a history of values for the property `key`. Returns `None` if no property with name `key` exists.\n    * Otherwise returns a list of `(timestamp, value)` tuples (which may be empty).\n    *\n    * The exact behaviour depends on the type of the property:\n    *\n    * In case of a\n    * [[com.raphtory.api.input.ImmutableString]], the history\n    * depends only on the creation time of the property. If the property was created within the current view, the\n    * history contains a single tuple with the value of the property and the timestamp given by the creation time\n    * of the property. If the property creation time is before the start of the current view, the history contains\n    * a single tuple with the value of the property and the timestamp given by the start time of the current view.\n    * If the property creation time is after the end of the current view, the history is empty.\n    *\n    * For the other property types, the history contains\n    * the timestamps and values for all addition events within the current view and is empty if the property exists\n    * but no addition events occurred in the current view.\n    *\n    * @note More property types with different value semantics are likely going to be added in the future.\n    * @param key    Name of property\n    * @param after  Only consider addition events in the current view that happened no earlier than time `after`\n    * @param before Only consider addition events in the current view that happened no later than time `before`\n    */")
    public <T> Option<Iterable<PropertyValue<T>>> getPropertyHistory(String key, long after, long before) {
        return ArrowExEntity.getPropertyHistory$(this, key, after, before);
    }

    @Override
    @Scaladoc(value="/**\n    * check if the property is field or versioned property\n    * @param key\n    * @return\n    */")
    public boolean isField(String key) {
        return ArrowExEntity.isField$(this, key);
    }

    @Override
    @Scaladoc(value="/** Set algorithmic state for this entity. Note that for edges, algorithmic state is stored locally to the vertex endpoint\n    * which sets this state (default being the source node when set during an edge step).\n    *\n    * @param key   key to use for setting value\n    * @param value new value for state\n    */")
    public void setState(String key, Object value) {
        ArrowExEntity.setState$(this, key, value);
    }

    @Override
    @Scaladoc(value="/** Retrieve value from algorithmic state. Note that for edges, algorithmic state is stored locally to the vertex endpoint\n    * which sets this state (default being the source node when set during an edge step).\n    *\n    * @tparam `T` value type for state\n    * @param key               key to use for retrieving state\n    * @param includeProperties set this to `true` to fall-through to vertex properties if `key` is not found\n    */")
    public <T> T getState(String key, boolean includeProperties) {
        return (T)ArrowExEntity.getState$(this, key, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Retrieve value from algorithmic state if it exists or return a default value otherwise. Note that for edges,\n    * algorithmic state is stored locally to the vertex endpoint which set this state (default being the source node\n    * when set during an edge step).\n    *\n    * @tparam `T` value type for state\n    * @param key               key to use for retrieving state\n    * @param value             default value to return if state does not exist\n    * @param includeProperties set this to `true` to fall-through to entity properties\n    *                          if `key` is not found in algorithmic state\n    */")
    public <T> T getStateOrElse(String key, T value, boolean includeProperties) {
        return (T)ArrowExEntity.getStateOrElse$(this, key, value, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Checks if algorithmic state with key `key` exists. Note that for edges, algorithmic state is stored locally to\n    * the vertex endpoint which set this state (default being the source node when set during an edge step).\n    *\n    * @param key               state key to check\n    * @param includeProperties Set this to `true` to fall-through to vertex properties if `key` is not found.\n    *                          If set, this function only returns `false` if `key` is not included in either algorithmic state\n    *                          or entity properties\n    */")
    public boolean containsState(String key, boolean includeProperties) {
        return ArrowExEntity.containsState$(this, key, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Retrieve value from algorithmic state if it exists or set this state to a default value and return otherwise. Note that for edges,\n    * algorithmic state is stored locally to the vertex endpoint which set this state (default being the source node\n    * when set during an edge step).\n    *\n    * @tparam `T` value type for state\n    * @param key               key to use for retrieving state\n    * @param value             default value to set and return if state does not exist\n    * @param includeProperties set this to `true` to fall-through to vertex properties\n    *                          if `key` is not found in algorithmic state. State is only set if this is also not found.\n    */")
    public <T> T getOrSetState(String key, T value, boolean includeProperties) {
        return (T)ArrowExEntity.getOrSetState$(this, key, value, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Append new value to existing array or initialise new array if state does not exist. Note that for edges,\n    * algorithmic state is stored locally to the vertex endpoint which set this state (default being the source node\n    * when set during an edge step).\n    * The value type of the state is assumed to be `Array[T]` if the state already exists.\n    *\n    * @tparam `T` value type for state (needs to have a `ClassTag` available due to Scala `Array` implementation)\n    * @param key   key to use for retrieving state\n    * @param value value to append to state\n    */")
    public <T> void appendToState(String key, T value, ClassTag<T> evidence$1) {
        ArrowExEntity.appendToState$(this, key, value, evidence$1);
    }

    @Override
    public List<HistoricEvent> history() {
        return ArrowExEntity.history$(this);
    }

    @Override
    @Scaladoc(value="/** Return `true` if any event (addition or deletion) occurred during the time window starting at\n    * `after` and ending at `before`. Otherwise returns `false`.\n    *\n    * @param after  inclusive lower bound for the time window (defaults to oldest data point)\n    * @param before inclusive upper bound for the time window (defaults to newest data point)\n    */")
    public boolean active(long after, long before) {
        return ArrowExEntity.active$(this, after, before);
    }

    @Override
    @Scaladoc(value="/** Check if the entity is currently alive (i.e, the last event was an addition) at time `time`.\n    *\n    * @param time   time point to check\n    * @param window If a value for `window` is given, the entity is considered as having been deleted if more\n    *               than `window` time has passed since the last addition event.\n    */")
    public boolean aliveAt(long time, long window) {
        return ArrowExEntity.aliveAt$(this, time, window);
    }

    @Override
    @Scaladoc(value="/** `true` if the edge is an out-edge */")
    public boolean isOutgoing() {
        return com.raphtory.api.analysis.visitor.Edge.isOutgoing$(this);
    }

    @Override
    @Scaladoc(value="/** `true` if the edge is an in-edge */")
    public boolean isIncoming() {
        return com.raphtory.api.analysis.visitor.Edge.isIncoming$(this);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (if `mergeStrategy` is not given, this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    * @param weightProperty  edge property to use for computing edge weight\n    * @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                      (see [[PropertyMergeStrategy]] for predefined options or provide custom function). By default this returns the\n    *                      sum of property values.\n    * @param default default value for the weight property before applying the merge strategy.\n    *                This defaults to `1` if `A` is a numeric type. This default value is applied before applying the\n    *                merge strategy. In the case where, e.g., `mergeStrategy =  PropertyMergeStrategy.sum[A]`, the\n    *                computed weight is the number of times the edge was active in the current view if the weight\n    *                property is not found.\n    */")
    public <A, B> B weight(String weightProperty, Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, A a) {
        return (B)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, mergeStrategy, a);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    *  @param weightProperty  edge property to use for computing edge weight\n    *  @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                       (see [[PropertyMergeStrategy]]\n    *                       for predefined options or provide custom function). By default this returns the\n    *                       sum of property values.\n    */")
    public <A, B> B weight(String weightProperty, Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, Numeric<A> evidence$1) {
        return (B)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, mergeStrategy, evidence$1);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (if `mergeStrategy` is not given, this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    *  @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                       (see [[PropertyMergeStrategy]]\n    *                       for predefined options or provide custom function). By default this returns the\n    *                       sum of property values.\n    */")
    public <A, B> B weight(Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, Numeric<A> evidence$2) {
        return (B)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, mergeStrategy, evidence$2);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    *\n    *  @param weightProperty  edge property to use for computing edge weight\n    *  @param default default value for the weight property before applying the merge strategy.\n    *                 This defaults to `1`.\n    */")
    public <A> A weight(String weightProperty, A a, Numeric<A> evidence$3) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, a, evidence$3);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    *\n    *  @param default default value for the weight property before applying the merge strategy. This defaults to `1`.\n    */")
    public <A> A weight(A a, Numeric<A> evidence$4) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, a, evidence$4);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    * @param weightProperty  edge property to use for computing edge weight\n    */")
    public <A> A weight(String weightProperty, Numeric<A> evidence$5) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, evidence$5);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    */")
    public <A> A weight(Numeric<A> evidence$6) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$(this, evidence$6);
    }

    @Override
    public <A, B> String weight$default$1() {
        return com.raphtory.api.analysis.visitor.Edge.weight$default$1$(this);
    }

    public long ID() {
        return this.ID;
    }

    public Edge edge() {
        return this.edge;
    }

    @Override
    public ArrowEntityStateRepository repo() {
        return this.repo;
    }

    @Scaladoc(value="/** ID of the source vertex of the edge */")
    public long src() {
        return !this.edge().isSrcGlobal() ? this.repo().asGlobal(this.edge().getSrcVertex()) : this.edge().getSrcVertex();
    }

    @Scaladoc(value="/** ID of the destination vertex of the edge */")
    public long dst() {
        return !this.edge().isDstGlobal() ? this.repo().asGlobal(this.edge().getDstVertex()) : this.edge().getDstVertex();
    }

    @Override
    @Scaladoc(value="/** Filter the edge from the `GraphPerspective`. */")
    public void remove() {
        this.repo().removeEdge(this.edge().getGlobalId());
    }

    @Override
    @Scaladoc(value="/** Send a message to the vertex connected on the other side of the edge\n    *\n    * @param data Message data to send\n    */")
    public void send(Object data) {
        this.repo().sendMessage(new VertexMessage<Object, Long>(this.repo().superStep() + 1, BoxesRunTime.boxToLong((long)this.ID()), data, SchemaProviderInstances$.MODULE$.genericSchemaProvider()));
    }

    @Override
    public Entity entity() {
        return this.edge();
    }

    @Override
    @Scaladoc(value="/** Remove an entry in the entity's algorithmic state. */")
    public void clearState(String key) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Scaladoc(value="/** Return an [[ExplodedEdge]] instance for each time the edge is\n    * active in the current view.\n    */")
    public List<ConcreteExplodedEdge<Object>> explode() {
        return package$.MODULE$.List().empty();
    }

    @Override
    @Scaladoc(value="/** Return a list of keys for available properties for the entity */")
    public List<String> getPropertySet() {
        PropertySchema schema = this.edge().getRaphtory().getPropertySchema();
        Iterable versioned = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)schema.versionedEdgeProperties()).asScala().map((Function1 & Serializable)x$1 -> x$1.name());
        Iterable nonVersioned = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)schema.nonversionedEdgeProperties()).asScala().map((Function1 & Serializable)x$2 -> x$2.name());
        return ((IterableOnceOps)versioned.$plus$plus((IterableOnce)nonVersioned)).toList();
    }

    public ArrowExEdge(long ID, Edge edge, ArrowEntityStateRepository repo) {
        this.ID = ID;
        this.edge = edge;
        this.repo = repo;
        com.raphtory.api.analysis.visitor.Edge.$init$(this);
        ArrowExEntity.$init$(this);
    }
}

