/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.management;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IOPlatform;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.implicits$;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Source;
import com.raphtory.api.input.Type;
import com.raphtory.api.output.sink.Sink;
import com.raphtory.api.progresstracker.ProgressTracker;
import com.raphtory.api.progresstracker.QueryProgressTracker;
import com.raphtory.api.progresstracker.QueryProgressTracker$;
import com.raphtory.api.progresstracker.QueryProgressTrackerWithIterator;
import com.raphtory.api.progresstracker.QueryProgressTrackerWithIterator$;
import com.raphtory.api.time.Interval;
import com.raphtory.internals.components.querymanager.DynamicLoader;
import com.raphtory.internals.components.querymanager.DynamicLoader$;
import com.raphtory.internals.components.querymanager.IngestData;
import com.raphtory.internals.components.querymanager.Operation;
import com.raphtory.internals.components.querymanager.PointSet;
import com.raphtory.internals.components.querymanager.TryIngestData;
import com.raphtory.internals.components.querymanager.TryQuery;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.protocol.DestroyGraph;
import com.raphtory.protocol.DestroyGraph$;
import com.raphtory.protocol.GraphInfo;
import com.raphtory.protocol.GraphInfo$;
import com.raphtory.protocol.GraphUpdate;
import com.raphtory.protocol.GraphUpdate$;
import com.raphtory.protocol.IdPool;
import com.raphtory.protocol.IdPool$;
import com.raphtory.protocol.IngestData$;
import com.raphtory.protocol.OptionalId;
import com.raphtory.protocol.Query;
import com.raphtory.protocol.Query$;
import com.raphtory.protocol.QueryUpdate;
import com.raphtory.protocol.RaphtoryService;
import com.raphtory.protocol.Status;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f!B\u001d;\u0001y\u0012\u0005\u0002C)\u0001\u0005\u000b\u0007I\u0011A*\t\u0011}\u0003!\u0011!Q\u0001\nQC\u0001\u0002\u0019\u0001\u0003\u0006\u0004%I!\u0019\u0005\ta\u0002\u0011\t\u0011)A\u0005E\"A\u0011\u000f\u0001BC\u0002\u0013%!\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003t\u0011!Y\bA!b\u0001\n\u0013\u0019\u0006\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u000bu\u0004A\u0011\u0001@\u0007\r\u0005-\u0001\u0001AA\u0007\u0011%\t\tC\u0003B\u0001B\u0003%A\u000b\u0003\u0004~\u0015\u0011\u0005\u00111\u0005\u0005\n\u0003W\u0001!\u0019!C\u0001\u0003[A\u0001\"a\u000f\u0001A\u0003%\u0011q\u0006\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0001\u0003\u007fA\u0001\"a\u0013\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u001b\u0002!\u0019!C\u0001\u0003\u007fA\u0001\"a\u0014\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003#\u0002\u0001\u0019!C\u0005\u0003'B\u0011\"a\u0017\u0001\u0001\u0004%I!!\u0018\t\u0011\u0005%\u0004\u0001)Q\u0005\u0003+B\u0011\"a\u001b\u0001\u0001\u0004%I!a\u0015\t\u0013\u00055\u0004\u00011A\u0005\n\u0005=\u0004\u0002CA:\u0001\u0001\u0006K!!\u0016\t\u0013\u0005U\u0004\u00011A\u0005\n\u0005}\u0002\"CA<\u0001\u0001\u0007I\u0011BA=\u0011!\ti\b\u0001Q!\n\u0005\u0005\u0003\"CA@\u0001\u0001\u0007I\u0011BA \u0011%\t\t\t\u0001a\u0001\n\u0013\t\u0019\t\u0003\u0005\u0002\b\u0002\u0001\u000b\u0015BA!\u0011%\tI\t\u0001a\u0001\n\u0013\tY\tC\u0005\u0002\u0014\u0002\u0001\r\u0011\"\u0003\u0002\u0016\"A\u0011\u0011\u0014\u0001!B\u0013\ti\tC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0003\u0002@!I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\t\u0003G\u0003\u0001\u0015)\u0003\u0002B!I\u0011Q\u0015\u0001A\u0002\u0013%\u0011q\u0015\u0005\n\u0003s\u0003\u0001\u0019!C\u0005\u0003wC\u0001\"a0\u0001A\u0003&\u0011\u0011\u0016\u0005\b\u0003\u0003\u0004A\u0011AAb\u0011\u001d\tI\r\u0001C)\u0003\u007fAq!a3\u0001\t\u0003\n\u0019\u0006C\u0004\u0002N\u0002!\t!a4\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u00111 \u0001\u0005R\u0005u\bb\u0002B\u0001\u0001\u0011\u0005!1\u0001\u0005\n\u0005g\u0001\u0011\u0013!C\u0001\u0005kAqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003Z\u0001!\tAa\u0017\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BC\u0001\u0011\u0005!1\u0011\u0005\b\u0005\u000f\u0003A\u0011\u0001BE\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;\u00131\"U;fef\u001cVM\u001c3fe*\u00111\bP\u0001\u000b[\u0006t\u0017mZ3nK:$(BA\u001f?\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002@\u0001\u0006A!/\u00199ii>\u0014\u0018PC\u0001B\u0003\r\u0019w.\\\n\u0004\u0001\rK\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%AB!osJ+g\r\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006)\u0011N\u001c9vi*\u0011aJP\u0001\u0004CBL\u0017B\u0001)L\u0005\u00159%/\u00199i\u0003\u001d9'/\u00199i\u0013\u0012\u001b\u0001!F\u0001U!\t)FL\u0004\u0002W5B\u0011q+R\u0007\u00021*\u0011\u0011LU\u0001\u0007yI|w\u000e\u001e \n\u0005m+\u0015A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!aW#\u0002\u0011\u001d\u0014\u0018\r\u001d5J\t\u0002\nqa]3sm&\u001cW-F\u0001c!\r\u0019g\r[\u0007\u0002I*\u0011QMP\u0001\taJ|Go\\2pY&\u0011q\r\u001a\u0002\u0010%\u0006\u0004\b\u000e^8ssN+'O^5dKB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0007K\u001a4Wm\u0019;\u000b\u00035\fAaY1ug&\u0011qN\u001b\u0002\u0003\u0013>\u000b\u0001b]3sm&\u001cW\rI\u0001\u0007G>tg-[4\u0016\u0003M\u0004\"\u0001\u001e=\u000e\u0003UT!!\u001d<\u000b\u0005]\u0004\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005e,(AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u000b\u0011b\u00197jK:$\u0018\n\u0012\u0011\u0002\rqJg.\u001b;?)%y\u00181AA\u0003\u0003\u000f\tI\u0001E\u0002\u0002\u0002\u0001i\u0011A\u000f\u0005\u0006#&\u0001\r\u0001\u0016\u0005\u0006A&\u0001\rA\u0019\u0005\u0006c&\u0001\ra\u001d\u0005\u0006w&\u0001\r\u0001\u0016\u0002\u000e\u001d>LE)\u0012=dKB$\u0018n\u001c8\u0014\u0007)\ty\u0001\u0005\u0003\u0002\u0012\u0005ma\u0002BA\n\u0003/q1aVA\u000b\u0013\u00051\u0015bAA\r\u000b\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000f\u0003?\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005eQ)A\u0004nKN\u001c\u0018mZ3\u0015\t\u0005\u0015\u0012\u0011\u0006\t\u0004\u0003OQQ\"\u0001\u0001\t\r\u0005\u0005B\u00021\u0001U\u0003\u0019awnZ4feV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007<\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\n\t\u0005e\u00121\u0007\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005\u0001\u0002/\u0019:uSRLwN\\*feZ,'o]\u000b\u0003\u0003\u0003\u00022\u0001RA\"\u0013\r\t)%\u0012\u0002\u0004\u0013:$\u0018!\u00059beRLG/[8o'\u0016\u0014h/\u001a:tA\u0005\u0019\u0002/\u0019:uSRLwN\\:QKJ\u001cVM\u001d<fe\u0006!\u0002/\u0019:uSRLwN\\:QKJ\u001cVM\u001d<fe\u0002\nq\u0002^8uC2\u0004\u0016M\u001d;ji&|gn]\u0001\u0011i>$\u0018\r\u001c)beRLG/[8og\u0002\n\u0001#Z1sY&,7\u000f\u001e+j[\u0016\u001cV-\u001a8\u0016\u0005\u0005U\u0003c\u0001#\u0002X%\u0019\u0011\u0011L#\u0003\t1{gnZ\u0001\u0015K\u0006\u0014H.[3tiRKW.Z*fK:|F%Z9\u0015\t\u0005}\u0013Q\r\t\u0004\t\u0006\u0005\u0014bAA2\u000b\n!QK\\5u\u0011%\t9GFA\u0001\u0002\u0004\t)&A\u0002yIE\n\u0011#Z1sY&,7\u000f\u001e+j[\u0016\u001cV-\u001a8!\u00039a\u0017\r^3tiRKW.Z*fK:\f!\u0003\\1uKN$H+[7f'\u0016,gn\u0018\u0013fcR!\u0011qLA9\u0011%\t9'GA\u0001\u0002\u0004\t)&A\bmCR,7\u000f\u001e+j[\u0016\u001cV-\u001a8!\u0003A!x\u000e^1m+B$\u0017\r^3J]\u0012,\u00070\u0001\u000bu_R\fG.\u00169eCR,\u0017J\u001c3fq~#S-\u001d\u000b\u0005\u0003?\nY\bC\u0005\u0002hq\t\t\u00111\u0001\u0002B\u0005\tBo\u001c;bYV\u0003H-\u0019;f\u0013:$W\r\u001f\u0011\u00021U\u0004H-\u0019;fgNKgnY3MCN$\u0018\nR\"iC:<W-\u0001\u000fva\u0012\fG/Z:TS:\u001cW\rT1ti&#5\t[1oO\u0016|F%Z9\u0015\t\u0005}\u0013Q\u0011\u0005\n\u0003Oz\u0012\u0011!a\u0001\u0003\u0003\n\u0011$\u001e9eCR,7oU5oG\u0016d\u0015m\u001d;J\t\u000eC\u0017M\\4fA\u0005)b.Z<J\tJ+\u0017/^5sK\u0012|e.\u00169eCR,WCAAG!\r!\u0015qR\u0005\u0004\u0003#+%a\u0002\"p_2,\u0017M\\\u0001\u001a]\u0016<\u0018\n\u0012*fcVL'/\u001a3P]V\u0003H-\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002`\u0005]\u0005\"CA4E\u0005\u0005\t\u0019AAG\u0003YqWm^%E%\u0016\fX/\u001b:fI>sW\u000b\u001d3bi\u0016\u0004\u0013aD2veJ,g\u000e^*pkJ\u001cW-\u0013#\u0002'\r,(O]3oiN{WO]2f\u0013\u0012{F%Z9\u0015\t\u0005}\u0013\u0011\u0015\u0005\n\u0003O*\u0013\u0011!a\u0001\u0003\u0003\n\u0001cY;se\u0016tGoU8ve\u000e,\u0017\n\u0012\u0011\u0002\u0015M,\u0017M]2i!\u0006$\b.\u0006\u0002\u0002*B)\u00111VA[)6\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0005j[6,H/\u00192mK*\u0019\u00111W#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00028\u00065&\u0001\u0002'jgR\fab]3be\u000eD\u0007+\u0019;i?\u0012*\u0017\u000f\u0006\u0003\u0002`\u0005u\u0006\"CA4Q\u0005\u0005\t\u0019AAU\u0003-\u0019X-\u0019:dQB\u000bG\u000f\u001b\u0011\u0002!\u0005$G\rV8Es:\fW.[2QCRDG\u0003BA0\u0003\u000bDa!a2+\u0001\u0004!\u0016\u0001\u00028b[\u0016\f\u0001b]8ve\u000e,\u0017\nR\u0001\u0006S:$W\r_\u0001\r\u0013\u00123uN]+qI\u0006$Xm\u001d\u000b\u0003\u0003\u0003\na\u0002[1oI2,\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002`\u0005U\u0007bBAl]\u0001\u0007\u0011\u0011\\\u0001\u0007kB$\u0017\r^3\u0011\t\u0005m\u0017Q\u001f\b\u0005\u0003;\fyO\u0004\u0003\u0002`\u0006-h\u0002BAq\u0003StA!a9\u0002h:\u0019q+!:\n\u0003\u0005K!a\u0010!\n\u0005ur\u0014bAAwy\u0005)qM]1qQ&!\u0011\u0011_Az\u0003=9%/\u00199i\u00032$XM]1uS>t'bAAwy%!\u0011q_A}\u0005-9%/\u00199i+B$\u0017\r^3\u000b\t\u0005E\u00181_\u0001\u0012Q\u0006tG\r\\3He\u0006\u0004\b.\u00169eCR,G\u0003BA0\u0003\u007fDq!a60\u0001\u0004\tI.\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\t\u0005\u000b\u0011\tB!\n\u0003*A!!q\u0001B\u0007\u001b\t\u0011IAC\u0002\u0003\f5\u000bq\u0002\u001d:pOJ,7o\u001d;sC\u000e\\WM]\u0005\u0005\u0005\u001f\u0011IAA\bQe><'/Z:t)J\f7m[3s\u0011\u001d\u0011\u0019\u0002\ra\u0001\u0005+\tQ!];fef\u0004BAa\u0006\u0003\"5\u0011!\u0011\u0004\u0006\u0005\u00057\u0011i\"\u0001\u0007rk\u0016\u0014\u00180\\1oC\u001e,'OC\u0002\u0003 q\n!bY8na>tWM\u001c;t\u0013\u0011\u0011\u0019C!\u0007\u0003\u000bE+XM]=\t\u0011\t\u001d\u0002\u0007%AA\u0002Q\u000bQbY;ti>l'j\u001c2OC6,\u0007b\u0002B\u0016a\u0001\u0007!QF\u0001\u0016GJ,\u0017\r^3Qe><'/Z:t)J\f7m[3s!\u0019!%q\u0006+\u0003\u0006%\u0019!\u0011G#\u0003\u0013\u0019+hn\u0019;j_:\f\u0014\u0001E:vE6LG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119DK\u0002U\u0005sY#Aa\u000f\u0011\t\tu\"qI\u0007\u0003\u0005\u007fQAA!\u0011\u0003D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000b*\u0015AC1o]>$\u0018\r^5p]&!!\u0011\nB \u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001bGJ,\u0017\r^3Rk\u0016\u0014\u0018\u0010\u0015:pOJ,7o\u001d+sC\u000e\\WM\u001d\u000b\u0005\u0005\u001f\u0012)\u0006\u0005\u0003\u0003\b\tE\u0013\u0002\u0002B*\u0005\u0013\u0011A#U;fef\u0004&o\\4sKN\u001cHK]1dW\u0016\u0014\bB\u0002B,e\u0001\u0007A+A\u0003k_\nLE)\u0001\rde\u0016\fG/\u001a+bE2,w*\u001e;qkR$&/Y2lKJ$bA!\u0018\u0003d\t\u0015\u0004\u0003\u0002B\u0004\u0005?JAA!\u0019\u0003\n\t\u0001\u0013+^3ssB\u0013xn\u001a:fgN$&/Y2lKJ<\u0016\u000e\u001e5Ji\u0016\u0014\u0018\r^8s\u0011\u0019\u00119f\ra\u0001)\"9!qM\u001aA\u0002\t%\u0014a\u0002;j[\u0016|W\u000f\u001e\t\u0005\u0005W\u0012)(\u0004\u0002\u0003n)!!q\u000eB9\u0003!!WO]1uS>t'b\u0001B:\u000b\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t]$Q\u000e\u0002\t\tV\u0014\u0018\r^5p]\u0006aA-Z:ue>LxI]1qQR!\u0011q\fB?\u0011\u001d\u0011y\b\u000ea\u0001\u0003\u001b\u000bQAZ8sG\u0016\f!\u0002Z5tG>tg.Z2u)\t\ty&\u0001\bfgR\f'\r\\5tQ\u001e\u0013\u0018\r\u001d5\u0002\u001bM,(-\\5u'>,(oY3t)\u0011\tyFa#\t\u000f\t5u\u00071\u0001\u0003\u0010\u000691o\\;sG\u0016\u001c\bCBA\t\u0005#\u0013)*\u0003\u0003\u0003\u0014\u0006}!aA*fcB\u0019!Ja&\n\u0007\te5J\u0001\u0004T_V\u00148-Z\u0001\u000fO\u0016$H)\u001a4bk2$h*Y7f)\r!&q\u0014\u0005\b\u0005'A\u0004\u0019\u0001B\u000b\u0001")
public class QuerySender
implements Graph {
    private final String graphID;
    private final RaphtoryService<IO> service;
    private final Config config;
    private final String clientID;
    private final Logger logger;
    private final int partitionServers;
    private final int partitionsPerServer;
    private final int totalPartitions;
    private long earliestTimeSeen;
    private long latestTimeSeen;
    private int totalUpdateIndex;
    private int updatesSinceLastIDChange;
    private boolean newIDRequiredOnUpdate;
    private int currentSourceID;
    private List<String> searchPath;

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        Graph.addVertex$(this, updateTime, srcId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        Graph.addVertex$(this, updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Marks a vertex as deleted\n    * @param updateTime time of deletion (a vertex is considered as no longer present in the graph after this time)\n    * @param srcId Id of vertex to delete\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void deleteVertex(long updateTime, long srcId, long secondaryIndex) {
        Graph.deleteVertex$(this, updateTime, srcId, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        Graph.addEdge$(this, updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        Graph.addEdge$(this, updateTime, srcId, dstId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Mark edge as deleted\n    * @param updateTime time of deletion (the edge is considered as no longer present in the graph after this time)\n    * @param srcId ID of source vertex of the edge\n    * @param dstId ID of the destination vertex of the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void deleteEdge(long updateTime, long srcId, long dstId, long secondaryIndex) {
        Graph.deleteEdge$(this, updateTime, srcId, dstId, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    public long assignID(String uniqueChars) {
        return Graph.assignID$(this, uniqueChars);
    }

    @Override
    public int getPartitionForId(long id) {
        return Graph.getPartitionForId$(this, id);
    }

    @Override
    public Properties addVertex$default$3() {
        return Graph.addVertex$default$3$(this);
    }

    @Override
    public MaybeType addVertex$default$4() {
        return Graph.addVertex$default$4$(this);
    }

    @Override
    public long addVertex$default$5() {
        return Graph.addVertex$default$5$(this);
    }

    @Override
    public long deleteVertex$default$3() {
        return Graph.deleteVertex$default$3$(this);
    }

    @Override
    public Properties addEdge$default$4() {
        return Graph.addEdge$default$4$(this);
    }

    @Override
    public MaybeType addEdge$default$5() {
        return Graph.addEdge$default$5$(this);
    }

    @Override
    public long addEdge$default$6() {
        return Graph.addEdge$default$6$(this);
    }

    @Override
    public long deleteEdge$default$4() {
        return Graph.deleteEdge$default$4$(this);
    }

    @Override
    public String graphID() {
        return this.graphID;
    }

    private RaphtoryService<IO> service() {
        return this.service;
    }

    private Config config() {
        return this.config;
    }

    private String clientID() {
        return this.clientID;
    }

    public Logger logger() {
        return this.logger;
    }

    public int partitionServers() {
        return this.partitionServers;
    }

    public int partitionsPerServer() {
        return this.partitionsPerServer;
    }

    @Override
    public int totalPartitions() {
        return this.totalPartitions;
    }

    private long earliestTimeSeen() {
        return this.earliestTimeSeen;
    }

    private void earliestTimeSeen_$eq(long x$1) {
        this.earliestTimeSeen = x$1;
    }

    private long latestTimeSeen() {
        return this.latestTimeSeen;
    }

    private void latestTimeSeen_$eq(long x$1) {
        this.latestTimeSeen = x$1;
    }

    private int totalUpdateIndex() {
        return this.totalUpdateIndex;
    }

    private void totalUpdateIndex_$eq(int x$1) {
        this.totalUpdateIndex = x$1;
    }

    private int updatesSinceLastIDChange() {
        return this.updatesSinceLastIDChange;
    }

    private void updatesSinceLastIDChange_$eq(int x$1) {
        this.updatesSinceLastIDChange = x$1;
    }

    private boolean newIDRequiredOnUpdate() {
        return this.newIDRequiredOnUpdate;
    }

    private void newIDRequiredOnUpdate_$eq(boolean x$1) {
        this.newIDRequiredOnUpdate = x$1;
    }

    private int currentSourceID() {
        return this.currentSourceID;
    }

    private void currentSourceID_$eq(int x$1) {
        this.currentSourceID = x$1;
    }

    private List<String> searchPath() {
        return this.searchPath;
    }

    private void searchPath_$eq(List<String> x$1) {
        this.searchPath = x$1;
    }

    public void addToDynamicPath(String name) {
        String string = name;
        this.searchPath_$eq((List<String>)this.searchPath().$colon$colon((Object)string));
    }

    @Override
    public int sourceID() {
        return this.IDForUpdates();
    }

    @Override
    public long index() {
        return this.totalUpdateIndex();
    }

    public int IDForUpdates() {
        if (this.newIDRequiredOnUpdate()) {
            Option<Object> option;
            OptionalId optionalId = (OptionalId)((IOPlatform)this.service().getNextAvailableId(new IdPool(this.graphID(), IdPool$.MODULE$.apply$default$2()))).unsafeRunSync(implicits$.MODULE$.global());
            if (optionalId != null && (option = optionalId.id()) instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                this.currentSourceID_$eq(id);
                this.newIDRequiredOnUpdate_$eq(false);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Option<Object> option2;
                if (optionalId != null && None$.MODULE$.equals(option2 = optionalId.id())) {
                    throw new NoIDException(new StringBuilder(45).append("Client '").append(this.clientID()).append("' was not able to acquire a source ID").toString());
                }
                throw new MatchError((Object)optionalId);
            }
        }
        return this.currentSourceID();
    }

    public void handleInternal(GraphAlteration.GraphUpdate update) {
        this.handleGraphUpdate(update);
    }

    @Override
    public void handleGraphUpdate(GraphAlteration.GraphUpdate update) {
        this.earliestTimeSeen_$eq(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.earliestTimeSeen()), update.updateTime()));
        this.latestTimeSeen_$eq(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(this.latestTimeSeen()), update.updateTime()));
        ((IOPlatform)this.service().processUpdate(new GraphUpdate(this.graphID(), update, GraphUpdate$.MODULE$.apply$default$3()))).unsafeRunSync(implicits$.MODULE$.global());
        this.totalUpdateIndex_$eq(this.totalUpdateIndex() + 1);
        this.updatesSinceLastIDChange_$eq(this.updatesSinceLastIDChange() + 1);
    }

    public ProgressTracker submit(com.raphtory.internals.components.querymanager.Query query, String customJobName, Function1<String, ProgressTracker> createProgressTracker) {
        String jobName = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(customJobName)) ? customJobName : this.getDefaultName(query);
        String jobID = new StringBuilder(1).append(jobName).append("_").append(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(Random$.MODULE$.nextLong()))).toString();
        ProgressTracker progressTracker = (ProgressTracker)createProgressTracker.apply((Object)jobID);
        if (this.updatesSinceLastIDChange() > 0) {
            this.updatesSinceLastIDChange_$eq(0);
            this.newIDRequiredOnUpdate_$eq(true);
        }
        String x$1 = jobID;
        DynamicLoader x$2 = query._bootstrap().resolve(this.searchPath());
        long x$3 = this.earliestTimeSeen();
        long x$4 = this.latestTimeSeen();
        String x$5 = query.copy$default$2();
        PointSet x$6 = query.copy$default$4();
        long x$7 = query.copy$default$5();
        long x$8 = query.copy$default$6();
        Interval[] x$9 = query.copy$default$7();
        Enumeration.Value x$10 = query.copy$default$8();
        List<Operation> x$11 = query.copy$default$9();
        Option<Sink> x$12 = query.copy$default$12();
        Option<String> x$13 = query.copy$default$13();
        com.raphtory.internals.components.querymanager.Query outputQuery = query.copy(x$2, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$3, x$4, x$12, x$13);
        Stream responses = (Stream)((IOPlatform)this.service().submitQuery(new Query(new TryQuery((Try<com.raphtory.internals.components.querymanager.Query>)new Success((Object)outputQuery)), Query$.MODULE$.apply$default$2()))).unsafeRunSync(implicits$.MODULE$.global());
        ((IO)responses.map((Function1 & Serializable)message -> message.toQueryUpdate()).foreach((Function1 & Serializable)update -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> progressTracker.handleQueryUpdate((QueryUpdate)update))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain()).unsafeRunAndForget(implicits$.MODULE$.global());
        return progressTracker;
    }

    public String submit$default$2() {
        return "";
    }

    public QueryProgressTracker createQueryProgressTracker(String jobID) {
        return QueryProgressTracker$.MODULE$.apply(this.graphID(), jobID, this.config());
    }

    public QueryProgressTrackerWithIterator createTableOutputTracker(String jobID, Duration timeout) {
        return QueryProgressTrackerWithIterator$.MODULE$.apply(this.graphID(), jobID, this.config(), timeout);
    }

    public void destroyGraph(boolean force) {
        ((IOPlatform)this.service().destroyGraph(new DestroyGraph(this.clientID(), this.graphID(), force, DestroyGraph$.MODULE$.apply$default$4()))).unsafeRunSync(implicits$.MODULE$.global());
    }

    public void disconnect() {
        ((IOPlatform)this.service().disconnect(new GraphInfo(this.clientID(), this.graphID(), GraphInfo$.MODULE$.apply$default$3()))).unsafeRunSync(implicits$.MODULE$.global());
    }

    public void establishGraph() {
        ((IOPlatform)this.service().establishGraph(new GraphInfo(this.clientID(), this.graphID(), GraphInfo$.MODULE$.apply$default$3()))).unsafeRunSync(implicits$.MODULE$.global());
    }

    public void submitSources(Seq<Source> sources) {
        List clazzes = ((IterableOnceOps)sources.map((Function1 & Serializable)x$1 -> x$1.getBuilderClass())).toList();
        Seq sourceWithId = (Seq)sources.map((Function1 & Serializable)source -> {
            Option<Object> option;
            OptionalId optionalId = (OptionalId)((IOPlatform)this.service().getNextAvailableId(new IdPool(this.graphID(), IdPool$.MODULE$.apply$default$2()))).unsafeRunSync(implicits$.MODULE$.global());
            if (optionalId == null || !((option = optionalId.id()) instanceof Some)) {
                Option<Object> option2;
                if (optionalId != null && None$.MODULE$.equals(option2 = optionalId.id())) {
                    throw new NoIDException(new StringBuilder(50).append("Client '").append(this.clientID()).append("' was not able to acquire a source ID for ").append(source).toString());
                }
                throw new MatchError((Object)optionalId);
            }
            Some some = (Some)option;
            int id = BoxesRunTime.unboxToInt((Object)some.value());
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), source);
            return tuple2;
        });
        sourceWithId.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            Source source = (Source)tuple2._2();
            IngestData ingestData = new IngestData(new DynamicLoader(clazzes, DynamicLoader$.MODULE$.apply$default$2()).resolve(this.searchPath()), this.graphID(), id, source);
            Status status = (Status)((IOPlatform)this.service().submitSource(new com.raphtory.protocol.IngestData(new TryIngestData((Try<IngestData>)new Success((Object)ingestData)), IngestData$.MODULE$.apply$default$2()))).unsafeRunSync(implicits$.MODULE$.global());
            return status;
        });
    }

    private String getDefaultName(com.raphtory.internals.components.querymanager.Query query) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(query.name())) ? query.name() : Integer.toString(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(query.hashCode())));
    }

    public QuerySender(String graphID, RaphtoryService<IO> service, Config config, String clientID) {
        this.graphID = graphID;
        this.service = service;
        this.config = config;
        this.clientID = clientID;
        Graph.$init$(this);
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.partitionServers = config.getInt("raphtory.partitions.serverCount");
        this.partitionsPerServer = config.getInt("raphtory.partitions.countPerServer");
        this.totalPartitions = this.partitionServers() * this.partitionsPerServer();
        this.earliestTimeSeen = Long.MAX_VALUE;
        this.latestTimeSeen = Long.MIN_VALUE;
        this.totalUpdateIndex = 0;
        this.updatesSinceLastIDChange = 0;
        this.newIDRequiredOnUpdate = true;
        this.currentSourceID = -1;
        this.searchPath = package$.MODULE$.List().empty();
    }

    public class NoIDException
    extends Exception {
        public /* synthetic */ QuerySender com$raphtory$internals$management$QuerySender$NoIDException$$$outer() {
            return QuerySender.this;
        }

        public NoIDException(String message) {
            if (QuerySender.this == null) {
                throw null;
            }
            super(message);
        }
    }
}

