/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.progresstracker;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.progresstracker.ProgressTracker;
import com.raphtory.api.progresstracker.QueryProgressTracker;
import com.raphtory.api.progresstracker.QueryProgressTracker$;
import com.raphtory.internals.graph.Perspective;
import com.raphtory.protocol.PerspectiveCompleted;
import com.raphtory.protocol.PerspectiveFailed;
import com.raphtory.protocol.QueryCompleted;
import com.raphtory.protocol.QueryFailed;
import com.raphtory.protocol.QueryUpdate;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@Scaladoc(value="/** Tracks the progress of Raphtory queries in terms of number of perspectives processed and duration taken to process each perspective.\n  * Queries in Raphtory run on a series of `Perspectives` which are how the graph would have looked at specific timestamps with given windows.\n  * The progress tracker thus helps track query progress until the job is completed\n  *\n  * @example\n  * {{{\n  * import com.raphtory.Raphtory\n  * import com.raphtory.FileSpout\n  * import com.raphtory.algorithms.generic.ConnectedComponents\n  * import com.raphtory.sinks.FileSink\n  *\n  * val graph = Raphtory.load(FileSpout(\"/path/to/your/data\"), YourGraphBuilder())\n  * val queryProgressTracker = graph.range(1, 32674, 10000)\n  *   .window(List(500, 1000, 10000))\n  *   .execute(ConnectedComponents)\n  *   .writeTo(FileSink(\"/test_dir\"))\n  * val jobId                = queryProgressTracker.getJobId()\n  * queryProgressTracker.waitForJob()\n  * val perspectivesProcessed = queryProgressTracker.getPerspectivesProcessed()\n  * }}}\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\u000f\u001f\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tu\u0001\u0011\t\u0011)A\u0005[!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0004E\u0001\u0011\u0005!%\u0012\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019\u0011\u0006\u0001)A\u0005\u0019\"91\u000b\u0001a\u0001\n\u0013!\u0006bB-\u0001\u0001\u0004%IA\u0017\u0005\u0007A\u0002\u0001\u000b\u0015B+\t\u000f\u0005\u0004!\u0019!C\u0005)\"1!\r\u0001Q\u0001\nUCqa\u0019\u0001A\u0002\u0013%A\u000bC\u0004e\u0001\u0001\u0007I\u0011B3\t\r\u001d\u0004\u0001\u0015)\u0003V\u0011\u001dA\u0007A1A\u0005\u0012%Da\u0001\u001d\u0001!\u0002\u0013Q\u0007\"B9\u0001\t\u0003\u0012\b\"B>\u0001\t\u0003a\b\"CA\u0014\u0001E\u0005I\u0011AA\u0015\u000f\u001d\t)E\bE\u0001\u0003\u000f2a!\b\u0010\t\u0002\u0005%\u0003B\u0002#\u0016\t\u0003\t\t\u0006C\u0004\u0002TU!\t!!\u0016\b\u000f\u0005}S\u0003#\u0003\u0002b\u00199\u0011QM\u000b\t\n\u0005\u001d\u0004B\u0002#\u001a\t\u0003\tIG\u0002\u0004\u0002le\u0001\u0011Q\u000e\u0005\u0007\tn!\t!!!\u0003)E+XM]=Qe><'/Z:t)J\f7m[3s\u0015\ty\u0002%A\bqe><'/Z:tiJ\f7m[3s\u0015\t\t#%A\u0002ba&T!a\t\u0013\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011!J\u0001\u0004G>l7\u0001A\n\u0003\u0001!\u0002\"!\u000b\u0016\u000e\u0003yI!a\u000b\u0010\u0003\u001fA\u0013xn\u001a:fgN$&/Y2lKJ\fqa\u001a:ba\"LE\t\u0005\u0002/o9\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0003e\u0019\na\u0001\u0010:p_Rt$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u001a\u0002\u000b)|'-\u0013#\u0002\t\r|gN\u001a\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000baaY8oM&<'BA!%\u0003!!\u0018\u0010]3tC\u001a,\u0017BA\"?\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"BAR$I\u0013B\u0011\u0011\u0006\u0001\u0005\u0006Y\u0011\u0001\r!\f\u0005\u0006u\u0011\u0001\r!\f\u0005\u0006w\u0011\u0001\r\u0001P\u0001\u0007Y><w-\u001a:\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014!\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\n\u0005Es%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002+A,'o\u001d9fGRLg/Z:Qe>\u001cWm]:fIV\tQ\u000b\u0005\u0002W/6\t1'\u0003\u0002Yg\t!Aj\u001c8h\u0003e\u0001XM]:qK\u000e$\u0018N^3t!J|7-Z:tK\u0012|F%Z9\u0015\u0005ms\u0006C\u0001,]\u0013\ti6G\u0001\u0003V]&$\bbB0\t\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0014A\u00069feN\u0004Xm\u0019;jm\u0016\u001c\bK]8dKN\u001cX\r\u001a\u0011\u0002\u0013M$\u0018M\u001d;US6,\u0017AC:uCJ$H+[7fA\u0005y\u0001/\u001a:ta\u0016\u001cG/\u001b<f)&lW-A\nqKJ\u001c\b/Z2uSZ,G+[7f?\u0012*\u0017\u000f\u0006\u0002\\M\"9q,DA\u0001\u0002\u0004)\u0016\u0001\u00059feN\u0004Xm\u0019;jm\u0016$\u0016.\\3!\u0003QI7OS8c\r&t\u0017n\u001d5fIB\u0013x.\\5tKV\t!\u000eE\u0002l]nk\u0011\u0001\u001c\u0006\u0003[N\n!bY8oGV\u0014(/\u001a8u\u0013\tyGNA\u0004Qe>l\u0017n]3\u0002+%\u001c(j\u001c2GS:L7\u000f[3e!J|W.[:fA\u0005\t\u0002.\u00198eY\u0016\fV/\u001a:z+B$\u0017\r^3\u0015\u0005m\u001b\b\"\u0002;\u0012\u0001\u0004)\u0018aA7tOB\u0011a/_\u0007\u0002o*\u0011\u0001PI\u0001\taJ|Go\\2pY&\u0011!p\u001e\u0002\f#V,'/_+qI\u0006$X-\u0001\u0006xC&$hi\u001c:K_\n$\"aW?\t\u000fy\u0014\u0002\u0013!a\u0001\u007f\u00069A/[7f_V$\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015A.\u0001\u0005ekJ\fG/[8o\u0013\u0011\tI!a\u0001\u0003\u0011\u0011+(/\u0019;j_:DsAEA\u0007\u0003C\t\u0019\u0003\u0005\u0003\u0002\u0010\u0005uQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0011M\u001c\u0017\r\\1e_\u000eTA!a\u0006\u0002\u001a\u00059A/Y6fu>,'bAA\u000eI\u00051q-\u001b;ik\nLA!a\b\u0002\u0012\tA1kY1mC\u0012|7-A\u0003wC2,X-\t\u0002\u0002&\u0005\u0011sF\u000b\u0016!\u00052|7m\u001b\u0011v]RLG\u000e\t6pE\u0002J7\u000fI2p[BdW\r^3!U=\nAc^1ji\u001a{'OS8cI\u0011,g-Y;mi\u0012\nTCAA\u0016U\ry\u0018QF\u0016\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011H\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0005M\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\":\u0001!!\u0004\u0002\"\u0005\u0005\u0013EAA\"\u0003\u001d\u0015xF\u000b\u0016!)J\f7m[:!i\",\u0007\u0005\u001d:pOJ,7o\u001d\u0011pM\u0002\u0012\u0016\r\u001d5u_JL\b%];fe&,7\u000fI5oAQ,'/\\:!_\u001a\u0004c.^7cKJ\u0004sN\u001a\u0011qKJ\u001c\b/Z2uSZ,7\u000f\t9s_\u000e,7o]3eA\u0005tG\r\t3ve\u0006$\u0018n\u001c8!i\u0006\\WM\u001c\u0011u_\u0002\u0002(o\\2fgN\u0004S-Y2iAA,'o\u001d9fGRLg/\u001a\u0018\u000bA\u0001R\u0003%U;fe&,7\u000fI5oAI\u000b\u0007\u000f\u001b;pef\u0004#/\u001e8!_:\u0004\u0013\rI:fe&,7\u000fI8gA\u0001\u0004VM]:qK\u000e$\u0018N^3tA\u0002:\b.[2iA\u0005\u0014X\r\t5po\u0002\"\b.\u001a\u0011he\u0006\u0004\b\u000eI<pk2$\u0007\u0005[1wK\u0002bwn\\6fI\u0002\nG\u000fI:qK\u000eLg-[2!i&lWm\u001d;b[B\u001c\be^5uQ\u0002:\u0017N^3oA]Lg\u000eZ8xg:R\u0001\u0005\t\u0016!)\",\u0007\u0005\u001d:pOJ,7o\u001d\u0011ue\u0006\u001c7.\u001a:!i\",8\u000f\t5fYB\u001c\b\u0005\u001e:bG.\u0004\u0013/^3ss\u0002\u0002(o\\4sKN\u001c\b%\u001e8uS2\u0004C\u000f[3!U>\u0014\u0007%[:!G>l\u0007\u000f\\3uK\u0012T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005Q3yC6\u0004H.\u001a\u0006!A)\u00023p_>\u000bA\u0001R\u0003%[7q_J$\beY8n]I\f\u0007\u000f\u001b;peft#+\u00199ii>\u0014\u0018P\u0003\u0011!U\u0001JW\u000e]8si\u0002\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0019KG.Z*q_V$(\u0002\t\u0011+A%l\u0007o\u001c:uA\r|WN\f:ba\"$xN]=/C2<wN]5uQ6\u001chfZ3oKJL7ML\"p]:,7\r^3e\u0007>l\u0007o\u001c8f]R\u001c(\u0002\t\u0011+A%l\u0007o\u001c:uA\r|WN\f:ba\"$xN]=/g&t7n\u001d\u0018GS2,7+\u001b8l\u0015\u0001\u0002#F\u0003\u0011!U\u00012\u0018\r\u001c\u0011he\u0006\u0004\b\u000eI\u001f!%\u0006\u0004\b\u000e^8ss:bw.\u00193)\r&dWm\u00159pkRD#e\f9bi\"|Co\\\u0018z_V\u0014x\u0006Z1uC\nJC\u0006I-pkJ<%/\u00199i\u0005VLG\u000eZ3sQ%J#\u0002\t\u0011+AY\fG\u000eI9vKJL\bK]8he\u0016\u001c8\u000f\u0016:bG.,'\u000fI\u001f!OJ\f\u0007\u000f\u001b\u0018sC:<W\rK\u0019-AM\u0012dg\u000e\u001b-AE\u0002\u0004\u0007\r\u0019*\u0015\u0001\u0002#\u0006\t\u0011!]]Lg\u000eZ8xQ1K7\u000f\u001e\u00156aAb\u0003%\r\u00191a1\u0002\u0013\u0007\r\u00191a%J#\u0002\t\u0011+A\u0001\u0002c&\u001a=fGV$X\rK\"p]:,7\r^3e\u0007>l\u0007o\u001c8f]R\u001c\u0018F\u0003\u0011!U\u0001\u0002\u0003EL<sSR,Gk\u001c\u0015GS2,7+\u001b8lQ\tzC/Z:u?\u0012L'OI\u0015*\u0015\u0001\u0002#\u0006\t<bY\u0002RwNY%eA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0004%];fef\u0004&o\\4sKN\u001cHK]1dW\u0016\u0014hfZ3u\u0015>\u0014\u0017\n\u001a\u0015*\u0015\u0001\u0002#\u0006I9vKJL\bK]8he\u0016\u001c8\u000f\u0016:bG.,'OL<bSR4uN\u001d&pE\"J#\u0002\t\u0011+AY\fG\u000e\t9feN\u0004Xm\u0019;jm\u0016\u001c\bK]8dKN\u001cX\r\u001a\u0011>AE,XM]=Qe><'/Z:t)J\f7m[3s]\u001d,G\u000fU3sgB,7\r^5wKN\u0004&o\\2fgN,G\rK\u0015\u000bA\u0001R\u0003%`?~\u0015\u0001\u0002#fL\u0001\u0015#V,'/\u001f)s_\u001e\u0014Xm]:Ue\u0006\u001c7.\u001a:\u0011\u0005%*2cA\u000b\u0002LA\u0019a+!\u0014\n\u0007\u0005=3G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u000f\nQ!\u00199qYf$rARA,\u00033\ni\u0006C\u0003-/\u0001\u0007Q\u0006\u0003\u0004\u0002\\]\u0001\r!L\u0001\u0006U>\u0014\u0017\n\u001a\u0005\u0006\u007f]\u0001\r\u0001P\u0001\u001e#V,'/\u001f)s_\u001e\u0014Xm]:Ue\u0006\u001c7.\u001a:Fq\u000e,\u0007\u000f^5p]B\u0019\u00111M\r\u000e\u0003U\u0011Q$U;fef\u0004&o\\4sKN\u001cHK]1dW\u0016\u0014X\t_2faRLwN\\\n\u00043\u0005-CCAA1\u00055!uN\\3Fq\u000e,\u0007\u000f^5p]N\u00191$a\u001c\u0011\t\u0005E\u00141\u0010\b\u0005\u0003g\n9HD\u00021\u0003kJ\u0011\u0001N\u0005\u0004\u0003s\u001a\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyHA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019\u0011\u0011P\u001a\u0015\u0005\u0005\r\u0005cAAC75\t\u0011\u0004")
public class QueryProgressTracker
extends ProgressTracker {
    private final String jobID;
    private final Logger logger;
    private long perspectivesProcessed;
    private final long startTime;
    private long perspectiveTime;
    private final Promise<BoxedUnit> isJobFinishedPromise;

    public static QueryProgressTracker apply(String graphID, String jobId, Config config) {
        return QueryProgressTracker$.MODULE$.apply(graphID, jobId, config);
    }

    private Logger logger() {
        return this.logger;
    }

    private long perspectivesProcessed() {
        return this.perspectivesProcessed;
    }

    private void perspectivesProcessed_$eq(long x$1) {
        this.perspectivesProcessed = x$1;
    }

    private long startTime() {
        return this.startTime;
    }

    private long perspectiveTime() {
        return this.perspectiveTime;
    }

    private void perspectiveTime_$eq(long x$1) {
        this.perspectiveTime = x$1;
    }

    public Promise<BoxedUnit> isJobFinishedPromise() {
        return this.isJobFinishedPromise;
    }

    @Override
    public void handleQueryUpdate(QueryUpdate msg) {
        QueryUpdate queryUpdate = msg;
        boolean bl = queryUpdate instanceof PerspectiveCompleted ? true : queryUpdate instanceof PerspectiveFailed;
        if (bl) {
            BoxedUnit boxedUnit;
            Tuple3 tuple3;
            long perspectiveDuration = System.currentTimeMillis() - this.perspectiveTime();
            QueryUpdate queryUpdate2 = msg;
            if (queryUpdate2 instanceof PerspectiveCompleted) {
                PerspectiveCompleted perspectiveCompleted = (PerspectiveCompleted)queryUpdate2;
                Perspective perspective = perspectiveCompleted.perspective();
                tuple3 = new Tuple3((Object)perspective, (Object)"finished", (Function1 & Serializable)x$1 -> {
                    QueryProgressTracker.$anonfun$handleQueryUpdate$1(this, x$1);
                    return BoxedUnit.UNIT;
                });
            } else if (queryUpdate2 instanceof PerspectiveFailed) {
                PerspectiveFailed perspectiveFailed = (PerspectiveFailed)queryUpdate2;
                Perspective perspective = perspectiveFailed.perspective();
                String reason = perspectiveFailed.reason();
                tuple3 = new Tuple3((Object)perspective, (Object)new StringBuilder(19).append("failed (reason: '").append(reason).append("')").toString(), (Function1 & Serializable)x$2 -> {
                    QueryProgressTracker.$anonfun$handleQueryUpdate$2(this, x$2);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)queryUpdate2);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            Perspective perspective = (Perspective)tuple32._1();
            String result = (String)tuple32._2();
            Function1 logFunction = (Function1)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)perspective, (Object)result, (Object)logFunction);
            Tuple3 tuple34 = tuple33;
            Perspective perspective2 = (Perspective)tuple34._1();
            String result2 = (String)tuple34._2();
            Function1 logFunction2 = (Function1)tuple34._3();
            String windowInfo = perspective2.window().nonEmpty() ? new StringBuilder(15).append(" with window '").append(perspective2.window().get()).append("'").toString() : "";
            String logMsg = new StringBuilder(34).append("Job '").append(this.jobID).append("': Perspective '").append(perspective2.timestamp()).append("'").append(windowInfo).append(" ").append(result2).append(" after ").append(perspectiveDuration).append(" ms.").toString();
            logFunction2.apply((Object)logMsg);
            this.perspectiveTime_$eq(System.currentTimeMillis());
            this.perspectivesProcessed_$eq(this.perspectivesProcessed() + 1L);
            this.latestPerspective_$eq((Option<com.raphtory.api.time.Perspective>)new Some((Object)perspective2));
            this.perspectivesList().addOne((Object)perspective2);
            this.perspectivesDurations().addOne((Object)BoxesRunTime.boxToLong((long)perspectiveDuration));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Job {}: Running query, processed {} perspectives.", new Object[]{this.jobID, BoxesRunTime.boxToLong((long)this.perspectivesProcessed())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (queryUpdate instanceof QueryCompleted) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(0).append(new StringBuilder(41).append("Job ").append(this.jobID).append(": Query completed with ").append(this.perspectivesProcessed()).append(" perspectives ").toString()).append(new StringBuilder(20).append("and finished in ").append(System.currentTimeMillis() - this.startTime()).append(" ms.").toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.jobDone_$eq(true);
            this.isJobFinishedPromise().complete((Try)new Success((Object)BoxedUnit.UNIT));
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (queryUpdate instanceof QueryFailed) {
            BoxedUnit boxedUnit;
            QueryFailed queryFailed = (QueryFailed)queryUpdate;
            String reason = queryFailed.reason();
            this.isJobFinishedPromise().failure((Throwable)new RuntimeException(reason));
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("The execution of the query '{}' failed. Cause: '{}'", new Object[]{this.jobID, reason});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError((Object)queryUpdate);
        }
    }

    @Scaladoc(value="/** Block until job is complete */")
    public void waitForJob(Duration timeout) {
        try {
            Await$.MODULE$.result((Awaitable)this.isJobFinishedPromise().future(), timeout);
        }
        catch (QueryProgressTrackerException.DoneException doneException) {}
    }

    public Duration waitForJob$default$1() {
        return Duration$.MODULE$.Inf();
    }

    public static final /* synthetic */ void $anonfun$handleQueryUpdate$1(QueryProgressTracker $this, String x$1) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(x$1);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$handleQueryUpdate$2(QueryProgressTracker $this, String x$2) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(x$2);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public QueryProgressTracker(String graphID, String jobID, Config conf) {
        this.jobID = jobID;
        super(jobID);
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.perspectivesProcessed = 0L;
        this.startTime = System.currentTimeMillis();
        this.perspectiveTime = this.startTime();
        this.isJobFinishedPromise = Promise$.MODULE$.apply();
    }
}

