/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.input;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.NoType$;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.management.telemetry.TelemetryReporter$;
import io.prometheus.client.Counter;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Scaladoc(value="/** trait for creating a Graph by adding and deleting vertices and edges.\n  *\n  * An implementation of `GraphBuilder` needs to override `parseTuple(tuple: T)` to define parsing of input data.\n  * The input data is generated using a [[com.raphtory.api.input.Spout Spout]] and passed to the\n  * `parseTuple` method which is responsible for turning the raw data into a list of graph updates. Inside the\n  * `parseTuple` implementation, use methods `addVertex`/`deleteVertex` and `addEdge`/`deleteEdge`\n  * for adding/deleting vertices and edges. The resulting graph updates are send to the partitions responsible for\n  * handling the vertices and edges.\n  *\n  * @example\n  * {{{\n  * class TwitterGraphBuilder() extends GraphBuilder[String] {\n  *   override def parseTuple(fileLine: String): Unit = {\n  *     val sourceNode = fileLine(0)\n  *     val srcID      = sourceNode.toLong\n  *     val targetNode = fileLine(1)\n  *     val tarID      = targetNode.toLong\n  *     val timeStamp  = fileLine(2).toLong\n  *\n  *     addVertex(timeStamp, srcID, Properties(ImmutableProperty(\"name\", sourceNode)), Type(\"User\"))\n  *     addVertex(timeStamp, tarID, Properties(ImmutableProperty(\"name\", targetNode)), Type(\"User\"))\n  *     addEdge(timeStamp, srcID, tarID, Type(\"Follows\"))\n  *   }\n  * }\n  * }}}\n  * @see [[Properties]] [[Spout]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005%haB\u0010!!\u0003\r\t!\u000b\u0005\u0006a\u0001!\t!\r\u0005\u0006k\u00011\tA\u000e\u0005\u0006u\u00011\tb\u000f\u0005\u0006)\u00021\tB\u000e\u0005\u0006+\u00021\tA\u0016\u0005\u00065\u00021\ta\u0017\u0005\u0006I\u0002!I!\u001a\u0005\u0006e\u0002!I!\u001a\u0005\u0006g\u0002!I!\u001a\u0005\u0006i\u0002!I!\u001a\u0005\u0006k\u0002!\tA\u001e\u0005\u0007k\u0002!\t!a\b\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA*\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\ty\t\u0001C\u0001\u0003#C\u0001\"!(\u0001\t\u0003!\u0013q\u0014\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003OC\u0011\"!0\u0001#\u0003%\t!a0\t\u0013\u0005\r\u0007!%A\u0005\u0002\u0005\u0015\u0007\"CAe\u0001E\u0005I\u0011AAc\u0011%\tY\rAI\u0001\n\u0003\t9\u000bC\u0005\u0002N\u0002\t\n\u0011\"\u0001\u0002@\"I\u0011q\u001a\u0001\u0012\u0002\u0013\u0005\u0011Q\u0019\u0005\n\u0003#\u0004\u0011\u0013!C\u0001\u0003\u000b<q!!7!\u0011\u0003\tYN\u0002\u0004 A!\u0005\u0011Q\u001c\u0005\b\u0003?dB\u0011AAq\u0011\u001d\ty\t\bC\u0001\u0003G\u0014Qa\u0012:ba\"T!!\t\u0012\u0002\u000b%t\u0007/\u001e;\u000b\u0005\r\"\u0013aA1qS*\u0011QEJ\u0001\te\u0006\u0004\b\u000e^8ss*\tq%A\u0002d_6\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u001a\u0011\u0005-\u001a\u0014B\u0001\u001b-\u0005\u0011)f.\u001b;\u0002\u001fQ|G/\u00197QCJ$\u0018\u000e^5p]N,\u0012a\u000e\t\u0003WaJ!!\u000f\u0017\u0003\u0007%sG/A\tiC:$G.Z$sCBDW\u000b\u001d3bi\u0016$\"A\r\u001f\t\u000bu\u001a\u0001\u0019\u0001 \u0002\rU\u0004H-\u0019;f!\ty\u0014K\u0004\u0002A\u001d:\u0011\u0011i\u0013\b\u0003\u0005&s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019C\u0013A\u0002\u001fs_>$h(C\u0001(\u0013\t)c%\u0003\u0002KI\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0003\u00196\u000bQa\u001a:ba\"T!A\u0013\u0013\n\u0005=\u0003\u0016aD$sCBD\u0017\t\u001c;fe\u0006$\u0018n\u001c8\u000b\u00051k\u0015B\u0001*T\u0005-9%/\u00199i+B$\u0017\r^3\u000b\u0005=\u0003\u0016\u0001C:pkJ\u001cW-\u0013#\u0002\u000b%tG-\u001a=\u0016\u0003]\u0003\"a\u000b-\n\u0005ec#\u0001\u0002'p]\u001e\fqa\u001a:ba\"LE)F\u0001]!\ti\u0016M\u0004\u0002_?B\u0011A\tL\u0005\u0003A2\na\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001\rL\u0001\u0011m\u0016\u0014H/\u001a=BI\u0012\u001cu.\u001e8uKJ,\u0012A\u001a\t\u0003OBl\u0011\u0001\u001b\u0006\u0003S*\fqaQ8v]R,'O\u0003\u0002lY\u000611\r\\5f]RT!!\u001c8\u0002\u0015A\u0014x.\\3uQ\u0016,8OC\u0001p\u0003\tIw.\u0003\u0002rQ\n)1\t[5mI\u0006\u0019b/\u001a:uKb$U\r\\3uK\u000e{WO\u001c;fe\u0006qQ\rZ4f\u0003\u0012$7i\\;oi\u0016\u0014\u0018!E3eO\u0016$U\r\\3uK\u000e{WO\u001c;fe\u0006I\u0011\r\u001a3WKJ$X\r\u001f\u000b\u0005e]L8\u0010C\u0003y\u0017\u0001\u0007q+\u0001\u0006va\u0012\fG/\u001a+j[\u0016DQA_\u0006A\u0002]\u000bQa\u001d:d\u0013\u0012DQ\u0001`\u0006A\u0002u\f!\u0002]8t)f\u0004X-\u0011:h!\tqx0D\u0001!\u0013\r\t\t\u0001\t\u0002\u0005)f\u0004X\rK\u0004\f\u0003\u000b\tI\"a\u0007\u0011\t\u0005\u001d\u0011QC\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005A1oY1mC\u0012|7M\u0003\u0003\u0002\u0010\u0005E\u0011a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003'1\u0013AB4ji\",(-\u0003\u0003\u0002\u0018\u0005%!\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005u\u0011!a:0U)\u0002\u0013\t\u001a3tA\u0005\u0004c.Z<!m\u0016\u0014H/\u001a=!i>\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011pe\u0002*\b\u000fZ1uKN\u0004\u0013M\u001c\u0011fq&\u001cH/\u001b8hAY,'\u000f^3y\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011va\u0012\fG/\u001a+j[\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011g_J\u0004c/\u001a:uKb\u0004S\u000f\u001d3bi\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001a(oY%eA\u0001\u0002\u0003\u0005\t\u0011J\t\u0002zg\r\t<feR,\u0007\u0010\t;pA\u0005$GmL;qI\u0006$XM\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005]8t)f\u0004X-\u0011:hAM\u0004XmY5gs\u0002\n\u0007eW.UsB,\u0007\u0005V=qKvk\u0006EZ8sAQDW\r\t<feR,\u0007P\u0003\u0011!A\u0001Rs\u0006F\u00063\u0003C\t\u0019#!\n\u00020\u0005e\u0002\"\u0002=\r\u0001\u00049\u0006\"\u0002>\r\u0001\u00049\u0006\"CA\u0014\u0019A\u0005\t\u0019AA\u0015\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0004}\u0006-\u0012bAA\u0017A\tQ\u0001K]8qKJ$\u0018.Z:\t\u0013\u0005EB\u0002%AA\u0002\u0005M\u0012A\u0003<feR,\u0007\u0010V=qKB\u0019a0!\u000e\n\u0007\u0005]\u0002EA\u0005NCf\u0014W\rV=qK\"A\u00111\b\u0007\u0011\u0002\u0003\u0007q+\u0001\btK\u000e|g\u000eZ1ss&sG-\u001a=)\u000f1\t)!!\u0007\u0002@\u0005\u0012\u0011\u0011I\u0001\u0005\f>R#\u0006I!eIN\u0004\u0013\r\t8fo\u00022XM\u001d;fq\u0002\"x\u000e\t;iK\u0002:'/\u00199iA=\u0014\b%\u001e9eCR,7\u000fI1oA\u0015D\u0018n\u001d;j]\u001e\u0004c/\u001a:uKbT\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAU\u0004H-\u0019;f)&lW\r\t;j[\u0016\u001cH/Y7qA\u0019|'\u000f\t<feR,\u0007\u0010I;qI\u0006$XM\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007e\u001d:d\u0013\u0012\u0004\u0003\u0005\t\u0011!A%#\u0005e\u001c4!m\u0016\u0014H/\u001a=!i>\u0004\u0013\r\u001a30kB$\u0017\r^3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011qe>\u0004XM\u001d;jKN\u0004s\n\u001d;j_:\fG\u000e\\=!gB,7-\u001b4zAY,'\u000f^3yAA\u0014x\u000e]3si&,7\u000f\t4pe\u0002\"\b.\u001a\u0011va\u0012\fG/\u001a\u0011)g\u0016,\u0007eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:Jg\u000e];u]A\u0013x\u000e]3si&,7\u000f\t)s_B,'\u000f^5fgvk\u0006EZ8sAQDWM\u0003\u0011!A\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u00054\u0018-\u001b7bE2,\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011usB,7/\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t<feR,\u0007\u0010V=qK\u0002z\u0005\u000f^5p]\u0006dG.\u001f\u0011ta\u0016\u001c\u0017NZ=!C\u0002Z6\fV=qK\u0002\"\u0016\u0010]3^;\u00022wN\u001d\u0011uQ\u0016\u0004c/\u001a:uKbT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001aXmY8oI\u0006\u0014\u00180\u00138eKb\u0004s\n\u001d;j_:\fG\u000e\\=!gB,7-\u001b4zA\u0005\u00043/Z2p]\u0012\f'/\u001f\u0011j]\u0012,\u0007\u0010\t;iCR\u0004\u0013n\u001d\u0011vg\u0016$\u0007\u0005^8!I\u0016$XM]7j]\u0016\u0004C\u000f[3!_J$WM\u001d\u0011pM\u0002*\b\u000fZ1uKN\u0004s/\u001b;iAQDW\rI:b[\u0016\u0004\u0003-\u001e9eCR,G+[7fA*\u0001\u0003\u0005\t\u0011+_\u0005aA-\u001a7fi\u00164VM\u001d;fqR9!'a\u0012\u0002J\u0005-\u0003\"\u0002=\u000e\u0001\u00049\u0006\"\u0002>\u000e\u0001\u00049\u0006\u0002CA\u001e\u001bA\u0005\t\u0019A,)\u000f5\t)!!\u0007\u0002P\u0005\u0012\u0011\u0011K\u0001\u0003\u001c>R#\u0006I'be.\u001c\b%\u0019\u0011wKJ$X\r\u001f\u0011bg\u0002\"W\r\\3uK\u0012T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002*\b\u000fZ1uKRKW.\u001a\u0011uS6,\u0007e\u001c4!I\u0016dW\r^5p]\u0002B\u0013\r\t<feR,\u0007\u0010I5tA\r|gn]5eKJ,G\rI1tA9|\u0007\u0005\\8oO\u0016\u0014\b\u0005\u001d:fg\u0016tG\u000fI5oAQDW\rI4sCBD\u0007%\u00194uKJ\u0004C\u000f[5tAQLW.Z\u0015\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011te\u000eLE\rI%eA=4\u0007E^3si\u0016D\b\u0005^8!I\u0016dW\r^3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011tK\u000e|g\u000eZ1ss&sG-\u001a=!\u001fB$\u0018n\u001c8bY2L\be\u001d9fG&4\u0017\u0010I1!g\u0016\u001cwN\u001c3bef\u0004\u0013N\u001c3fq\u0002\"\b.\u0019;!SN\u0004So]3eAQ|\u0007\u0005Z3uKJl\u0017N\\3!i\",\u0007e\u001c:eKJ\u0004sN\u001a\u0011va\u0012\fG/Z:!o&$\b\u000e\t;iK\u0002\u001a\u0018-\\3!AV\u0004H-\u0019;f)&lW\r\u0019\u0006!A\u0001\u0002#fL\u0001\bC\u0012$W\tZ4f)5\u0011\u0014qKA-\u00037\ny&!\u0019\u0002f!)\u0001P\u0004a\u0001/\")!P\u0004a\u0001/\"1\u0011Q\f\bA\u0002]\u000bQ\u0001Z:u\u0013\u0012D\u0011\"a\n\u000f!\u0003\u0005\r!!\u000b\t\u0013\u0005\rd\u0002%AA\u0002\u0005M\u0012\u0001C3eO\u0016$\u0016\u0010]3\t\u0011\u0005mb\u0002%AA\u0002]CsADA\u0003\u00033\tI'\t\u0002\u0002l\u0005!yl\f\u0016+A\u0005#Gm\u001d\u0011bA9,w\u000fI3eO\u0016\u0004Co\u001c\u0011uQ\u0016\u0004sM]1qQ\u0002z'\u000fI;qI\u0006$Xm\u001d\u0011b]\u0002*\u00070[:uS:<\u0007%\u001a3hK*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!kB$\u0017\r^3US6,\u0007\u0005^5nKN$\u0018-\u001c9!M>\u0014\b%\u001a3hK\u0002*\b\u000fZ1uK*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAM\u00148-\u00133!A\u0001\u0002\u0003\u0005I%EA=4\u0007e]8ve\u000e,\u0007E^3si\u0016D\be\u001c4!i\",\u0007%\u001a3hK*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u0011\u001cH/\u00133!A\u0001\u0002\u0003\u0005I%EA=4\u0007\u0005Z3ti&t\u0017\r^5p]\u00022XM\u001d;fq\u0002zg\r\t;iK\u0002*GmZ3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011qe>\u0004XM\u001d;jKN\u0004S\rZ4fAA\u0014x\u000e]3si&,7\u000f\t4pe\u0002\"\b.\u001a\u0011va\u0012\fG/\u001a\u0011)g\u0016,\u0007eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:Jg\u000e];u]A\u0013x\u000e]3si&,7\u000f\t)s_B,'\u000f^5fgvk\u0006EZ8sAQDWM\u0003\u0011!A\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u00054\u0018-\u001b7bE2,\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011usB,7/\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI3eO\u0016$\u0016\u0010]3!A\u0001\u001a\b/Z2jMf\u0004\u0013\rI.\\)f\u0004X\r\t+za\u0016lV\f\t4pe\u0002\"\b.\u001a\u0011fI\u001e,'\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u00043/Z2p]\u0012\f'/_%oI\u0016D\be\u00149uS>t\u0017\r\u001c7zAM\u0004XmY5gs\u0002\n\u0007e]3d_:$\u0017M]=!S:$W\r\u001f\u0011uQ\u0006$\b%[:!kN,G\r\t;pA\u0011,G/\u001a:nS:,\u0007\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u0004S\u000f\u001d3bi\u0016\u001c\be^5uQ\u0002\"\b.\u001a\u0011tC6,\u0007\u0005Y;qI\u0006$X\rV5nK\u0002T\u0001\u0005\t\u0011!U=\"\u0012BMA8\u0003c\n\u0019(!\u001e\t\u000ba|\u0001\u0019A,\t\u000bi|\u0001\u0019A,\t\r\u0005us\u00021\u0001X\u0011\u0015ax\u00021\u0001~Q\u001dy\u0011QAA\r\u0003s\n#!a\u001f\u0002\u0005?z#F\u000b\u0011BI\u0012\u001c\b%\u0019\u0011oK^\u0004S\rZ4fAQ|\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!_J\u0004S\u000f\u001d3bi\u0016\u001c\b%\u00198!KbL7\u000f^5oO\u0002*GmZ3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI;qI\u0006$X\rV5nK\u0002\"\u0018.\\3ti\u0006l\u0007\u000f\t4pe\u0002*GmZ3!kB$\u0017\r^3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011te\u000eLE\r\t\u0011!A\u0001\u0002\u0013\n\u0012\u0011pM\u0002\u001ax.\u001e:dK\u00022XM\u001d;fq\u0002zg\r\t;iK\u0002*GmZ3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011egRLE\r\t\u0011!A\u0001\u0002\u0013\n\u0012\u0011pM\u0002\"Wm\u001d;j]\u0006$\u0018n\u001c8!m\u0016\u0014H/\u001a=!_\u001a\u0004C\u000f[3!K\u0012<WM\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005]8t)f\u0004X-\u0011:hA\u0001\u00023\u000f]3dS\u001aL\b%\u0019\u0011\\7RK\b/\u001a\u0011UsB,W,\u0018\u0011g_J\u0004C\u000f[3!K\u0012<WM\u0003\u0011!A\u0001Rs&\u0001\u0006eK2,G/Z#eO\u0016$\u0012BMAA\u0003\u0007\u000b))a\"\t\u000ba\u0004\u0002\u0019A,\t\u000bi\u0004\u0002\u0019A,\t\r\u0005u\u0003\u00031\u0001X\u0011!\tY\u0004\u0005I\u0001\u0002\u00049\u0006f\u0002\t\u0002\u0006\u0005e\u00111R\u0011\u0003\u0003\u001b\u000b11D\u0018+U\u0001j\u0015M]6!K\u0012<W\rI1tA\u0011,G.\u001a;fI*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAU\u0004H-\u0019;f)&lW\r\t;j[\u0016\u0004sN\u001a\u0011eK2,G/[8oA!\"\b.\u001a\u0011fI\u001e,\u0007%[:!G>t7/\u001b3fe\u0016$\u0007%Y:!]>\u0004Cn\u001c8hKJ\u0004\u0003O]3tK:$\b%\u001b8!i\",\u0007e\u001a:ba\"\u0004\u0013M\u001a;fe\u0002\"\b.[:!i&lW-\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI:sG&#\u0007%\u0013#!_\u001a\u00043o\\;sG\u0016\u0004c/\u001a:uKb\u0004sN\u001a\u0011uQ\u0016\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!IN$\u0018\n\u001a\u0011J\t\u0002zg\r\t;iK\u0002\"Wm\u001d;j]\u0006$\u0018n\u001c8!m\u0016\u0014H/\u001a=!_\u001a\u0004C\u000f[3!K\u0012<WM\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007e]3d_:$\u0017M]=J]\u0012,\u0007\u0010I(qi&|g.\u00197ms\u0002\u001a\b/Z2jMf\u0004\u0013\rI:fG>tG-\u0019:zA%tG-\u001a=!i\"\fG\u000fI5tAU\u001cX\r\u001a\u0011u_\u0002\"W\r^3s[&tW\r\t;iK\u0002z'\u000fZ3sA=4\u0007%\u001e9eCR,7\u000fI<ji\"\u0004C\u000f[3!g\u0006lW\r\t1va\u0012\fG/\u001a+j[\u0016\u0004'\u0002\t\u0011!A)z\u0013\u0001C1tg&<g.\u0013#\u0015\u0007]\u000b\u0019\n\u0003\u0004\u0002\u0016F\u0001\r\u0001X\u0001\fk:L\u0017/^3DQ\u0006\u00148\u000fK\u0004\u0012\u0003\u000b\tI\"!'\"\u0005\u0005m\u0015Aa\u00170U)\u00023i\u001c8wK:LWM\\2fA5,G\u000f[8eA\u0019|'\u000fI4f]\u0016\u0014\u0018\r^5oO\u0002*h.[9vK\u0002JEi\u001d\u0011cCN,G\rI8oAY,'\u000f^3yA9\fW.Z:\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006I+tK\u0002zg\r\t;iSN\u0004S.\u001a;i_\u0012\u0004\u0013n\u001d\u0011paRLwN\\1m]\u0001\n\u0005\u0005Y$sCBD')^5mI\u0016\u0014\b\rI5tA\u0019\u0014X-\u001a\u0011u_\u0002\n7o]5h]\u00022XM\u001d;fq\u0002JEi\u001d\u0011j]\u0002\"\u0017N\u001a4fe\u0016tG\u000fI<bsNd\u0003\u0005\u001d:pm&$W\r\u001a\u0006!A\u0001\u0002#\u0006\t;iCR\u0004S-Y2iAY,'\u000f^3yA%\u001c\b%Y:tS\u001etW\r\u001a\u0011bAUt\u0017.];fA%#\u0005e\u001c4!if\u0004X\r\t1M_:<\u0007M\f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001e8jcV,7\t[1sg\u00022VM\u001d;fq\u0002r\u0017-\\3\u000bA\u0001\u0002\u0003EK\u0018\u0002#\u001d,G\u000fU1si&$\u0018n\u001c8G_JLE\rF\u00028\u0003CCa!a)\u0013\u0001\u00049\u0016AA5e\u0003M\tG\r\u001a,feR,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tIK\u000b\u0003\u0002*\u0005-6FAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]F&\u0001\u0006b]:|G/\u0019;j_:LA!a/\u00022\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002'\u0005$GMV3si\u0016DH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0005'\u0006BA\u001a\u0003W\u000b1#\u00193e-\u0016\u0014H/\u001a=%I\u00164\u0017-\u001e7uIU*\"!a2+\u0007]\u000bY+\u0001\feK2,G/\u001a,feR,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003E\tG\rZ#eO\u0016$C-\u001a4bk2$H\u0005N\u0001\u0012C\u0012$W\tZ4fI\u0011,g-Y;mi\u0012*\u0014!E1eI\u0016#w-\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005!B-\u001a7fi\u0016,EmZ3%I\u00164\u0017-\u001e7uIQBs\u0001AA\u0003\u00033\t).\t\u0002\u0002X\u0006QYf\f\u0016+AQ\u0014\u0018-\u001b;!M>\u0014\be\u0019:fCRLgn\u001a\u0011bA\u001d\u0013\u0018\r\u001d5!Ef\u0004\u0013\r\u001a3j]\u001e\u0004\u0013M\u001c3!I\u0016dW\r^5oO\u00022XM\u001d;jG\u0016\u001c\b%\u00198eA\u0015$w-Z:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\ne\u000eI5na2,W.\u001a8uCRLwN\u001c\u0011pM\u0002\u0002wI]1qQ\n+\u0018\u000e\u001c3fe\u0002\u0004c.Z3eg\u0002\"x\u000eI8wKJ\u0014\u0018\u000eZ3!AB\f'o]3UkBdW\r\u000b;va2,'\b\t+*A\u0002\"x\u000e\t3fM&tW\r\t9beNLgn\u001a\u0011pM\u0002Jg\u000e];uA\u0011\fG/\u0019\u0018\u000bA\u0001R\u0003\u0005\u00165fA%t\u0007/\u001e;!I\u0006$\u0018\rI5tA\u001d,g.\u001a:bi\u0016$\u0007%^:j]\u001e\u0004\u0013\rI.\\G>lgF]1qQR|'/\u001f\u0018ba&t\u0013N\u001c9vi:\u001a\u0006o\\;uAM\u0003x.\u001e;^;\u0002\ng\u000e\u001a\u0011qCN\u001cX\r\u001a\u0011u_\u0002\"\b.\u001a\u0006!A)\u0002\u0003\r]1sg\u0016$V\u000f\u001d7fA\u0002jW\r\u001e5pI\u0002:\b.[2iA%\u001c\bE]3ta>t7/\u001b2mK\u00022wN\u001d\u0011ukJt\u0017N\\4!i\",\u0007E]1xA\u0011\fG/\u0019\u0011j]R|\u0007%\u0019\u0011mSN$\be\u001c4!OJ\f\u0007\u000f\u001b\u0011va\u0012\fG/Z:/A%s7/\u001b3fAQDWM\u0003\u0011!U\u0001\u0002\u0007/\u0019:tKR+\b\u000f\\3aA%l\u0007\u000f\\3nK:$\u0018\r^5p]2\u0002So]3![\u0016$\bn\u001c3tA\u0001\fG\r\u001a,feR,\u0007\u0010Y\u0018aI\u0016dW\r^3WKJ$X\r\u001f1!C:$\u0007\u0005Y1eI\u0016#w-\u001a10A\u0012,G.\u001a;f\u000b\u0012<W\r\u0019\u0006!A)\u0002cm\u001c:!C\u0012$\u0017N\\40I\u0016dW\r^5oO\u00022XM\u001d;jG\u0016\u001c\b%\u00198eA\u0015$w-Z:/AQCW\r\t:fgVdG/\u001b8hA\u001d\u0014\u0018\r\u001d5!kB$\u0017\r^3tA\u0005\u0014X\rI:f]\u0012\u0004Co\u001c\u0011uQ\u0016\u0004\u0003/\u0019:uSRLwN\\:!e\u0016\u001c\bo\u001c8tS\ndW\r\t4pe*\u0001\u0003E\u000b\u0011iC:$G.\u001b8hAQDW\r\t<feRL7-Z:!C:$\u0007%\u001a3hKNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t!fq\u0006l\u0007\u000f\\3\u000bA\u0001R\u0003e_>|\u0015\u0001\u0002#\u0006I2mCN\u001c\b\u0005V<jiR,'o\u0012:ba\"\u0014U/\u001b7eKJD\u0013\u0006I3yi\u0016tGm\u001d\u0011He\u0006\u0004\bNQ;jY\u0012,'oW*ue&tw-\u0018\u0011|\u0015\u0001\u0002#\u0006\t\u0011!_Z,'O]5eK\u0002\"WM\u001a\u0011qCJ\u001cX\rV;qY\u0016Dc-\u001b7f\u0019&tWM\u000f\u0011TiJLgnZ\u0015;AUs\u0017\u000e\u001e\u0011>AmT\u0001\u0005\t\u0016!A\u0001\u0002\u0003E^1mAM|WO]2f\u001d>$W\rI\u001f!M&dW\rT5oK\"\u0002\u0014F\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011wC2\u00043O]2J\t\u0002\u0002\u0003\u0005\t\u0011!{\u0001\u001ax.\u001e:dK:{G-\u001a\u0018u_2{gn\u001a\u0006!A)\u0002\u0003\u0005\t\u0011!m\u0006d\u0007\u0005^1sO\u0016$hj\u001c3fAu\u0002c-\u001b7f\u0019&tW\rK\u0019*\u0015\u0001\u0002#\u0006\t\u0011!A\u00012\u0018\r\u001c\u0011uCJLE\t\t\u0011!A\u0001\u0002S\b\t;be\u001e,GOT8eK:\"x\u000eT8oO*\u0001\u0003E\u000b\u0011!A\u0001\u0002c/\u00197!i&lWm\u0015;b[B\u0004\u0003%\u0010\u0011gS2,G*\u001b8fQIJc\u0006^8M_:<'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\nG\r\u001a,feR,\u0007\u0010\u000b;j[\u0016\u001cF/Y7qY\u0001\u001a(oY%EY\u0001\u0002&o\u001c9feRLWm\u001d\u0015J[6,H/\u00192mKB\u0013x\u000e]3sifD#E\\1nK\nb\u0003e]8ve\u000e,gj\u001c3fS%b\u0003\u0005V=qK\"\u0012Sk]3sE%J#\u0002\t\u0011+A\u0001\u0002\u0003\u0005I1eIZ+'\u000f^3yQQLW.Z*uC6\u0004H\u0006\t;be&#E\u0006\t)s_B,'\u000f^5fg\"JU.\\;uC\ndW\r\u0015:pa\u0016\u0014H/\u001f\u0015#]\u0006lWM\t\u0017!i\u0006\u0014x-\u001a;O_\u0012,\u0017&\u000b\u0017!)f\u0004X\r\u000b\u0012Vg\u0016\u0014(%K\u0015\u000bA\u0001R\u0003\u0005\t\u0011!A\u0005$G-\u00123hK\"\"\u0018.\\3Ti\u0006l\u0007\u000f\f\u0011te\u000eLE\t\f\u0011uCJLE\t\f\u0011UsB,\u0007F\t$pY2|wo\u001d\u0012*S)\u0001\u0003E\u000b\u0011!AuT\u0001\u0005\t\u0016!{*\u0001\u0003E\u000b\u0011~{vT\u0001\u0005\t\u0016!\u0001N,W\rI.\\!J|\u0007/\u001a:uS\u0016\u001cX,\u0018\u0011\\7N\u0003x.\u001e;^;*\u0001\u0003EK\u0018\u0002\u000b\u001d\u0013\u0018\r\u001d5\u0011\u0005yd2C\u0001\u000f+\u0003\u0019a\u0014N\\5u}Q\u0011\u00111\u001c\u000b\u0004/\u0006\u0015\bBBAK=\u0001\u0007A\fK\u0004\u001f\u0003\u000b\tI\"!'")
public interface Graph {
    public int totalPartitions();

    public void handleGraphUpdate(GraphAlteration.GraphUpdate var1);

    public int sourceID();

    public long index();

    public String graphID();

    private Counter.Child vertexAddCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.vertexAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    private Counter.Child vertexDeleteCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.vertexDeleteCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    private Counter.Child edgeAddCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.edgeAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    private Counter.Child edgeDeleteCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.edgeDeleteCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Type posTypeArg) {
        $this.addVertex(updateTime, srcId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    default public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        Type x$3 = posTypeArg;
        Properties x$4 = this.addVertex$default$3();
        long x$5 = this.addVertex$default$5();
        this.addVertex(x$1, x$2, x$4, x$3, x$5);
    }

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        $this.addVertex(updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        GraphAlteration.VertexAdd update = new GraphAlteration.VertexAdd(this.sourceID(), updateTime, secondaryIndex, srcId, properties, vertexType.toOption(), SchemaProviderInstances$.MODULE$.vertexAddSchemaProvider());
        this.handleGraphUpdate(update);
        this.vertexAddCounter().inc();
    }

    public static /* synthetic */ Properties addVertex$default$3$(Graph $this) {
        return $this.addVertex$default$3();
    }

    default public Properties addVertex$default$3() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addVertex$default$4$(Graph $this) {
        return $this.addVertex$default$4();
    }

    default public MaybeType addVertex$default$4() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addVertex$default$5$(Graph $this) {
        return $this.addVertex$default$5();
    }

    default public long addVertex$default$5() {
        return this.index();
    }

    public static /* synthetic */ void deleteVertex$(Graph $this, long updateTime, long srcId, long secondaryIndex) {
        $this.deleteVertex(updateTime, srcId, secondaryIndex);
    }

    @Scaladoc(value="/** Marks a vertex as deleted\n    * @param updateTime time of deletion (a vertex is considered as no longer present in the graph after this time)\n    * @param srcId Id of vertex to delete\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void deleteVertex(long updateTime, long srcId, long secondaryIndex) {
        this.handleGraphUpdate(new GraphAlteration.VertexDelete(this.sourceID(), updateTime, secondaryIndex, srcId, SchemaProviderInstances$.MODULE$.vertexDeleteSchemaProvider()));
        this.vertexDeleteCounter().inc();
    }

    public static /* synthetic */ long deleteVertex$default$3$(Graph $this) {
        return $this.deleteVertex$default$3();
    }

    default public long deleteVertex$default$3() {
        return this.index();
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        $this.addEdge(updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        GraphAlteration.EdgeAdd update = new GraphAlteration.EdgeAdd(this.sourceID(), updateTime, secondaryIndex, srcId, dstId, properties, edgeType.toOption(), SchemaProviderInstances$.MODULE$.edgeAddSchemaProvider());
        this.handleGraphUpdate(update);
        this.edgeAddCounter().inc();
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Type posTypeArg) {
        $this.addEdge(updateTime, srcId, dstId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        long x$3 = dstId;
        Type x$4 = posTypeArg;
        Properties x$5 = this.addEdge$default$4();
        long x$6 = this.addEdge$default$6();
        this.addEdge(x$1, x$2, x$3, x$5, x$4, x$6);
    }

    public static /* synthetic */ Properties addEdge$default$4$(Graph $this) {
        return $this.addEdge$default$4();
    }

    default public Properties addEdge$default$4() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addEdge$default$5$(Graph $this) {
        return $this.addEdge$default$5();
    }

    default public MaybeType addEdge$default$5() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addEdge$default$6$(Graph $this) {
        return $this.addEdge$default$6();
    }

    default public long addEdge$default$6() {
        return this.index();
    }

    public static /* synthetic */ void deleteEdge$(Graph $this, long updateTime, long srcId, long dstId, long secondaryIndex) {
        $this.deleteEdge(updateTime, srcId, dstId, secondaryIndex);
    }

    @Scaladoc(value="/** Mark edge as deleted\n    * @param updateTime time of deletion (the edge is considered as no longer present in the graph after this time)\n    * @param srcId ID of source vertex of the edge\n    * @param dstId ID of the destination vertex of the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void deleteEdge(long updateTime, long srcId, long dstId, long secondaryIndex) {
        this.handleGraphUpdate(new GraphAlteration.EdgeDelete(this.sourceID(), updateTime, this.index(), srcId, dstId, SchemaProviderInstances$.MODULE$.edgeDeleteSchemaProvider()));
        this.edgeDeleteCounter().inc();
    }

    public static /* synthetic */ long deleteEdge$default$4$(Graph $this) {
        return $this.deleteEdge$default$4();
    }

    default public long deleteEdge$default$4() {
        return this.index();
    }

    public static /* synthetic */ long assignID$(Graph $this, String uniqueChars) {
        return $this.assignID(uniqueChars);
    }

    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    default public long assignID(String uniqueChars) {
        return Graph$.MODULE$.assignID(uniqueChars);
    }

    public static /* synthetic */ int getPartitionForId$(Graph $this, long id) {
        return $this.getPartitionForId(id);
    }

    default public int getPartitionForId(long id) {
        return (int)(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(id)) % (long)this.totalPartitions());
    }

    public static void $init$(Graph $this) {
    }
}

