/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.visitor;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.utils.Reduction$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/** Collection of pre-defined merge strategies.\n  *\n  * A merge strategy is a function that takes a collection of timestamped property values and returns a single value.\n  * Merge strategies are used to control the aggregation semantics for property access in\n  * [[EntityVisitor]].\n  *\n  * The general signature for a merge strategy is `Iterable[PropertyValue[A]] => B`.\n  * @see [[EntityVisitor]]\n  *      [[Edge]]\n  *      [[Vertex]]\n  */")
public final class PropertyMergeStrategy$ {
    public static final PropertyMergeStrategy$ MODULE$ = new PropertyMergeStrategy$();

    @Scaladoc(value="/** Merge strategy that sums the property values */")
    public <T> Function1<Iterable<PropertyValue<T>>, T> sum(Numeric<T> evidence$1) {
        return (Function1 & Serializable)history -> ((IterableOnceOps)history.map((Function1 & Serializable)x$1 -> x$1.value())).sum(evidence$1);
    }

    @Scaladoc(value="/** Merge strategy that returns the maximum property value */")
    public <T> Function1<Iterable<PropertyValue<T>>, T> max(Numeric<T> evidence$2) {
        return (Function1 & Serializable)history -> ((IterableOnceOps)history.map((Function1 & Serializable)x$2 -> x$2.value())).max((Ordering)evidence$2);
    }

    @Scaladoc(value="/** Merge strategy that returns the minimum property value */")
    public <T> Function1<Iterable<PropertyValue<T>>, T> min(Numeric<T> evidence$3) {
        return (Function1 & Serializable)history -> ((IterableOnceOps)history.map((Function1 & Serializable)x$3 -> x$3.value())).min((Ordering)evidence$3);
    }

    @Scaladoc(value="/** Merge strategy that returns the product of property values */")
    public <T> Function1<Iterable<PropertyValue<T>>, T> product(Numeric<T> evidence$4) {
        return (Function1 & Serializable)history -> ((IterableOnceOps)history.map((Function1 & Serializable)x$4 -> x$4.value())).product(evidence$4);
    }

    @Scaladoc(value="/** Merge strategy that returns the average of property values */")
    public <T> Function1<Iterable<PropertyValue<T>>, Object> average(Numeric<T> evidence$5) {
        return (Function1 & Serializable)history -> BoxesRunTime.boxToDouble((double)PropertyMergeStrategy$.$anonfun$average$1(evidence$5, history));
    }

    @Scaladoc(value="/** Merge strategy that returns the latest property value (i.e. the value corresponding to the largest timestamp)\n    * This is the default merge strategy for property access in Raphtory.\n    */")
    public <T> Function1<Iterable<PropertyValue<T>>, T> latest() {
        return (Function1 & Serializable)history -> ((PropertyValue)history.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).value();
    }

    @Scaladoc(value="/** Merge startegy that returns the earliest property value (i.e., the value corresponding to the smallest timestamp) */")
    public <T> Function1<Iterable<PropertyValue<T>>, T> earliest() {
        return (Function1 & Serializable)history -> ((PropertyValue)history.min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).value();
    }

    @Scaladoc(value="/** Return the sequence of property values */")
    public <T> Function1<Iterable<PropertyValue<T>>, Iterable<T>> sequence() {
        return (Function1 & Serializable)history -> (Iterable)history.map((Function1 & Serializable)x$6 -> x$6.value());
    }

    public static final /* synthetic */ double $anonfun$average$1(Numeric evidence$5$1, Iterable history) {
        return Reduction$.MODULE$.IterableWithAvg((Iterable)history.map((Function1 & Serializable)x$5 -> x$5.value()), evidence$5$1).mean();
    }

    private PropertyMergeStrategy$() {
    }
}

