/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.visitor;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.HistoricEvent$;
import com.raphtory.api.analysis.visitor.IndexedValue;
import com.raphtory.api.analysis.visitor.TimePoint;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** Case class for encoding additions and deletions\n  *\n  * This class is returned by the history access methods of [[EntityVisitor]].\n  *\n  * @param time Timestamp of event\n  *\n  * @param event `true` if event is an addition or `false` if event is a deletion\n  *\n  * @see [[EntityVisitor]], [[Vertex]], [[Edge]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\u0010!\u0001.B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u0003q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B(\t\u000bM\u0003A\u0011\u0001+\t\u000be\u0003A\u0011\t.\t\u000fu\u0003\u0011\u0011!C\u0001=\"9!\rAI\u0001\n\u0003\u0019\u0007b\u00028\u0001#\u0003%\ta\u0019\u0005\b_\u0002\t\n\u0011\"\u0001q\u0011\u001d\u0011\b!!A\u0005BMDq\u0001 \u0001\u0002\u0002\u0013\u0005Q\u0010C\u0005\u0002\u0004\u0001\t\t\u0011\"\u0001\u0002\u0006!I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00131\u0003\u0005\n\u0003C\u0001\u0011\u0011!C\u0001\u0003GA\u0011\"a\n\u0001\u0003\u0003%\t%!\u000b\t\u0013\u00055\u0002!!A\u0005B\u0005=\u0002\"CA\u0019\u0001\u0005\u0005I\u0011IA\u001a\u0011%\t)\u0004AA\u0001\n\u0003\n9dB\u0005\u0002X\u0001\n\t\u0011#\u0001\u0002Z\u0019Aq\u0004IA\u0001\u0012\u0003\tY\u0006\u0003\u0004T/\u0011\u0005\u00111\u000f\u0005\n\u0003c9\u0012\u0011!C#\u0003gA\u0011\"!\u001e\u0018\u0003\u0003%\t)a\u001e\t\u0011\u0005}t#%A\u0005\u0002AD\u0011\"!!\u0018\u0003\u0003%\t)a!\t\u0011\u0005Uu#%A\u0005\u0002AD\u0011\"a&\u0018\u0003\u0003%I!!'\u0003\u001b!K7\u000f^8sS\u000e,e/\u001a8u\u0015\t\t#%A\u0004wSNLGo\u001c:\u000b\u0005\r\"\u0013\u0001C1oC2L8/[:\u000b\u0005\u00152\u0013aA1qS*\u0011q\u0005K\u0001\te\u0006\u0004\b\u000e^8ss*\t\u0011&A\u0002d_6\u001c\u0001aE\u0003\u0001YI2\u0014\b\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VM\u001a\t\u0003gQj\u0011\u0001I\u0005\u0003k\u0001\u0012A\"\u00138eKb,GMV1mk\u0016\u0004\"!L\u001c\n\u0005ar#a\u0002)s_\u0012,8\r\u001e\t\u0003u\ts!a\u000f!\u000f\u0005qzT\"A\u001f\u000b\u0005yR\u0013A\u0002\u001fs_>$h(C\u00010\u0013\t\te&A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%\u0001D*fe&\fG.\u001b>bE2,'BA!/\u0003\u0011!\u0018.\\3\u0016\u0003\u001d\u0003\"!\f%\n\u0005%s#\u0001\u0002'p]\u001e\fQ\u0001^5nK\u0002\nQ!\u001b8eKb\fa!\u001b8eKb\u0004\u0013!B3wK:$X#A(\u0011\u00055\u0002\u0016BA)/\u0005\u001d\u0011un\u001c7fC:\fa!\u001a<f]R\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003V-^C\u0006CA\u001a\u0001\u0011\u0015)u\u00011\u0001H\u0011\u0015Yu\u00011\u0001H\u0011\u001diu\u0001%AA\u0002=\u000b\u0011b]1nKZ\u000bG.^3\u0015\u0005=[\u0006\"\u0002/\t\u0001\u0004\u0011\u0014\u0001\u0002;iCR\fAaY8qsR!Qk\u00181b\u0011\u001d)\u0015\u0002%AA\u0002\u001dCqaS\u0005\u0011\u0002\u0003\u0007q\tC\u0004N\u0013A\u0005\t\u0019A(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAM\u000b\u0002HK.\na\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003W:\n!\"\u00198o_R\fG/[8o\u0013\ti\u0007NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003ET#aT3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u0011a\u0017M\\4\u000b\u0003e\fAA[1wC&\u00111P\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003y\u0004\"!L@\n\u0007\u0005\u0005aFA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\b\u00055\u0001cA\u0017\u0002\n%\u0019\u00111\u0002\u0018\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0010=\t\t\u00111\u0001\u007f\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0003\t\u0007\u0003/\ti\"a\u0002\u000e\u0005\u0005e!bAA\u000e]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0011\u0011\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002P\u0003KA\u0011\"a\u0004\u0012\u0003\u0003\u0005\r!a\u0002\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004i\u0006-\u0002\u0002CA\b%\u0005\u0005\t\u0019\u0001@\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012A`\u0001\ti>\u001cFO]5oOR\tA/\u0001\u0004fcV\fGn\u001d\u000b\u0004\u001f\u0006e\u0002\"CA\b+\u0005\u0005\t\u0019AA\u0004Q\u001d\u0001\u0011QHA)\u0003'\u0002B!a\u0010\u0002N5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\t9%!\u0013\u0002\u000fQ\f7.\u001a>pK*\u0019\u00111\n\u0015\u0002\r\u001dLG\u000f[;c\u0013\u0011\ty%!\u0011\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!!\u0016\u0002\u0005wz#F\u000b\u0011DCN,\u0007e\u00197bgN\u0004cm\u001c:!K:\u001cw\u000eZ5oO\u0002\nG\rZ5uS>t7\u000fI1oI\u0002\"W\r\\3uS>t7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ&\u001c\be\u00197bgN\u0004\u0013n\u001d\u0011sKR,(O\\3eA\tL\b\u0005\u001e5fA!L7\u000f^8ss\u0002\n7mY3tg\u0002jW\r\u001e5pIN\u0004sN\u001a\u0011\\7\u0016sG/\u001b;z-&\u001c\u0018\u000e^8s;vs#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t;j[\u0016\u0004C+[7fgR\fW\u000e\u001d\u0011pM\u0002*g/\u001a8u\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002*g/\u001a8uA\u0001$(/^3aA%4\u0007%\u001a<f]R\u0004\u0013n\u001d\u0011b]\u0002\nG\rZ5uS>t\u0007e\u001c:!A\u001a\fGn]3aA%4\u0007%\u001a<f]R\u0004\u0013n\u001d\u0011bA\u0011,G.\u001a;j_:T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005Q:fK\u0002Z6,\u00128uSRLh+[:ji>\u0014X,\u0018\u0017!7n3VM\u001d;fqvkF\u0006I.\\\u000b\u0012<W-X/\u000bA\u0001Rs&A\u0007ISN$xN]5d\u000bZ,g\u000e\u001e\t\u0003g]\u0019RaFA/\u0003S\u0002\u0002\"a\u0018\u0002f\u001d;u*V\u0007\u0003\u0003CR1!a\u0019/\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001a\u0002b\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001cy\u0003\tIw.C\u0002D\u0003[\"\"!!\u0017\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fU\u000bI(a\u001f\u0002~!)QI\u0007a\u0001\u000f\")1J\u0007a\u0001\u000f\"9QJ\u0007I\u0001\u0002\u0004y\u0015aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011QQAI!\u0015i\u0013qQAF\u0013\r\tII\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r5\niiR$P\u0013\r\tyI\f\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005ME$!AA\u0002U\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u0014\t\u0004k\u0006u\u0015bAAPm\n1qJ\u00196fGR\u0004")
public class HistoricEvent
implements IndexedValue,
Product,
Serializable {
    private final long time;
    private final long index;
    private final boolean event;

    public static boolean $lessinit$greater$default$3() {
        return HistoricEvent$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Object, Object, Object>> unapply(HistoricEvent x$0) {
        return HistoricEvent$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$3() {
        return HistoricEvent$.MODULE$.apply$default$3();
    }

    public static HistoricEvent apply(long time, long index, boolean event) {
        return HistoricEvent$.MODULE$.apply(time, index, event);
    }

    public static Function1<Tuple3<Object, Object, Object>, HistoricEvent> tupled() {
        return HistoricEvent$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<Object, Function1<Object, HistoricEvent>>> curried() {
        return HistoricEvent$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public TimePoint next() {
        return IndexedValue.next$(this);
    }

    @Override
    public TimePoint previous() {
        return IndexedValue.previous$(this);
    }

    @Override
    public int compare(IndexedValue that) {
        return IndexedValue.compare$(this, that);
    }

    public boolean $less(Object that) {
        return Ordered.$less$((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.$greater$((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.compareTo$((Ordered)this, (Object)that);
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public long index() {
        return this.index;
    }

    public boolean event() {
        return this.event;
    }

    @Override
    public boolean sameValue(IndexedValue that) {
        boolean bl;
        IndexedValue indexedValue = that;
        if (indexedValue instanceof HistoricEvent) {
            HistoricEvent historicEvent = (HistoricEvent)indexedValue;
            long otime = historicEvent.time();
            boolean oevent = historicEvent.event();
            bl = otime == this.time() && oevent == this.event();
        } else {
            bl = false;
        }
        return bl;
    }

    public HistoricEvent copy(long time, long index, boolean event) {
        return new HistoricEvent(time, index, event);
    }

    public long copy$default$1() {
        return this.time();
    }

    public long copy$default$2() {
        return this.index();
    }

    public boolean copy$default$3() {
        return this.event();
    }

    public String productPrefix() {
        return "HistoricEvent";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToLong((long)this.time());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.index());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.event());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HistoricEvent;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "time";
                break;
            }
            case 1: {
                string = "index";
                break;
            }
            case 2: {
                string = "event";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.time()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.index()));
        n = Statics.mix((int)n, (int)(this.event() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HistoricEvent)) return false;
        boolean bl = true;
        if (!bl) return false;
        HistoricEvent historicEvent = (HistoricEvent)x$1;
        if (this.time() != historicEvent.time()) return false;
        if (this.index() != historicEvent.index()) return false;
        if (this.event() != historicEvent.event()) return false;
        if (!historicEvent.canEqual(this)) return false;
        return true;
    }

    public HistoricEvent(long time, long index, boolean event) {
        this.time = time;
        this.index = index;
        this.event = event;
        Ordered.$init$((Ordered)this);
        IndexedValue.$init$(this);
        Product.$init$((Product)this);
    }
}

