/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.visitor;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.PropertyMergeStrategy$;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.utils.ExtendedNumeric$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/** Extends [[EntityVisitor]] with edge-specific functionality\n  *\n  * The [[Edge]] class exposes the algorithm interface for accessing edge history and properties.\n  *\n  * @see\n  * [[ExplodedEdge]]\n  * [[PropertyMergeStrategy]]\n  * [[EntityVisitor]]\n  * [[Vertex]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015ha\u0002\n\u0014!\u0003\r\tA\b\u0005\u0006G\u0001!\t\u0001\n\u0003\u0006W\u0001\u0011\t\u0001\f\u0005\u0006g\u00011\t\u0001\u000e\u0005\u0006\u000b\u00021\t\u0001\u000e\u0005\u0006\u0013\u00021\t\u0001\u000e\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006+\u0002!\tA\u0014\u0005\u00063\u00021\t\u0001\n\u0005\u0006;\u0002!\tA\u0018\u0005\u0007;\u0002!\t!!\u0002\t\ru\u0003A\u0011AA\u001b\u0011\u0019i\u0006\u0001\"\u0001\u0002T!1Q\f\u0001C\u0001\u0003[Ba!\u0018\u0001\u0005\u0002\u0005\u0015\u0005BB/\u0001\t\u0003\ti\nC\u0004\u00024\u00021\t!!.\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\r'\u0001B#eO\u0016T!\u0001F\u000b\u0002\u000fYL7/\u001b;pe*\u0011acF\u0001\tC:\fG._:jg*\u0011\u0001$G\u0001\u0004CBL'B\u0001\u000e\u001c\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011\"\u001b\u0005\u0019\u0012B\u0001\u0012\u0014\u00055)e\u000e^5usZK7/\u001b;pe\u00061A%\u001b8ji\u0012\"\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0005+:LGO\u0001\u0004J\tRK\b/Z\t\u0003[A\u0002\"A\n\u0018\n\u0005=:#a\u0002(pi\"Lgn\u001a\t\u0003MEJ!AM\u0014\u0003\u0007\u0005s\u00170\u0001\u0002J\tV\tQ\u0007\u0005\u00027\u00055\t\u0001\u0001\u000b\u0003\u0004q\t\u001b\u0005CA\u001dA\u001b\u0005Q$BA\u001e=\u0003!\u00198-\u00197bI>\u001c'BA\u001f?\u0003\u001d!\u0018m[3{_\u0016T!aP\u000e\u0002\r\u001dLG\u000f[;c\u0013\t\t%H\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005!\u0015AD\u0018+U\u0001*EmZ3!\u0013\u0012\u0003#fL\u0001\u0004gJ\u001c\u0007\u0006\u0002\u00039\u0005\u001e\u000b\u0013\u0001S\u0001+_)R\u0003%\u0013#!_\u001a\u0004C\u000f[3!g>,(oY3!m\u0016\u0014H/\u001a=!_\u001a\u0004C\u000f[3!K\u0012<W\r\t\u00160\u0003\r!7\u000f\u001e\u0015\u0005\u000ba\u00125*I\u0001M\u0003=z#F\u000b\u0011J\t\u0002zg\r\t;iK\u0002\"Wm\u001d;j]\u0006$\u0018n\u001c8!m\u0016\u0014H/\u001a=!_\u001a\u0004C\u000f[3!K\u0012<W\r\t\u00160\u0003)I7oT;uO>LgnZ\u000b\u0002\u001fB\u0011a\u0005U\u0005\u0003#\u001e\u0012qAQ8pY\u0016\fg\u000e\u000b\u0003\u0007q\t\u001b\u0016%\u0001+\u0002Q=R#\u0006\t1ueV,\u0007\rI5gAQDW\rI3eO\u0016\u0004\u0013n\u001d\u0011b]\u0002zW\u000f^\u0017fI\u001e,\u0007EK\u0018\u0002\u0015%\u001c\u0018J\\2p[&tw\r\u000b\u0003\bq\t;\u0016%\u0001-\u0002O=R#\u0006\t1ueV,\u0007\rI5gAQDW\rI3eO\u0016\u0004\u0013n\u001d\u0011b]\u0002Jg.L3eO\u0016\u0004#fL\u0001\u0007e\u0016lwN^3)\t!A$iW\u0011\u00029\u0006\u0019tF\u000b\u0016!\r&dG/\u001a:!i\",\u0007%\u001a3hK\u00022'o\\7!i\",\u0007\u0005Y$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<fA:\u0002#fL\u0001\u0007o\u0016Lw\r\u001b;\u0016\u0007}[(\r\u0006\u0003aIFl\bCA1c\u0019\u0001!QaY\u0005C\u00021\u0012\u0011A\u0011\u0005\bK&\u0001\n\u00111\u0001g\u000399X-[4iiB\u0013x\u000e]3sif\u0004\"a\u001a8\u000f\u0005!d\u0007CA5(\u001b\u0005Q'BA6\u001e\u0003\u0019a$o\\8u}%\u0011QnJ\u0001\u0007!J,G-\u001a4\n\u0005=\u0004(AB*ue&twM\u0003\u0002nO!)!/\u0003a\u0001g\u0006iQ.\u001a:hKN#(/\u0019;fOf\u0004B\u0001^<{A:\u0011\u0001%^\u0005\u0003mN\tQ\u0003\u0015:pa\u0016\u0014H/_'fe\u001e,7\u000b\u001e:bi\u0016<\u00170\u0003\u0002ys\ni\u0001K]8qKJ$\u00180T3sO\u0016T!A^\n\u0011\u0005\u0005\\H!\u0002?\n\u0005\u0004a#!A!\t\u000byL\u0001\u0019\u0001>\u0002\u000f\u0011,g-Y;mi\"*\u0011\u0002\u000f\"\u0002\u0002\u0005\u0012\u00111A\u0001\t\u0000>R#\u0006I\"p[B,H/\u001a\u0011uQ\u0016\u0004s/Z5hQR\u0004sN\u001a\u0011uQ\u0016\u0004S\rZ4fAU\u001c\u0018N\\4!C\u0002\u001aWo\u001d;p[\u0002jWM]4fAM$(/\u0019;fOfT\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001#\b/\u0019:b[\u0002\n\u0005E^1mk\u0016\u0004C/\u001f9fA\u0019|'\u000f\t;iK\u0002*GmZ3!o\u0016Lw\r\u001b;!aJ|\u0007/\u001a:us\u0002B\u0013N\u001a\u0011a[\u0016\u0014x-Z*ue\u0006$XmZ=aA%\u001c\bE\\8uA\u001dLg/\u001a8-AQD\u0017n\u001d\u0011oK\u0016$7\u000f\t;pA\t,\u0007%\u0019\u0011ok6,'/[2!if\u0004X-\u000b\u0006!A\u0001\u0002#\u0006\t!ua\u0006\u0014\u0018-\u001c\u0011CAI,G/\u001e:oAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011nKJ<W\rI:ue\u0006$XmZ=!Q=tG.\u001f\u0011ta\u0016\u001c\u0017NZ=!S\u001a\u0004So]5oO\u0002\n\u0007eY;ti>l\u0007%\\3sO\u0016\u00043\u000f\u001e:bi\u0016<\u00170\u000b\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007e^3jO\"$\bK]8qKJ$\u0018\u0010\t\u0011fI\u001e,\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011u_\u0002*8/\u001a\u0011g_J\u00043m\\7qkRLgn\u001a\u0011fI\u001e,\u0007e^3jO\"$(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004S.\u001a:hKN#(/\u0019;fOf\u0004S.\u001a:hK\u0002\u001aHO]1uK\u001eL\b\u0005^8!kN,\u0007EZ8sA\r|gN^3si&tw\r\t9s_B,'\u000f^=!Q&\u001cHo\u001c:zAQ|\u0007%\u001a3hK\u0002:X-[4ii*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A!\u001aX-\u001a\u0011\\7B\u0013x\u000e]3siflUM]4f'R\u0014\u0018\r^3hsvk\u0006EZ8sAA\u0014X\rZ3gS:,G\rI8qi&|gn\u001d\u0011pe\u0002\u0002(o\u001c<jI\u0016\u00043-^:u_6\u0004c-\u001e8di&|g.\u000b\u0018!\u0005f\u0004C-\u001a4bk2$\b\u0005\u001e5jg\u0002\u0012X\r^;s]N\u0004C\u000f[3\u000bA\u0001\u0002\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011tk6\u0004sN\u001a\u0011qe>\u0004XM\u001d;zAY\fG.^3t])\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u0011,g-Y;mi\u0002\"WMZ1vYR\u0004c/\u00197vK\u00022wN\u001d\u0011uQ\u0016\u0004s/Z5hQR\u0004\u0003O]8qKJ$\u0018\u0010\t2fM>\u0014X\rI1qa2L\u0018N\\4!i\",\u0007%\\3sO\u0016\u00043\u000f\u001e:bi\u0016<\u0017P\f\u0006!A\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ&\u001c\b\u0005Z3gCVdGo\u001d\u0011u_\u0002\u0002\u0017\u0007\u0019\u0011jM\u0002\u0002\u0017\t\u0019\u0011jg\u0002\n\u0007E\\;nKJL7\r\t;za\u0016t\u0003\u0005\u00165jg\u0002\"WMZ1vYR\u0004c/\u00197vK\u0002J7\u000fI1qa2LW\r\u001a\u0011cK\u001a|'/\u001a\u0011baBd\u00170\u001b8hAQDWM\u0003\u0011!A\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I7fe\u001e,\u0007e\u001d;sCR,w-\u001f\u0018!\u0013:\u0004C\u000f[3!G\u0006\u001cX\rI<iKJ,G\u0006I3/O:b\u0003\u0005Y7fe\u001e,7\u000b\u001e:bi\u0016<\u0017\u0010I\u001f!AA\u0013x\u000e]3siflUM]4f'R\u0014\u0018\r^3hs:\u001aX/\\.B;\u0002d\u0003\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\r|W\u000e];uK\u0012\u0004s/Z5hQR\u0004\u0013n\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011uS6,7\u000f\t;iK\u0002*GmZ3!o\u0006\u001c\b%Y2uSZ,\u0007%\u001b8!i\",\u0007eY;se\u0016tG\u000f\t<jK^\u0004\u0013N\u001a\u0011uQ\u0016\u0004s/Z5hQRT\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003O]8qKJ$\u0018\u0010I5tA9|G\u000f\t4pk:$gF\u0003\u0011!A\u0001Rs&\u0006\u0004\u0002\b\u0005\u001d\u0012Q\u0002\u000b\u0007\u0003\u0013\tI#a\u000b\u0015\t\u0005-\u0011q\u0002\t\u0004C\u00065A!B2\u000b\u0005\u0004a\u0003\"CA\t\u0015\u0005\u0005\t9AA\n\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003+\ty\"!\n\u000f\t\u0005]\u00111\u0004\b\u0004S\u0006e\u0011\"\u0001\u0015\n\u0007\u0005uq%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00121\u0005\u0002\b\u001dVlWM]5d\u0015\r\tib\n\t\u0004C\u0006\u001dB!\u0002?\u000b\u0005\u0004a\u0003\"B3\u000b\u0001\u00041\u0007B\u0002:\u000b\u0001\u0004\ti\u0003\u0005\u0004uo\u0006\u0015\u00121\u0002\u0015\u0006\u0015a\u0012\u0015\u0011G\u0011\u0003\u0003g\tQ\u0011G\u0018+U\u0001\u001au.\u001c9vi\u0016\u0004C\u000f[3!o\u0016Lw\r\u001b;!_\u001a\u0004C\u000f[3!K\u0012<W\rI;tS:<\u0007%\u0019\u0011dkN$x.\u001c\u0011nKJ<W\rI:ue\u0006$XmZ=\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!ua\u0006\u0014\u0018-\u001c\u0011BAY\fG.^3!if\u0004X\r\t4pe\u0002\"\b.\u001a\u0011fI\u001e,\u0007e^3jO\"$\b\u0005\u001d:pa\u0016\u0014H/\u001f\u0011)i\"L7\u000f\t8fK\u0012\u001c\b\u0005^8!E\u0016\u0004\u0013\r\t8v[\u0016\u0014\u0018n\u0019\u0011usB,\u0017F\u0003\u0011!A\u0001R\u0003\u0005\u0011;qCJ\fW\u000e\t\"!e\u0016$XO\u001d8!if\u0004X\rI8gAQDW\rI7fe\u001e,\u0007e\u001d;sCR,w-\u001f\u0011)_:d\u0017\u0010I:qK\u000eLg-\u001f\u0011jM\u0002*8/\u001b8hA\u0005\u00043-^:u_6\u0004S.\u001a:hK\u0002\u001aHO]1uK\u001eL\u0018F\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\u0005\u00119be\u0006l\u0007e^3jO\"$\bK]8qKJ$\u0018\u0010\t\u0011fI\u001e,\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011u_\u0002*8/\u001a\u0011g_J\u00043m\\7qkRLgn\u001a\u0011fI\u001e,\u0007e^3jO\"$(\u0002\t\u0011!A)\u0002\u0003\u0005\u00119be\u0006l\u0007%\\3sO\u0016\u001cFO]1uK\u001eL\b%\\3sO\u0016\u00043\u000f\u001e:bi\u0016<\u0017\u0010\t;pAU\u001cX\r\t4pe\u0002\u001awN\u001c<feRLgn\u001a\u0011qe>\u0004XM\u001d;zA!L7\u000f^8ss\u0002\"x\u000eI3eO\u0016\u0004s/Z5hQRT\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003f]3fAm[\u0006K]8qKJ$\u00180T3sO\u0016\u001cFO]1uK\u001eLX,\u0018\u0006!A\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011g_J\u0004\u0003O]3eK\u001aLg.\u001a3!_B$\u0018n\u001c8tA=\u0014\b\u0005\u001d:pm&$W\rI2vgR|W\u000e\t4v]\u000e$\u0018n\u001c8*]\u0001\u0012\u0015\u0010\t3fM\u0006,H\u000e\u001e\u0011uQ&\u001c\bE]3ukJt7\u000f\t;iK*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001aX/\u001c\u0011pM\u0002\u0002(o\u001c9feRL\bE^1mk\u0016\u001chF\u0003\u0011!A\u0001Rs&\u0006\u0004\u00028\u0005\u001d\u0013Q\b\u000b\u0005\u0003s\tI\u0005\u0006\u0003\u0002<\u0005}\u0002cA1\u0002>\u0011)1m\u0003b\u0001Y!I\u0011\u0011I\u0006\u0002\u0002\u0003\u000f\u00111I\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004CBA\u000b\u0003?\t)\u0005E\u0002b\u0003\u000f\"Q\u0001`\u0006C\u00021BaA]\u0006A\u0002\u0005-\u0003C\u0002;x\u0003\u000b\nY\u0004K\u0003\fq\t\u000by%\t\u0002\u0002R\u0005!In\f\u0016+A\r{W\u000e];uK\u0002\"\b.\u001a\u0011xK&<\u0007\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011fI\u001e,\u0007%^:j]\u001e\u0004\u0013\rI2vgR|W\u000eI7fe\u001e,\u0007e\u001d;sCR,w-\u001f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u0011;qCJ\fW\u000eI!!m\u0006dW/\u001a\u0011usB,\u0007EZ8sAQDW\rI3eO\u0016\u0004s/Z5hQR\u0004\u0003O]8qKJ$\u0018\u0010\t\u0015jM\u0002\u0002W.\u001a:hKN#(/\u0019;fOf\u0004\u0007%[:!]>$\beZ5wK:d\u0003\u0005\u001e5jg\u0002rW-\u001a3tAQ|\u0007EY3!C\u0002rW/\\3sS\u000e\u0004C/\u001f9fS)\u0001\u0003\u0005\t\u0011+A\u0001#\b/\u0019:b[\u0002\u0012\u0005E]3ukJt\u0007\u0005^=qK\u0002zg\r\t;iK\u0002jWM]4fAM$(/\u0019;fOf\u0004\u0003f\u001c8ms\u0002\u001a\b/Z2jMf\u0004\u0013N\u001a\u0011vg&tw\rI1!GV\u001cHo\\7![\u0016\u0014x-\u001a\u0011tiJ\fG/Z4zS)\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0003\u0018M]1nA5,'oZ3TiJ\fG/Z4zA5,'oZ3!gR\u0014\u0018\r^3hs\u0002\"x\u000eI;tK\u00022wN\u001d\u0011d_:4XM\u001d;j]\u001e\u0004\u0003O]8qKJ$\u0018\u0010\t5jgR|'/\u001f\u0011u_\u0002*GmZ3!o\u0016Lw\r\u001b;\u000bA\u0001\u0002\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!QM,W\rI.\\!J|\u0007/\u001a:us6+'oZ3TiJ\fG/Z4z;vS\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002cm\u001c:!aJ,G-\u001a4j]\u0016$\u0007e\u001c9uS>t7\u000fI8sAA\u0014xN^5eK\u0002\u001aWo\u001d;p[\u00022WO\\2uS>t\u0017F\f\u0011Cs\u0002\"WMZ1vYR\u0004C\u000f[5tAI,G/\u001e:og\u0002\"\b.\u001a\u0006!A\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011tk6\u0004sN\u001a\u0011qe>\u0004XM\u001d;zAY\fG.^3t])\u0001\u0003\u0005\t\u0011+_U!\u0011QKA.)\u0019\t9&a\u0019\u0002fQ!\u0011\u0011LA/!\r\t\u00171\f\u0003\u0006y2\u0011\r\u0001\f\u0005\n\u0003?b\u0011\u0011!a\u0002\u0003C\n!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\t)\"a\b\u0002Z!)Q\r\u0004a\u0001M\"1a\u0010\u0004a\u0001\u00033BS\u0001\u0004\u001dC\u0003S\n#!a\u001b\u0002\u0005?|#F\u000b\u0011D_6\u0004X\u000f^3!i\",\u0007e^3jO\"$\be\u001c4!i\",\u0007%\u001a3hK\u0002\u0012\u0017\u0010I:v[*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001R\u0004\u0018M]1nA\u0005\u0003c/\u00197vK\u0002\"\u0018\u0010]3!M>\u0014\b\u0005\u001e5fA\u0015$w-\u001a\u0011xK&<\u0007\u000e\u001e\u0011qe>\u0004XM\u001d;zA5\u0002C\u000f[5tA9,W\rZ:!i>\u0004#-\u001a\u0011bA9,X.\u001a:jG\u0002\"\u0018\u0010]3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t\u0011Aa\u0006\u0014\u0018-\u001c\u0011xK&<\u0007\u000e\u001e)s_B,'\u000f^=!A\u0015$w-\u001a\u0011qe>\u0004XM\u001d;zAQ|\u0007%^:fA\u0019|'\u000fI2p[B,H/\u001b8hA\u0015$w-\u001a\u0011xK&<\u0007\u000e\u001e\u0006!A\u0001\u0002#\u0006\t\u0011Aa\u0006\u0014\u0018-\u001c\u0011eK\u001a\fW\u000f\u001c;!I\u00164\u0017-\u001e7uAY\fG.^3!M>\u0014\b\u0005\u001e5fA],\u0017n\u001a5uAA\u0014x\u000e]3sif\u0004#-\u001a4pe\u0016\u0004\u0013\r\u001d9ms&tw\r\t;iK\u0002jWM]4fAM$(/\u0019;fOft#\u0002\t\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t+iSN\u0004C-\u001a4bk2$8\u000f\t;pA\u0001\f\u0004M\f\u0006!A\u0001\u0002#fL\u000b\u0005\u0003_\n)\b\u0006\u0003\u0002r\u0005uD\u0003BA:\u0003o\u00022!YA;\t\u0015aXB1\u0001-\u0011%\tI(DA\u0001\u0002\b\tY(\u0001\u0006fm&$WM\\2fIQ\u0002b!!\u0006\u0002 \u0005M\u0004B\u0002@\u000e\u0001\u0004\t\u0019\bK\u0003\u000eq\t\u000b\t)\t\u0002\u0002\u0004\u0006\u0011Ib\f\u0016+A\r{W\u000e];uK\u0002\"\b.\u001a\u0011xK&<\u0007\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011fI\u001e,\u0007EY=!gVl'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002E\u000f]1sC6\u0004\u0013\t\t<bYV,\u0007\u0005^=qK\u00022wN\u001d\u0011uQ\u0016\u0004S\rZ4fA],\u0017n\u001a5uAA\u0014x\u000e]3sif\u0004S\u0006\t;iSN\u0004c.Z3eg\u0002\"x\u000e\t2fA\u0005\u0004c.^7fe&\u001c\u0007\u0005^=qK*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0003\u0018M]1nA\u0011,g-Y;mi\u0002\"WMZ1vYR\u0004c/\u00197vK\u00022wN\u001d\u0011uQ\u0016\u0004s/Z5hQR\u0004\u0003O]8qKJ$\u0018\u0010\t2fM>\u0014X\rI1qa2L\u0018N\\4!i\",\u0007%\\3sO\u0016\u00043\u000f\u001e:bi\u0016<\u0017P\f\u0011UQ&\u001c\b\u0005Z3gCVdGo\u001d\u0011u_\u0002\u0002\u0017\u0007\u0019\u0018\u000bA\u0001\u0002\u0003EK\u0018\u0016\t\u0005\u001d\u0015Q\u0012\u000b\u0005\u0003\u0013\u000b)\n\u0006\u0003\u0002\f\u0006=\u0005cA1\u0002\u000e\u0012)AP\u0004b\u0001Y!I\u0011\u0011\u0013\b\u0002\u0002\u0003\u000f\u00111S\u0001\u000bKZLG-\u001a8dK\u0012*\u0004CBA\u000b\u0003?\tY\tC\u0003f\u001d\u0001\u0007a\rK\u0003\u000fq\t\u000bI*\t\u0002\u0002\u001c\u0006\tIl\f\u0016+A\r{W\u000e];uK\u0002\"\b.\u001a\u0011xK&<\u0007\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011fI\u001e,\u0007EY=!gVl'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002E\u000f]1sC6\u0004\u0013\t\t<bYV,\u0007\u0005^=qK\u00022wN\u001d\u0011uQ\u0016\u0004S\rZ4fA],\u0017n\u001a5uAA\u0014x\u000e]3sif\u0004S\u0006\t;iSN\u0004c.Z3eg\u0002\"x\u000e\t2fA\u0005\u0004c.^7fe&\u001c\u0007\u0005^=qK*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA],\u0017n\u001a5u!J|\u0007/\u001a:us\u0002\u0002S\rZ4fAA\u0014x\u000e]3sif\u0004Co\u001c\u0011vg\u0016\u0004cm\u001c:!G>l\u0007/\u001e;j]\u001e\u0004S\rZ4fA],\u0017n\u001a5u\u0015\u0001\u0002\u0003\u0005\t\u00160+\u0011\ty*!*\u0015\u0005\u0005\u0005F\u0003BAR\u0003O\u00032!YAS\t\u0015axB1\u0001-\u0011%\tIkDA\u0001\u0002\b\tY+\u0001\u0006fm&$WM\\2fIY\u0002b!!\u0006\u0002 \u0005\r\u0006&B\b9\u0005\u0006=\u0016EAAY\u0003\u0005\u0005rF\u000b\u0016!\u0007>l\u0007/\u001e;fAQDW\rI<fS\u001eDG\u000fI8gAQDW\rI3eO\u0016\u0004#-\u001f\u0011tk6T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001#\b/\u0019:b[\u0002\n\u0005E^1mk\u0016\u0004C/\u001f9fA\u0019|'\u000f\t;iK\u0002*GmZ3!o\u0016Lw\r\u001b;!aJ|\u0007/\u001a:us\u0002j\u0003\u0005\u001e5jg\u0002rW-\u001a3tAQ|\u0007EY3!C\u0002rW/\\3sS\u000e\u0004C/\u001f9f\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003\u0011\u0019XM\u001c3\u0015\u0007\u0015\n9\f\u0003\u0004\u0002:B\u0001\r\u0001M\u0001\u0005I\u0006$\u0018\rK\u0003\u0011q\t\u000bi,\t\u0002\u0002@\u00061xF\u000b\u0016!'\u0016tG\rI1![\u0016\u001c8/Y4fAQ|\u0007\u0005\u001e5fAY,'\u000f^3yA\r|gN\\3di\u0016$\u0007e\u001c8!i\",\u0007e\u001c;iKJ\u00043/\u001b3fA=4\u0007\u0005\u001e5fA\u0015$w-\u001a\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t3bi\u0006\u0004S*Z:tC\u001e,\u0007\u0005Z1uC\u0002\"x\u000eI:f]\u0012T\u0001\u0005\t\u0011!U=\n\u0001c^3jO\"$H\u0005Z3gCVdG\u000fJ\u0019\u0016\r\u0005\u0015\u00171\\Ao+\t\t9MK\u0002g\u0003\u0013\\#!a3\u0011\t\u00055\u0017q[\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+<\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011\\Ah\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006yF\u0011\r\u0001\f\u0003\u0006GF\u0011\r\u0001\f\u0015\u0006\u0001a\u0012\u0015\u0011]\u0011\u0003\u0003G\f!QD\u0018+U\u0001*\u0005\u0010^3oIN\u00043lW#oi&$\u0018PV5tSR|'/X/!o&$\b\u000eI3eO\u0016l3\u000f]3dS\u001aL7\r\t4v]\u000e$\u0018n\u001c8bY&$\u0018P\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ\u0016\u00043lW#eO\u0016lV\fI2mCN\u001c\b%\u001a=q_N,7\u000f\t;iK\u0002\nGnZ8sSRDW\u000eI5oi\u0016\u0014h-Y2fA\u0019|'\u000fI1dG\u0016\u001c8/\u001b8hA\u0015$w-\u001a\u0011iSN$xN]=!C:$\u0007\u0005\u001d:pa\u0016\u0014H/[3t])\u0001\u0003E\u000b\u0006!A)\u0002\u0003i]3f\u0015\u0001\u0002#\u0006I.\\\u000bb\u0004Hn\u001c3fI\u0016#w-Z/^\u0015\u0001\u0002#\u0006I.\\!J|\u0007/\u001a:us6+'oZ3TiJ\fG/Z4z;vS\u0001\u0005\t\u0016!7n+e\u000e^5usZK7/\u001b;pevk&\u0002\t\u0011+Am[f+\u001a:uKblVL\u0003\u0011!U=\u0002")
public interface Edge {
    @Scaladoc(value="/** Edge ID */")
    public Object ID();

    @Scaladoc(value="/** ID of the source vertex of the edge */")
    public Object src();

    @Scaladoc(value="/** ID of the destination vertex of the edge */")
    public Object dst();

    public static /* synthetic */ boolean isOutgoing$(Edge $this) {
        return $this.isOutgoing();
    }

    @Scaladoc(value="/** `true` if the edge is an out-edge */")
    default public boolean isOutgoing() {
        return BoxesRunTime.equals((Object)this.ID(), (Object)this.dst());
    }

    public static /* synthetic */ boolean isIncoming$(Edge $this) {
        return $this.isIncoming();
    }

    @Scaladoc(value="/** `true` if the edge is an in-edge */")
    default public boolean isIncoming() {
        return BoxesRunTime.equals((Object)this.ID(), (Object)this.src());
    }

    @Scaladoc(value="/** Filter the edge from the `GraphPerspective`. */")
    public void remove();

    public static /* synthetic */ Object weight$(Edge $this, String weightProperty, Function1 mergeStrategy, Object object) {
        return $this.weight(weightProperty, mergeStrategy, object);
    }

    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (if `mergeStrategy` is not given, this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    * @param weightProperty  edge property to use for computing edge weight\n    * @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                      (see [[PropertyMergeStrategy]] for predefined options or provide custom function). By default this returns the\n    *                      sum of property values.\n    * @param default default value for the weight property before applying the merge strategy.\n    *                This defaults to `1` if `A` is a numeric type. This default value is applied before applying the\n    *                merge strategy. In the case where, e.g., `mergeStrategy =  PropertyMergeStrategy.sum[A]`, the\n    *                computed weight is the number of times the edge was active in the current view if the weight\n    *                property is not found.\n    */")
    default public <A, B> B weight(String weightProperty, Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, A a) {
        Object object;
        Option<B> maybeB = ((EntityVisitor)((Object)this)).getProperty(weightProperty, mergeStrategy);
        Option<B> option = maybeB;
        if (option instanceof Some) {
            Object value;
            Some some = (Some)option;
            object = value = some.value();
        } else if (None$.MODULE$.equals(option)) {
            Object b;
            object = b = mergeStrategy.apply((Object)((EntityVisitor)((Object)this)).history().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.event())).map((Function1 & Serializable)h -> new PropertyValue<Object>(h.time(), h.index(), a)));
        } else {
            throw new MatchError(option);
        }
        return (B)object;
    }

    public static /* synthetic */ Object weight$(Edge $this, String weightProperty, Function1 mergeStrategy, Numeric evidence$1) {
        return $this.weight(weightProperty, (Object)mergeStrategy, (Numeric)evidence$1);
    }

    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    *  @param weightProperty  edge property to use for computing edge weight\n    *  @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                       (see [[PropertyMergeStrategy]]\n    *                       for predefined options or provide custom function). By default this returns the\n    *                       sum of property values.\n    */")
    default public <A, B> B weight(String weightProperty, Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, Numeric<A> evidence$1) {
        return this.weight(weightProperty, mergeStrategy, ExtendedNumeric$.MODULE$.numericFromInt(1, evidence$1));
    }

    public static /* synthetic */ Object weight$(Edge $this, Function1 mergeStrategy, Numeric evidence$2) {
        return $this.weight((Object)mergeStrategy, (Numeric)evidence$2);
    }

    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (if `mergeStrategy` is not given, this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    *  @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                       (see [[PropertyMergeStrategy]]\n    *                       for predefined options or provide custom function). By default this returns the\n    *                       sum of property values.\n    */")
    default public <A, B> B weight(Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, Numeric<A> evidence$2) {
        return this.weight("weight", mergeStrategy, ExtendedNumeric$.MODULE$.numericFromInt(1, evidence$2));
    }

    public static /* synthetic */ Object weight$(Edge $this, String weightProperty, Object object, Numeric evidence$3) {
        return $this.weight(weightProperty, object, evidence$3);
    }

    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    *\n    *  @param weightProperty  edge property to use for computing edge weight\n    *  @param default default value for the weight property before applying the merge strategy.\n    *                 This defaults to `1`.\n    */")
    default public <A> A weight(String weightProperty, A a, Numeric<A> evidence$3) {
        return this.weight(weightProperty, PropertyMergeStrategy$.MODULE$.sum(evidence$3), a);
    }

    public static /* synthetic */ Object weight$(Edge $this, Object object, Numeric evidence$4) {
        return $this.weight(object, evidence$4);
    }

    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    *\n    *  @param default default value for the weight property before applying the merge strategy. This defaults to `1`.\n    */")
    default public <A> A weight(A a, Numeric<A> evidence$4) {
        return this.weight("weight", a, evidence$4);
    }

    public static /* synthetic */ Object weight$(Edge $this, String weightProperty, Numeric evidence$5) {
        return $this.weight(weightProperty, evidence$5);
    }

    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    * @param weightProperty  edge property to use for computing edge weight\n    */")
    default public <A> A weight(String weightProperty, Numeric<A> evidence$5) {
        return this.weight(weightProperty, ExtendedNumeric$.MODULE$.numericFromInt(1, evidence$5), evidence$5);
    }

    public static /* synthetic */ Object weight$(Edge $this, Numeric evidence$6) {
        return $this.weight(evidence$6);
    }

    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    */")
    default public <A> A weight(Numeric<A> evidence$6) {
        return this.weight("weight", ExtendedNumeric$.MODULE$.numericFromInt(1, evidence$6), evidence$6);
    }

    public static /* synthetic */ String weight$default$1$(Edge $this) {
        return $this.weight$default$1();
    }

    default public <A, B> String weight$default$1() {
        return "weight";
    }

    @Scaladoc(value="/** Send a message to the vertex connected on the other side of the edge\n    * @param data Message data to send\n    */")
    public void send(Object var1);

    public static void $init$(Edge $this) {
    }
}

