/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphview;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.graphview.Alignment$;
import com.raphtory.api.analysis.graphview.FixedGraph;
import com.raphtory.api.output.sink.Sink;
import com.raphtory.api.time.DiscreteInterval;
import com.raphtory.api.time.DiscreteInterval$;
import com.raphtory.api.time.Interval;
import com.raphtory.internals.components.querymanager.DynamicLoader;
import com.raphtory.internals.components.querymanager.Operation;
import com.raphtory.internals.components.querymanager.PointSet;
import com.raphtory.internals.time.IntervalParser$;
import java.io.Serializable;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Marked timeline view of a [[TemporalGraph]]\n  *\n  * A DottedGraph is a [[TemporalGraph]] with one or a sequence of temporal epochs across the timeline\n  * that can be used as references to create perspectives of the graph.\n  * To do so, this class offers methods to look to the past or to the future from every temporal epoch\n  * or to create windows that end ([[Alignment.END]]),\n  * have its center ([[Alignment.MIDDLE]]),\n  * or start ([[Alignment.START]]) at every temporal epoch.\n  *\n  * When creating a window from a temporal epoch, they are always included within the window.\n  * Particularly, for the three alignment options we have, the bounds of the windows are as follows:\n  *  - Alignment.START: The start of the window is inclusive and the end exclusive\n  *  - Alignment.MIDDLE: The start of the window is inclusive and the end exclusive\n  *  - Alignment.END: The start of the window is exclusive and the end inclusive\n  *\n  *  All the strings expressing intervals need to be in the format <number> <unit> ,\n  *  where numbers must be integers and units must be one of\n  *  {'year', 'month', 'week', 'day', 'hour', 'min'/'minute', 'sec'/'second', 'milli'/'millisecond'}\n  *  using the plural when the number is different than 1.\n  *  Commas and the construction 'and' are omitted to allow natural text.\n  *  For instance, the interval \"1 month 1 week 3 days\" can be rewritten as \"1 month, 1 week, and 3 days\"\n  *  @see  [[RaphtoryGraph]], [[TemporalGraph]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001B\n\u0015\u0001}A\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0007i\u0001!\t\u0001G\u001b\t\u000fa\u0002!\u0019!C\u0002s!1Q\b\u0001Q\u0001\niBqA\u0010\u0001C\u0002\u0013\rq\b\u0003\u0004L\u0001\u0001\u0006I\u0001\u0011\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006\u0019\u0002!\t!\u0019\u0005\u0006\u0019\u0002!\t\u0001\u001d\u0005\u0006\u0019\u0002!\ta \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\tY\u0001\u0001C\u0001\u0003/Aq!a\u0003\u0001\t\u0003\t\u0019\u0003C\u0004\u0002\f\u0001!\t!a\u000b\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011Q\b\u0001\u0005\u0002\u0005U\u0002bBA#\u0001\u0011%\u0011q\t\u0005\n\u0003?\u0002\u0011\u0013!C\u0005\u0003C\u00121\u0002R8ui\u0016$wI]1qQ*\u0011QCF\u0001\nOJ\f\u0007\u000f\u001b<jK^T!a\u0006\r\u0002\u0011\u0005t\u0017\r\\=tSNT!!\u0007\u000e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001c9\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001+\t\u0001#f\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\fQa\u001a:ba\"\u0004\"!\u000b\u0016\r\u0001\u0011)1\u0006\u0001b\u0001Y\t\tq)\u0005\u0002.aA\u0011!EL\u0005\u0003_\r\u0012qAT8uQ&tw\rE\u00022e!j\u0011\u0001F\u0005\u0003gQ\u0011!BR5yK\u0012<%/\u00199i\u0003\u0019a\u0014N\\5u}Q\u0011ag\u000e\t\u0004c\u0001A\u0003\"B\u0014\u0003\u0001\u0004A\u0013!C5h]>\u0014X-\u00138u+\u0005Q\u0004C\u0001\u0012<\u0013\ta4EA\u0002J]R\f!\"[4o_J,\u0017J\u001c;!\u00031IwM\\8sKN#(/\u001b8h+\u0005\u0001\u0005CA!I\u001d\t\u0011e\t\u0005\u0002DG5\tAI\u0003\u0002F=\u00051AH]8pizJ!aR\u0012\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f\u000e\nQ\"[4o_J,7\u000b\u001e:j]\u001e\u0004\u0013AB<j]\u0012|w\u000f\u0006\u0002)\u001d\")qj\u0002a\u0001!\u0006!1/\u001b>f!\t\u0011\u0013+\u0003\u0002SG\t!Aj\u001c8hQ\u00119AKX0\u0011\u0005UcV\"\u0001,\u000b\u0005]C\u0016\u0001C:dC2\fGm\\2\u000b\u0005eS\u0016a\u0002;bW\u0016Tx.\u001a\u0006\u00037r\taaZ5uQV\u0014\u0017BA/W\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%\u00011\u0002\u0005\u001fy#F\u000b\u0011!\u0007J,\u0017\r^3tA\u0005\u0004s/\u001b8e_^\u0004cM]8nAQDW\rI4jm\u0016t\u0007e]5{K\u0002\u001aH/\u0019:uS:<\u0007E^5bA\u00154XM]=!i\u0016l\u0007o\u001c:bY\u0002*\u0007o\\2i\u0015\u0001\u0002\u0003\u0005\t\u0016!A\tK\b\u0005Z3gCVdG\u000f\t;iK\u0002:\u0018N\u001c3po\u0002bwn\\6tA%tGo\u001c\u0011uQ\u0016\u0004\u0003/Y:uA!\nE.[4o[\u0016tGOL#O\t&R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0005/\u0019:b[\u0002\u001a\u0018N_3!i\",\u0007%\u001a=bGR\u00043/\u001b>fA=4\u0007\u0005\u001e5fA]Lg\u000eZ8x\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0013X\r^;s]\u0002\n\u0005%\\8eS\u001aLW\r\u001a\u0011SCBDGo\u001c:zA\u001d\u0014\u0018\r\u001d5!o&$\b\u000e\t;iK\u0002:\u0018N\u001c3po\u0002\u001a\u0018N_3\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0007!\u00127\rC\u0003P\u0011\u0001\u0007\u0001\u000bC\u0003e\u0011\u0001\u0007Q-A\u0005bY&<g.\\3oiB\u0011a-\u001b\b\u0003c\u001dL!\u0001\u001b\u000b\u0002\u0013\u0005c\u0017n\u001a8nK:$\u0018B\u00016l\u0005\u00151\u0016\r\\;f\u0013\ta7EA\u0006F]VlWM]1uS>t\u0007\u0006\u0002\u0005U=:\f\u0013a\\\u0001\u0003\u001c=R#\u0006I\"sK\u0006$Xm\u001d\u0011bA]Lg\u000eZ8xA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001a\u0018N_3!C:$\u0007%\u00197jO:lWM\u001c;!MJ|W\u000eI3wKJL\b\u0005^3na>\u0014\u0018\r\u001c\u0011fa>\u001c\u0007N\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\u0005\u00119be\u0006l\u0007e]5{K\u0002\"\b.\u001a\u0011fq\u0006\u001cG\u000fI:ju\u0016\u0004sN\u001a\u0011uQ\u0016\u0004s/\u001b8e_^T\u0001\u0005\t\u0011!U\u0001\u0002\u0003\t]1sC6\u0004\u0013\r\\5h]6,g\u000e\u001e\u0011uQ\u0016\u0004\u0013\r\\5h]6,g\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011xS:$wn\u001e\u0006!A\u0001\u0002#\u0006\t\u0011Ae\u0016$XO\u001d8!\u0003\u0002jw\u000eZ5gS\u0016$\u0007EU1qQR|'/\u001f\u0011he\u0006\u0004\b\u000eI<ji\"\u0004C\u000f[3!o&tGm\\<!g&TX\rI1oI\u0002\nG.[4o[\u0016tGO\u0003\u0011!A\u0001Rs\u0006\u0006\u0002)c\")!/\u0003a\u0001g\u0006)1/\u001b>fgB\u0019A/\u001f)\u000f\u0005U<hBA\"w\u0013\u0005!\u0013B\u0001=$\u0003\u001d\u0001\u0018mY6bO\u0016L!A_>\u0003\u0011%#XM]1cY\u0016T!\u0001_\u0012)\t%!f,`\u0011\u0002}\u0006\u0011\u0019b\f\u0016+A\r\u0013X-\u0019;fA\u0005\u0004c.^7cKJ\u0004sN\u001a\u0011xS:$wn^:!o&$\b\u000e\t;iK\u0002:\u0017N^3oAML'0Z:!CR\u0004SM^3ss\u0002\"X-\u001c9pe\u0006d\u0007%\u001a9pG\"t#\u0002\t\u0011!A)\u0002#)\u001f\u0011eK\u001a\fW\u000f\u001c;!i\",\u0007e^5oI><\b\u0005\\8pWN\u0004\u0013N\u001c;pAQDW\r\t9bgR\u0004\u0003&\u00117jO:lWM\u001c;/\u000b:#\u0015F\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u00043/\u001b>fg\u0002\"\b.\u001a\u0011fq\u0006\u001cG\u000fI:ju\u0016\u001c\be\u001c4!i\",\u0007e^5oI><8O\u0003\u0011!A\u0001R\u0003\u0005\u0011:fiV\u0014h\u000eI!![>$\u0017NZ5fI\u0002\u0012\u0016\r\u001d5u_JL\be\u001a:ba\"\u0004s/\u001b;iAQDW\rI<j]\u0012|w\u000fI:ju\u0016\u001c(\u0002\t\u0011!A)zC#\u0002\u0015\u0002\u0002\u0005\r\u0001\"\u0002:\u000b\u0001\u0004\u0019\b\"\u00023\u000b\u0001\u0004)\u0007&\u0002\u0006U=\u0006\u001d\u0011EAA\u0005\u0003\t-sF\u000b\u0016!\u0007J,\u0017\r^3!C\u0002rW/\u001c2fe\u0002zg\rI<j]\u0012|wo\u001d\u0011xSRD\u0007\u0005\u001e5fA\u001dLg/\u001a8!g&TXm\u001d\u0011b]\u0012\u0004s-\u001b<f]\u0002\nG.[4o[\u0016tG\u000fI1uA\u00154XM]=!i\u0016l\u0007o\u001c:bY\u0002*\u0007o\\2i])\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!g&TXm\u001d\u0011uQ\u0016\u0004S\r_1di\u0002\u001a\u0018N_3tA=4\u0007\u0005\u001e5fA]Lg\u000eZ8xg*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u0005d\u0017n\u001a8nK:$\b\u0005\u001e5fA\u0005d\u0017n\u001a8nK:$\be\u001c4!i\",\u0007e^5oI><8O\u0003\u0011!A\u0001R\u0003\u0005\u0011:fiV\u0014h\u000eI!![>$\u0017NZ5fI\u0002\u0012\u0016\r\u001d5u_JL\be\u001a:ba\"\u0004s/\u001b;iAQDW\rI<j]\u0012|w\u000fI:ju\u0016\u001c\b%\u00198eA\u001dLg/\u001a8!C2LwM\\7f]RT\u0001\u0005\t\u0011!U=\n!\u0002Z1uK^Kg\u000eZ8x)\rA\u0013q\u0002\u0005\u0006\u001f.\u0001\r\u0001\u0011\u0015\u0006\u0017Qs\u00161C\u0011\u0003\u0003+\t\u0011Q`\u0018+U\u0001\u00023I]3bi\u0016\u001c\b%\u0019\u0011xS:$wn\u001e\u0011ge>l\u0007\u0005\u001e5fA\u001dLg/\u001a8!g&TX\rI1uA\u00154XM]=!i\u0016l\u0007o\u001c:bY\u0002*\u0007o\\2i])\u0001\u0003\u0005\t\u0011+A\u0001\u0012\u0015\u0010\t3fM\u0006,H\u000e\u001e\u0011uQ\u0016\u0004s/\u001b8e_^\u0004Cn\\8lg\u0002Jg\u000e^8!i\",\u0007\u0005]1ti\u0002B\u0013\t\\5h]6,g\u000e\u001e\u0018F\u001d\u0012K#\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0003\t]1sC6\u00043/\u001b>fAQDW\rI3yC\u000e$\be]5{K\u0002zg\r\t;iK\u0002:\u0018N\u001c3po*\u0001\u0003\u0005\t\u0011+A\u0001\u0002%/\u001a;ve:\u0004\u0013\tI7pI&4\u0017.\u001a3!%\u0006\u0004\b\u000e^8ss\u0002:'/\u00199iA]LG\u000f\u001b\u0011uQ\u0016\u0004s/\u001b8e_^\u00043/\u001b>f\u0015\u0001\u0002\u0003\u0005\t\u00160)\u0015A\u0013\u0011DA\u000e\u0011\u0015yE\u00021\u0001A\u0011\u0015!G\u00021\u0001fQ\u0015aAKXA\u0010C\t\t\t#\u0001B\r_)R\u0003e\u0011:fCR,7\u000fI1!o&tGm\\<!MJ|W\u000e\t;iK\u0002:\u0017N^3oAML'0\u001a\u0011b]\u0012\u0004\u0013\r\\5h]6,g\u000e\u001e\u0011bi\u0002*g/\u001a:zAQ,W\u000e]8sC2\u0004S\r]8dQ:R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0005/\u0019:b[\u0002\u001a\u0018N_3!i\",\u0007%\u001a=bGR\u00043/\u001b>fA=4\u0007\u0005\u001e5fA]Lg\u000eZ8x\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0003\u0018M]1nA\u0005d\u0017n\u001a8nK:$\b\u0005\u001e5fA\u0005d\u0017n\u001a8nK:$\be\u001c4!i\",\u0007e^5oI><(\u0002\t\u0011!A)\u0002\u0003\u0005\u0011:fiV\u0014h\u000eI!![>$\u0017NZ5fI\u0002\u0012\u0016\r\u001d5u_JL\be\u001a:ba\"\u0004s/\u001b;iAQDW\rI<j]\u0012|w\u000fI:ju\u0016\u0004\u0013M\u001c3!C2LwM\\7f]RT\u0001\u0005\t\u0011!U=\"2\u0001KA\u0013\u0011\u0019\u0011X\u00021\u0001\u0002(A\u0019A/\u001f!)\t5!f, \u000b\u0006Q\u00055\u0012q\u0006\u0005\u0007e:\u0001\r!a\n\t\u000b\u0011t\u0001\u0019A3)\u000b9!f,a\u0002\u0002\tA\f7\u000f\u001e\u000b\u0002Q!*q\u0002\u00160\u0002:\u0005\u0012\u00111H\u0001p_)R\u0003ER8sA\u0015\f7\r\u001b\u0011uK6\u0004xN]1mA\u0015\u0004xn\u00195!GJ,\u0017\r^3!C\u0002:\u0018N\u001c3po\u0002\u001aH/\u0019:uS:<\u0007E\u001a:p[\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!a>Lg\u000e\u001e\u0011b]\u0012\u0004\u0013N\\2mk\u0012,\u0007%\u00197mA=dG-\u001a:!KZ,g\u000e^:\u000bA\u0001\u0002\u0003EK\u0018\u0002\r\u0019,H/\u001e:fQ\u0015\u0001BKXA!C\t\t\u0019%A80U)\u0002ci\u001c:!K\u0006\u001c\u0007\u000e\t;f[B|'/\u00197!KB|7\r\u001b\u0011de\u0016\fG/\u001a\u0011bA]Lg\u000eZ8xAM$\u0018M\u001d;j]\u001e\u0004cM]8nAQDW\rI2veJ,g\u000e\u001e\u0011q_&tG\u000fI1oI\u0002Jgn\u00197vI\u0016\u0004\u0013\r\u001c7!]\u0016<XM\u001d\u0011fm\u0016tGo\u001d\u0006!A\u0001\u0002#fL\u0001\u000bC\u0012$w+\u001b8e_^\u001cH#\u0002\u0015\u0002J\u0005u\u0003B\u0002:\u0012\u0001\u0004\tY\u0005E\u0003#\u0003\u001b\n\t&C\u0002\u0002P\r\u0012Q!\u0011:sCf\u0004B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/B\u0012\u0001\u0002;j[\u0016LA!a\u0017\u0002V\tA\u0011J\u001c;feZ\fG\u000eC\u0004e#A\u0005\t\u0019A3\u0002)\u0005$GmV5oI><8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019GK\u0002f\u0003KZ#!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003c\u001a\u0013AC1o]>$\u0018\r^5p]&!\u0011QOA6\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0006\u0001Qs\u0016\u0011P\u0011\u0003\u0003w\n1RR\u0018+U\u0001j\u0015M]6fI\u0002\"\u0018.\\3mS:,\u0007E^5fo\u0002zg\rI1!7n#V-\u001c9pe\u0006dwI]1qQvk&\u0002\t\u0011+\u0015\u0001\u0002#\u0006I!!\t>$H/\u001a3He\u0006\u0004\b\u000eI5tA\u0005\u00043l\u0017+f[B|'/\u00197He\u0006\u0004\b.X/!o&$\b\u000eI8oK\u0002z'\u000fI1!g\u0016\fX/\u001a8dK\u0002zg\r\t;f[B|'/\u00197!KB|7\r[:!C\u000e\u0014xn]:!i\",\u0007\u0005^5nK2Lg.\u001a\u0006!A)\u0002C\u000f[1uA\r\fg\u000e\t2fAU\u001cX\r\u001a\u0011bg\u0002\u0012XMZ3sK:\u001cWm\u001d\u0011u_\u0002\u001a'/Z1uK\u0002\u0002XM]:qK\u000e$\u0018N^3tA=4\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5/\u0015\u0001\u0002#\u0006\t+pA\u0011|\u0007e]8-AQD\u0017n\u001d\u0011dY\u0006\u001c8\u000fI8gM\u0016\u00148\u000fI7fi\"|Gm\u001d\u0011u_\u0002bwn\\6!i>\u0004C\u000f[3!a\u0006\u001cH\u000fI8sAQ|\u0007\u0005\u001e5fA\u0019,H/\u001e:fA\u0019\u0014x.\u001c\u0011fm\u0016\u0014\u0018\u0010\t;f[B|'/\u00197!KB|7\r\u001b\u0006!A)\u0002sN\u001d\u0011u_\u0002\u001a'/Z1uK\u0002:\u0018N\u001c3poN\u0004C\u000f[1uA\u0015tG\r\t\u0015\\7\u0006c\u0017n\u001a8nK:$h&\u0012(E;vKCF\u0003\u0011!U\u0001B\u0017M^3!SR\u001c\beY3oi\u0016\u0014\b\u0005K.\\\u00032LwM\\7f]RtS*\u0013#E\u0019\u0016kV,\u000b\u0017\u000bA\u0001R\u0003e\u001c:!gR\f'\u000f\u001e\u0011)7n\u000bE.[4o[\u0016tGOL*U\u0003J#V,X\u0015!CR\u0004SM^3ss\u0002\"X-\u001c9pe\u0006d\u0007%\u001a9pG\"t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I,iK:\u00043M]3bi&tw\rI1!o&tGm\\<!MJ|W\u000eI1!i\u0016l\u0007o\u001c:bY\u0002*\u0007o\\2iY\u0001\"\b.Z=!CJ,\u0007%\u00197xCf\u001c\b%\u001b8dYV$W\r\u001a\u0011xSRD\u0017N\u001c\u0011uQ\u0016\u0004s/\u001b8e_^t#\u0002\t\u0011+AA\u000b'\u000f^5dk2\f'\u000f\\=-A\u0019|'\u000f\t;iK\u0002\"\bN]3fA\u0005d\u0017n\u001a8nK:$\be\u001c9uS>t7\u000fI<fA!\fg/\u001a\u0017!i\",\u0007EY8v]\u0012\u001c\be\u001c4!i\",\u0007e^5oI><8\u000fI1sK\u0002\n7\u000f\t4pY2|wo\u001d\u001e\u000bA\u0001R\u0003\u0005I\u0017!\u00032LwM\\7f]Rt3\u000bV!S)j\u0002C\u000b[3!gR\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011xS:$wn\u001e\u0011jg\u0002Jgn\u00197vg&4X\rI1oI\u0002\"\b.\u001a\u0011f]\u0012\u0004S\r_2mkNLg/\u001a\u0006!A)\u0002\u0003%\f\u0011BY&<g.\\3oi:j\u0015\n\u0012#M\u000bj\u0002C\u000b[3!gR\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011xS:$wn\u001e\u0011jg\u0002Jgn\u00197vg&4X\rI1oI\u0002\"\b.\u001a\u0011f]\u0012\u0004S\r_2mkNLg/\u001a\u0006!A)\u0002\u0003%\f\u0011BY&<g.\\3oi:*e\n\u0012\u001e!)\",\u0007e\u001d;beR\u0004sN\u001a\u0011uQ\u0016\u0004s/\u001b8e_^\u0004\u0013n\u001d\u0011fq\u000edWo]5wK\u0002\ng\u000e\u001a\u0011uQ\u0016\u0004SM\u001c3!S:\u001cG.^:jm\u0016T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I!mY\u0002\"\b.\u001a\u0011tiJLgnZ:!Kb\u0004(/Z:tS:<\u0007%\u001b8uKJ4\u0018\r\\:!]\u0016,G\r\t;pA\t,\u0007%\u001b8!i\",\u0007EZ8s[\u0006$\b\u0005\u00108v[\n,'O\u0010\u0011=k:LGO\u0010\u0011-\u0015\u0001\u0002#\u0006\t\u0011xQ\u0016\u0014X\r\t8v[\n,'o\u001d\u0011nkN$\bEY3!S:$XmZ3sg\u0002\ng\u000e\u001a\u0011v]&$8\u000fI7vgR\u0004#-\u001a\u0011p]\u0016\u0004sN\u001a\u0006!A)\u0002\u0003e_\u0014zK\u0006\u0014x\u0005\f\u0011([>tG\u000f[\u0014-A\u001d:X-Z6(Y\u0001:C-Y=(Y\u0001:\u0003n\\;sO1\u0002s%\\5oO=:S.\u001b8vi\u0016<C\u0006I\u0014tK\u000e<sfJ:fG>tGm\n\u0017!O5LG\u000e\\5(_\u001dj\u0017\u000e\u001c7jg\u0016\u001cwN\u001c3({*\u0001\u0003E\u000b\u0011!kNLgn\u001a\u0011uQ\u0016\u0004\u0003\u000f\\;sC2\u0004s\u000f[3oAQDW\r\t8v[\n,'\u000fI5tA\u0011LgMZ3sK:$\b\u0005\u001e5b]\u0002\ndF\u0003\u0011!U\u0001\u00023i\\7nCN\u0004\u0013M\u001c3!i\",\u0007eY8ogR\u0014Xo\u0019;j_:\u0004s%\u00198eO\u0001\n'/\u001a\u0011p[&$H/\u001a3!i>\u0004\u0013\r\u001c7po\u0002r\u0017\r^;sC2\u0004C/\u001a=u])\u0001\u0003E\u000b\u0011!\r>\u0014\b%\u001b8ti\u0006t7-\u001a\u0017!i\",\u0007%\u001b8uKJ4\u0018\r\u001c\u0011#c\u0001jwN\u001c;iAE\u0002s/Z3lAM\u0002C-Y=tE\u0001\u001a\u0017M\u001c\u0011cK\u0002\u0012Xm\u001e:jiR,g\u000eI1tA\t\n\u0004%\\8oi\"d\u0003%\r\u0011xK\u0016\\G\u0006I1oI\u0002\u001a\u0004\u0005Z1zg\nR\u0001\u0005\t\u0016!A\u0001\u001bX-\u001a\u0011!7n\u0013\u0016\r\u001d5u_JLxI]1qQvkF\u0006I.\\)\u0016l\u0007o\u001c:bY\u001e\u0013\u0018\r\u001d5^;*\u0001\u0003EK\u0018")
public class DottedGraph<G extends FixedGraph<G>> {
    private final G graph;
    private final int ignoreInt;
    private final String ignoreString;

    public int ignoreInt() {
        return this.ignoreInt;
    }

    public String ignoreString() {
        return this.ignoreString;
    }

    @Scaladoc(value="/**  Creates a window from the given size starting via every temporal epoch\n    *  By default the window looks into the past (Alignment.END)\n    *\n    *  @param size the exact size of the window\n    *  @return A modified Raphtory graph with the window size\n    */")
    public G window(long size) {
        return this.window(size, Alignment$.MODULE$.END());
    }

    @Scaladoc(value="/** Creates a window from the given size and alignment from every temporal epoch\n    *\n    *  @param size the exact size of the window\n    *  @param alignment the alignment of the window\n    *  @return A modified Raphtory graph with the window size and alignment\n    */")
    public G window(long size, Enumeration.Value alignment) {
        return this.addWindows((Interval[])((Object[])new Interval[]{new DiscreteInterval(size)}), alignment);
    }

    @Scaladoc(value="/** Create a number of windows with the given sizes at every temporal epoch.\n    * By default the window looks into the past (Alignment.END)\n    *\n    * @param sizes the exact sizes of the windows\n    * @return A modified Raphtory graph with the window sizes\n    */")
    public G window(Iterable<Object> sizes) {
        return this.window(sizes, Alignment$.MODULE$.END());
    }

    @Scaladoc(value="/** Create a number of windows with the given sizes and given alignment at every temporal epoch.\n    *\n    * @param sizes the exact sizes of the windows\n    * @param alignment the alignment of the windows\n    * @return A modified Raphtory graph with the window sizes and given alignment\n    */")
    public G window(Iterable<Object> sizes, Enumeration.Value alignment) {
        return this.addWindows((Interval[])((IterableOnceOps)sizes.map((Function1)DiscreteInterval$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Interval.class)), alignment);
    }

    @Scaladoc(value="/**  Creates a window from the given size at every temporal epoch.\n    *  By default the window looks into the past (Alignment.END)\n    *\n    *  @param size the exact size of the window\n    *  @return A modified Raphtory graph with the window size\n    */")
    public G dateWindow(String size) {
        return this.dateWindow(size, Alignment$.MODULE$.END());
    }

    @Scaladoc(value="/** Creates a window from the given size and alignment at every temporal epoch.\n    *\n    *  @param size the exact size of the window\n    *  @param alignment the alignment of the window\n    *  @return A modified Raphtory graph with the window size and alignment\n    */")
    public G dateWindow(String size, Enumeration.Value alignment) {
        return this.addWindows((Interval[])((Object[])new Interval[]{IntervalParser$.MODULE$.parse(size)}), alignment);
    }

    @Scaladoc(value="/** Create a number of windows with the given sizes at every temporal epoch.\n    * By default the window looks into the past (Alignment.END)\n    *\n    * @param sizes the exact sizes of the windows\n    * @return A modified Raphtory graph with the window sizes\n    */")
    public G dateWindow(Iterable<String> sizes) {
        return this.dateWindow(sizes, Alignment$.MODULE$.END());
    }

    @Scaladoc(value="/** Create a number of windows with the given sizes and given alignment at every temporal epoch.\n    *\n    * @param sizes the exact sizes of the windows\n    * @param alignment the alignment of the windows\n    * @return A modified Raphtory graph with the window sizes and given alignment\n    */")
    public G dateWindow(Iterable<String> sizes, Enumeration.Value alignment) {
        return this.addWindows((Interval[])((IterableOnceOps)sizes.map((Function1 & Serializable)interval -> IntervalParser$.MODULE$.parse((String)interval))).toArray(ClassTag$.MODULE$.apply(Interval.class)), alignment);
    }

    @Scaladoc(value="/** For each temporal epoch create a window starting from the current point and include all older events\n    */")
    public G past() {
        return this.addWindows((Interval[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Interval.class)), Alignment$.MODULE$.END());
    }

    @Scaladoc(value="/** For each temporal epoch create a window starting from the current point and include all newer events\n    */")
    public G future() {
        return this.addWindows((Interval[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Interval.class)), Alignment$.MODULE$.START());
    }

    private G addWindows(Interval[] sizes, Enumeration.Value alignment) {
        Interval[] x$1 = sizes;
        Enumeration.Value x$2 = alignment;
        DynamicLoader x$3 = this.graph.query().copy$default$1();
        String x$4 = this.graph.query().copy$default$2();
        String x$5 = this.graph.query().copy$default$3();
        PointSet x$6 = this.graph.query().copy$default$4();
        long x$7 = this.graph.query().copy$default$5();
        long x$8 = this.graph.query().copy$default$6();
        List<Operation> x$9 = this.graph.query().copy$default$9();
        long x$10 = this.graph.query().copy$default$10();
        long x$11 = this.graph.query().copy$default$11();
        Option<Sink> x$12 = this.graph.query().copy$default$12();
        Option<String> x$13 = this.graph.query().copy$default$13();
        return (G)((FixedGraph)this.graph.newGraph(this.graph.query().copy(x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$2, x$9, x$10, x$11, x$12, x$13), this.graph.querySender()));
    }

    private Enumeration.Value addWindows$default$2() {
        return Alignment$.MODULE$.END();
    }

    public DottedGraph(G graph) {
        this.graph = graph;
        this.ignoreInt = 1;
        this.ignoreString = "";
    }
}

