/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.algorithm;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.algorithm.MultilayerReduction;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.MultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base class for writing graph algorithms that act on multilayer views and return multilayer views.\n  *\n  * A `Multilayer` algorithm maps multilayer views to multilayer views and requires the\n  * input graph to be multilayer.\n  *\n  * @define chainBody The new algorithm's `apply` method first applies this algorithm and then the `other`,\n  *                   clearing all messages in-between. The `tabularise` method of the chained algorithm calls only\n  *                   the `tabularise` method of `other`.\n  */")
@ScalaSignature(bytes="\u0006\u0005A4qAC\u0006\u0011\u0002\u0007\u0005a\u0003C\u0003\"\u0001\u0011\u0005!%\u0002\u0003'\u0001\u0001:S\u0001B\u0017\u0001A\u001dBQA\f\u0001\u0005\u0002=BQ!\u0012\u0001\u0005B\u0019CQ!\u0012\u0001\u0005\u0002ACQ!\u0012\u0001\u0005\u0002mCQ!\u0012\u0001\u0005\u0002\u0001DQ!\u0012\u0001\u0005\u0002!\u0014!\"T;mi&d\u0017-_3s\u0015\taQ\"A\u0005bY\u001e|'/\u001b;i[*\u0011abD\u0001\tC:\fG._:jg*\u0011\u0001#E\u0001\u0004CBL'B\u0001\n\u0014\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011aC\u0005\u0003A-\u0011QBQ1tK\u0006cwm\u001c:ji\"l\u0017A\u0002\u0013j]&$H\u0005F\u0001$!\tAB%\u0003\u0002&3\t!QK\\5u\u0005\tIe\u000e\u0005\u0002)W5\t\u0011F\u0003\u0002+\u001b\u0005IqM]1qQZLWm^\u0005\u0003Y%\u0012!$T;mi&d\u0017-_3s\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016\u00141aT;u\u0003\u0015\t\u0007\u000f\u001d7z)\t\u00014\u0007\u0005\u00022k9\u0011!g\r\u0007\u0001\u0011\u0015!D\u00011\u0001(\u0003\u00159'/\u00199i\u0013\t14FA\bNk2$\u0018\u000e\\1zKJ<%/\u00199iQ\u0011!\u0001HQ\"\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014\u0001C:dC2\fGm\\2\u000b\u0005ur\u0014a\u0002;bW\u0016Tx.\u001a\u0006\u0003\u007fM\taaZ5uQV\u0014\u0017BA!;\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%\u0001#\u0002c>R#\u0006\t#fM\u0006,H\u000e\u001e\u0011j[BdW-\\3oi\u0006$\u0018n\u001c8!e\u0016$XO\u001d8tAQDW\rI4sCBD\u0007%\u001e8dQ\u0006tw-\u001a3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI4sCBD\u0007e\u001a:ba\"\u0004Co\u001c\u0011sk:\u0004c-\u001e8di&|g\u000eI;q_:T\u0001\u0005\t\u0011!U=\na\u0002J7j]V\u001cHe\u001a:fCR,'\u000f\u0006\u0002H\u0011B\u0011a\u0004\u0001\u0005\u0006\u0013\u0016\u0001\rAS\u0001\u0006_RDWM\u001d\t\u0003=-K!\u0001T\u0006\u0003\u000f\u001d+g.\u001a:jG\"\"Q\u0001\u000f\"OC\u0005y\u0015!!\u00050U)\u00023\t[1j]\u0002\"\b.[:!C2<wN]5uQ6\u0004s/\u001b;iA\u0005\u00043lW$f]\u0016\u0014\u0018nY/^A\u0005dwm\u001c:ji\"l'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\"3\r[1j]\n{G-\u001f\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI8uQ\u0016\u0014\b%\u00117h_JLG\u000f[7!i>\u0004\u0013\r\u001d9ms\u0002\ng\r^3sAQD\u0017n\u001d\u0011p]\u0016T\u0001\u0005\t\u0011!U=\"\"!\u0015+\u0011\u0005y\u0011\u0016BA*\f\u0005MiU\u000f\u001c;jY\u0006LXM\u001d*fIV\u001cG/[8o\u0011\u0015Ie\u00011\u0001V!\tqb+\u0003\u0002X\u0017\t\u0001r)\u001a8fe&\u001c'+\u001a3vGRLwN\u001c\u0015\u0005\ra\u0012\u0015,I\u0001[\u0003\u0005\rrF\u000b\u0016!\u0007\"\f\u0017N\u001c\u0011uQ&\u001c\b%\u00197h_JLG\u000f[7!o&$\b\u000eI1!7n;UM\\3sS\u000e\u0014V\rZ;di&|g.X/!C2<wN]5uQ6T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0011\u001a\u0007.Y5o\u0005>$\u0017P\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007e\u001c;iKJ\u0004\u0013\t\\4pe&$\b.\u001c\u0011u_\u0002\n\u0007\u000f\u001d7zA\u00054G/\u001a:!i\"L7\u000fI8oK*\u0001\u0003\u0005\t\u0011+_Q\u0011\u0011\u000b\u0018\u0005\u0006\u0013\u001e\u0001\r!\u0015\u0015\u0005\u000fa\u0012e,I\u0001`\u0003\u0005%rF\u000b\u0016!\u0007\"\f\u0017N\u001c\u0011uQ&\u001c\b%\u00197h_JLG\u000f[7!o&$\b\u000eI1!7nkU\u000f\u001c;jY\u0006LXM\u001d*fIV\u001cG/[8o;v\u0003\u0013\r\\4pe&$\b.\u001c\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005J2iC&t'i\u001c3z\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!_RDWM\u001d\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000eI1qa2L\b%\u00194uKJ\u0004C\u000f[5tA=tWM\u0003\u0011!A\u0001Rs\u0006\u0006\u0002HC\")\u0011\n\u0003a\u0001EB\u0011adY\u0005\u0003I.\u0011A#T;mi&d\u0017-_3s!J|'.Z2uS>t\u0007\u0006\u0002\u00059\u0005\u001a\f\u0013aZ\u0001\u0002,=R#\u0006I\"iC&t\u0007\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI<ji\"\u0004\u0013\rI.\\\u001bVdG/\u001b7bs\u0016\u0014\bK]8kK\u000e$\u0018n\u001c8^;\u0002\nGnZ8sSRDWN\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002Ce\u00195bS:\u0014u\u000eZ=\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011pi\",'\u000fI!mO>\u0014\u0018\u000e\u001e5nAQ|\u0007%\u00199qYf\u0004\u0013M\u001a;fe\u0002\"\b.[:!_:,'\u0002\t\u0011!A)zCCA$j\u0011\u0015I\u0015\u00021\u0001HQ\u0011I\u0001HQ6\"\u00031\f\u00111D\u0018+U\u0001\u001a\u0005.Y5oAQD\u0017n\u001d\u0011bY\u001e|'/\u001b;i[\u0002:\u0018\u000e\u001e5!C:|G\u000f[3sA5+H\u000e^5mCf,'\u000fI1mO>\u0014\u0018\u000e\u001e5n\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011%G\"\f\u0017N\u001c\"pIfT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002zG\u000f[3sA\u0005cwm\u001c:ji\"l\u0007\u0005^8!CB\u0004H.\u001f\u0011bMR,'\u000f\t;iSN\u0004sN\\3\u000bA\u0001\u0002\u0003EK\u0018)\t\u0001A$I\\\u0011\u0002_\u0006!ia\f\u0016+A\t\u000b7/\u001a\u0011dY\u0006\u001c8\u000f\t4pe\u0002:(/\u001b;j]\u001e\u0004sM]1qQ\u0002\nGnZ8sSRDWn\u001d\u0011uQ\u0006$\b%Y2uA=t\u0007%\\;mi&d\u0017-_3sAYLWm^:!C:$\u0007E]3ukJt\u0007%\\;mi&d\u0017-_3sAYLWm^:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\n\u0005\u0005Y'vYRLG.Y=fe\u0002\u0004\u0013\r\\4pe&$\b.\u001c\u0011nCB\u001c\b%\\;mi&d\u0017-_3sAYLWm^:!i>\u0004S.\u001e7uS2\f\u00170\u001a:!m&,wo\u001d\u0011b]\u0012\u0004#/Z9vSJ,7\u000f\t;iK*\u0001\u0003E\u000b\u0011j]B,H\u000fI4sCBD\u0007\u0005^8!E\u0016\u0004S.\u001e7uS2\f\u00170\u001a:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002E-\u001a4j]\u0016\u00043\r[1j]\n{G-\u001f\u0011UQ\u0016\u0004c.Z<!C2<wN]5uQ6<3\u000f\t1baBd\u0017\u0010\u0019\u0011nKRDw\u000e\u001a\u0011gSJ\u001cH\u000fI1qa2LWm\u001d\u0011uQ&\u001c\b%\u00197h_JLG\u000f[7!C:$\u0007\u0005\u001e5f]\u0002\"\b.\u001a\u0011a_RDWM\u001d1-\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001aG.Z1sS:<\u0007%\u00197mA5,7o]1hKN\u0004\u0013N\\\u0017cKR<X-\u001a8/AQCW\r\t1uC\n,H.\u0019:jg\u0016\u0004\u0007%\\3uQ>$\u0007e\u001c4!i\",\u0007e\u00195bS:,G\rI1mO>\u0014\u0018\u000e\u001e5nA\r\fG\u000e\\:!_:d\u0017P\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004\u0003\r^1ck2\f'/[:fA\u0002jW\r\u001e5pI\u0002zg\r\t1pi\",'\u000f\u0019\u0018\u000bA\u0001Rs\u0006")
public interface Multilayer
extends BaseAlgorithm {
    public static /* synthetic */ ConcreteMultilayerGraphPerspective apply$(Multilayer $this, MultilayerGraphPerspective graph) {
        return $this.apply(graph);
    }

    @Scaladoc(value="/** Default implementation returns the graph unchanged\n    *\n    * @param graph graph to run function upon\n    */")
    default public ConcreteMultilayerGraphPerspective apply(MultilayerGraphPerspective graph) {
        return (ConcreteMultilayerGraphPerspective)graph.identity();
    }

    public static /* synthetic */ Multilayer $minus$greater$(Multilayer $this, Generic other) {
        return $this.$minus$greater(other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public Multilayer $minus$greater(Generic other) {
        return new Multilayer(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Generic other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(MultilayerReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with another Multilayer algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Multilayer other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(MultilayerGraphPerspective graph) {
                return (ConcreteMultilayerGraphPerspective)((Generic)this.second()).apply(((Multilayer)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                Multilayer.$init$(this);
            }
        };
    }

    public static /* synthetic */ MultilayerReduction $minus$greater$(Multilayer $this, GenericReduction other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerReduction $minus$greater(GenericReduction other) {
        return new MultilayerReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(Generic other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(MultilayerGraphPerspective graph) {
                return ((GenericReduction)this.second()).apply(((Multilayer)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerReduction.$init$(this);
            }
        };
    }

    public static /* synthetic */ MultilayerReduction $minus$greater$(Multilayer $this, MultilayerReduction other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerReduction $minus$greater(MultilayerReduction other) {
        return new MultilayerReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(Generic other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(MultilayerGraphPerspective graph) {
                return ((MultilayerReduction)this.second()).apply((MultilayerGraphPerspective)((Object)((Multilayer)this.first()).apply(graph).clearMessages()));
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerReduction.$init$(this);
            }
        };
    }

    public static /* synthetic */ Multilayer $minus$greater$(Multilayer $this, MultilayerProjection other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public Multilayer $minus$greater(MultilayerProjection other) {
        return new Multilayer(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Generic other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(MultilayerReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with another Multilayer algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Multilayer other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(MultilayerGraphPerspective graph) {
                return ((MultilayerProjection)this.second()).apply(((Multilayer)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                Multilayer.$init$(this);
            }
        };
    }

    public static /* synthetic */ Multilayer $minus$greater$(Multilayer $this, Multilayer other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another Multilayer algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public Multilayer $minus$greater(Multilayer other) {
        return new Multilayer(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Generic other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(MultilayerReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with another Multilayer algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Multilayer other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(MultilayerGraphPerspective graph) {
                return ((Multilayer)this.second()).apply((MultilayerGraphPerspective)((Object)((Multilayer)this.first()).apply(graph).clearMessages()));
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                Multilayer.$init$(this);
            }
        };
    }

    public static void $init$(Multilayer $this) {
    }
}

