/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.motif.RequestEdges;
import com.raphtory.algorithms.temporal.motif.StarMotifCounter;
import com.raphtory.algorithms.temporal.motif.ThreeNodeMotifs$;
import com.raphtory.algorithms.temporal.motif.TriadMotifCounter;
import com.raphtory.algorithms.temporal.motif.TwoNodeMotifs;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteExplodedEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedEdge;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@Scaladoc(value="/**\n  *  {s}`ThreeNodeMotifs(delta:Long, graphWide:Boolean=true, prettyPrint:Boolean=true)`\n  *    : Count occurrences of three-edge up-to-three-node temporal motifs in the network. For counts per vertex, see LocalThreeNodeMotifs.\n  *\n  *  The algorithm is very based on that in \"Motifs in Temporal Networks\". An option is given to return results as a hashmap with labels or as an array which is easier for post-processing.\n  *\n  *  ## Motifs\n  *\n  *  ### Stars\n  *\n  *  There are three classes (in the order they are outputted) of star motif on three nodes based on the switching behaviour of the edges between the two leaf nodes.\n  *\n  *   - PRE: Stars of the form i<->j, i<->j, i<->k (ie two interactions with leaf j followed by one with leaf k)\n  *   - MID: Stars of the form i<->j, i<->k, i<->j (ie switching interactions from leaf j to leaf k, back to j again)\n  *   - POST: Stars of the form i<->j, i<->k, i<->k (ie one interaction with leaf j followed by two with leaf k)\n  *\n  *  Within each of these classes is 8 motifs depending on the direction of the first to the last edge -- incoming \"I\" or outgoing \"O\".\n  *  These are enumerated in the order III, IIO, IOI, IOO, OII, OIO, OOI, OOO (like binary with \"I\"-0 and \"O\"-1).\n  *\n  *  ### Two node motifs\n  *\n  *  Also included are two node motifs, of which there are 8 when counted from the perspective of each vertex. These are characterised by the direction of each edge, enumerated\n  *  in the above order. Note that for the global graph counts, each motif is counted in both directions (a single III motif for one vertex is an OOO motif for the other vertex).\n  *\n  *  ### Triangles\n  *\n  *  There are 8 triangle motifs, below is the order in which they appear in the returned array:\n  *\n  *   1. i --> j, k --> j, i --> k\n  *   2. i --> j, k --> i, j --> k\n  *   3. i --> j, j --> k, i --> k\n  *   4. i --> j, i --> k, j --> k\n  *   5. i --> j, k --> j, k --> i\n  *   6. i --> j, k --> i, k --> j\n  *   7. i --> j, j --> k, k --> i\n  *   8. i --> j, i --> k, k --> j\n  *\n  * ## States\n  *  {s}`starCounts: Array[Int]`\n  *    : Three-node star motif counts stored as an array (see indices above)\n  *  {s}`twoNodeCounts: Array[Int]`\n  *    : Two-node motif counts stored as an array (see indices above)\n  *  {s}`triCounts: Array[Int]`\n  *    : Triangle motif counts stored as an array (see indices above)\n  */")
@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\u000e\u001d\u0001\u001dB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%Q\bC\u0003B\u0001\u0011\u0005!\tC\u0003I\u0001\u0011\u0005\u0013\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0003{\u0001\u0011\u00053pB\u0004\u0002*qA\t!a\u000b\u0007\rma\u0002\u0012AA\u0017\u0011\u0019\t\u0015\u0002\"\u0001\u0002@!1\u0001*\u0003C\u0001\u0003\u0003B\u0011\"!\u0013\n#\u0003%\t!a\u0013\t\u0013\u0005\u0005\u0014\"%A\u0005\u0002\u0005\r\u0004\"CA4\u0013E\u0005I\u0011AA2\u0011\u001d\tI'\u0003C\u0001\u0003WBq!a\u001f\n\t\u0003\ti\bC\u0005\u0002\b&\u0011\r\u0011\"\u0001\u0002\n\"A\u0011\u0011V\u0005!\u0002\u0013\tY\tC\u0004\u0002,&!\t!!,\t\u000f\u0005u\u0017\u0002\"\u0001\u0002`\"9\u0011q_\u0005\u0005\u0002\u0005e\bb\u0002B\b\u0013\u0011\u0005!\u0011\u0003\u0005\n\u0005OI\u0011\u0013!C\u0001\u0003\u0017B\u0011B!\u000b\n#\u0003%\t!a\u0019\t\u0013\t-\u0012\"%A\u0005\u0002\u0005\r\u0004\"\u0003B\u0017\u0013\u0005\u0005I\u0011\u0002B\u0018\u0005=!\u0006N]3f\u001d>$W-T8uS\u001a\u001c(BA\u000f\u001f\u0003\u0015iw\u000e^5g\u0015\ty\u0002%\u0001\u0005uK6\u0004xN]1m\u0015\t\t#%\u0001\u0006bY\u001e|'/\u001b;i[NT!a\t\u0013\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011!J\u0001\u0004G>l7\u0001A\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003gQ\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003k\t\n1!\u00199j\u0013\t9\u0004G\u0001\tHK:,'/[2SK\u0012,8\r^5p]\u0006)A-\u001a7uCB\u0011\u0011FO\u0005\u0003w)\u0012A\u0001T8oO\u0006IqM]1qQ^KG-\u001a\t\u0003SyJ!a\u0010\u0016\u0003\u000f\t{w\u000e\\3b]\u0006Y\u0001O]3uif\u0004&/\u001b8u\u0003\u0019a\u0014N\\5u}Q!1)\u0012$H!\t!\u0005!D\u0001\u001d\u0011\u001dAD\u0001%AA\u0002eBq\u0001\u0010\u0003\u0011\u0002\u0003\u0007Q\bC\u0004A\tA\u0005\t\u0019A\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005)k\u0005CA&V\u001d\taU\n\u0004\u0001\t\u000b9+\u0001\u0019A(\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005A\u001bV\"A)\u000b\u0005I\u0013\u0014!C4sCBDg/[3x\u0013\t!\u0016K\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&\u0011ak\u0015\u0002\r%\u0016$WoY3e\u000fJ\f\u0007\u000f[\u0001\bCJ\u0014\u0018-_(q+\tI\u0006\rF\u0002[mb$\"aW9\u0015\u0005qK\u0007cA\u0015^?&\u0011aL\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0019\u0002$Q!\u0019\u0004C\u0002\t\u0014\u0011\u0001V\t\u0003G\u001a\u0004\"!\u000b3\n\u0005\u0015T#a\u0002(pi\"Lgn\u001a\t\u0003S\u001dL!\u0001\u001b\u0016\u0003\u0007\u0005s\u0017\u0010C\u0004k\r\u0005\u0005\t9A6\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002m_~k\u0011!\u001c\u0006\u0003]*\nqA]3gY\u0016\u001cG/\u0003\u0002q[\nA1\t\\1tgR\u000bw\rC\u0003s\r\u0001\u00071/A\u0001g!\u0015ICoX0`\u0013\t)(FA\u0005Gk:\u001cG/[8oe!)qO\u0002a\u00019\u0006\t\u0011\rC\u0003z\r\u0001\u0007A,A\u0001c\u0003)!\u0018MY;mCJL7/\u001a\u000b\u0004y\u0006\u0015\u0001cA?\u0002\u00025\taP\u0003\u0002\u0000e\u0005)A/\u00192mK&\u0019\u00111\u0001@\u0003\u000bQ\u000b'\r\\3\t\r9;\u0001\u0019AA\u0004!\r\u0001\u0016\u0011B\u0005\u0004\u0003\u0017\t&a\u0006*fIV\u001cW\rZ$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<fQ\u001d\u0001\u0011qBA\u0012\u0003K\u0001B!!\u0005\u0002 5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\tI\"a\u0007\u0002\u000fQ\f7.\u001a>pK*\u0019\u0011Q\u0004\u0013\u0002\r\u001dLG\u000f[;c\u0013\u0011\t\t#a\u0005\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!a\n\u0002%\u000f{#F\u000b\u0006!A)\u0002\u0003e_:~ARC'/Z3O_\u0012,Wj\u001c;jMNDC-\u001a7uCjbuN\\4-A\u001d\u0014\u0018\r\u001d5XS\u0012,'HQ8pY\u0016\fg.\u0010;sk\u0016d\u0003\u0005\u001d:fiRL\bK]5oij\u0012un\u001c7fC:lDO];fS\u0001T\u0001\u0005\t\u0016!A\u0001\u0002#\bI\"pk:$\be\\2dkJ\u0014XM\\2fg\u0002zg\r\t;ie\u0016,W&\u001a3hK\u0002*\b/\f;p[QD'/Z3.]>$W\r\t;f[B|'/\u00197![>$\u0018NZ:!S:\u0004C\u000f[3!]\u0016$xo\u001c:l]\u00012uN\u001d\u0011d_VtGo\u001d\u0011qKJ\u0004c/\u001a:uKbd\u0003e]3fA1{7-\u00197UQJ,WMT8eK6{G/\u001b4t])\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005\u00165fA\u0005dwm\u001c:ji\"l\u0007%[:!m\u0016\u0014\u0018\u0010\t2bg\u0016$\u0007e\u001c8!i\"\fG\u000fI5oA\tju\u000e^5gg\u0002Jg\u000e\t+f[B|'/\u00197!\u001d\u0016$xo\u001c:lg\nr\u0003%\u00118!_B$\u0018n\u001c8!SN\u0004s-\u001b<f]\u0002\"x\u000e\t:fiV\u0014h\u000e\t:fgVdGo\u001d\u0011bg\u0002\n\u0007\u0005[1tQ6\f\u0007\u000fI<ji\"\u0004C.\u00192fYN\u0004sN\u001d\u0011bg\u0002\ng\u000eI1se\u0006L\be\u001e5jG\"\u0004\u0013n\u001d\u0011fCNLWM\u001d\u0011g_J\u0004\u0003o\\:u[A\u0014xnY3tg&twM\f\u0006!A)R\u0001\u0005\t\u0016!A\r\u001a\u0003%T8uS\u001a\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011$G\r\u00023\u000b^1sg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005\u00165fe\u0016\u0004\u0013M]3!i\"\u0014X-\u001a\u0011dY\u0006\u001c8/Z:!Q%t\u0007\u0005\u001e5fA=\u0014H-\u001a:!i\",\u0017\u0010I1sK\u0002zW\u000f\u001e9viR,G-\u000b\u0011pM\u0002\u001aH/\u0019:![>$\u0018N\u001a\u0011p]\u0002\"\bN]3fA9|G-Z:!E\u0006\u001cX\r\u001a\u0011p]\u0002\"\b.\u001a\u0011to&$8\r[5oO\u0002\u0012W\r[1wS>,(\u000fI8gAQDW\rI3eO\u0016\u001c\bEY3uo\u0016,g\u000e\t;iK\u0002\"xo\u001c\u0011mK\u00064\u0007E\\8eKNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011![\u0001\u0002&+\u0012\u001e!'R\f'o\u001d\u0011pM\u0002\"\b.\u001a\u0011g_Jl\u0007%\u001b\u001f.})d\u0003%\u001b\u001f.})d\u0003%\u001b\u001f.}-\u0004\u0003&[3!i^|\u0007%\u001b8uKJ\f7\r^5p]N\u0004s/\u001b;iA1,\u0017M\u001a\u0011kA\u0019|G\u000e\\8xK\u0012\u0004#-\u001f\u0011p]\u0016\u0004s/\u001b;iA1,\u0017M\u001a\u0011lS)\u0001\u0003E\u000b\u0011!A5\u0002S*\u0013#;AM#\u0018M]:!_\u001a\u0004C\u000f[3!M>\u0014X\u000eI5=[yRG\u0006I5=[yZG\u0006I5=[yR\u0007\u0005K5fAM<\u0018\u000e^2iS:<\u0007%\u001b8uKJ\f7\r^5p]N\u0004cM]8nA1,\u0017M\u001a\u0011kAQ|\u0007\u0005\\3bM\u0002ZG\u0006\t2bG.\u0004Co\u001c\u0011kA\u0005<\u0017-\u001b8*\u0015\u0001\u0002#\u0006\t\u0011![\u0001\u0002vj\u0015+;AM#\u0018M]:!_\u001a\u0004C\u000f[3!M>\u0014X\u000eI5=[yRG\u0006I5=[yZG\u0006I5=[yZ\u0007\u0005K5fA=tW\rI5oi\u0016\u0014\u0018m\u0019;j_:\u0004s/\u001b;iA1,\u0017M\u001a\u0011kA\u0019|G\u000e\\8xK\u0012\u0004#-\u001f\u0011uo>\u0004s/\u001b;iA1,\u0017M\u001a\u0011lS)\u0001\u0003E\u000b\u0006!A)\u0002\u0003eV5uQ&t\u0007%Z1dQ\u0002zg\r\t;iKN,\u0007e\u00197bgN,7\u000fI5tAa\u0002Sn\u001c;jMN\u0004C-\u001a9f]\u0012Lgn\u001a\u0011p]\u0002\"\b.\u001a\u0011eSJ,7\r^5p]\u0002zg\r\t;iK\u00022\u0017N]:uAQ|\u0007\u0005\u001e5fA1\f7\u000f\u001e\u0011fI\u001e,\u0007%L\u0017!S:\u001cw.\\5oO\u0002\u0012\u0013J\t\u0011pe\u0002zW\u000f^4pS:<\u0007EI(#])\u0001\u0003E\u000b\u0011!)\",7/\u001a\u0011be\u0016\u0004SM\\;nKJ\fG/\u001a3!S:\u0004C\u000f[3!_J$WM\u001d\u0011J\u0013&c\u0003%S%PY\u0001Ju*\u0013\u0017!\u0013>{E\u0006I(J\u00132\u0002s*S(-A={\u0015\n\f\u0011P\u001f>\u0003\u0003\u0006\\5lK\u0002\u0012\u0017N\\1ss\u0002:\u0018\u000e\u001e5!E%\u0013S\u0006\r\u0011b]\u0012\u0004#e\u0014\u0012.c%r#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011$G\r\u0002Ck^8!]>$W\rI7pi&47O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!\u00032\u001cx\u000eI5oG2,H-\u001a3!CJ,\u0007\u0005^<pA9|G-\u001a\u0011n_RLgm\u001d\u0017!_\u001a\u0004s\u000f[5dQ\u0002\"\b.\u001a:fA\u0005\u0014X\r\t\u001d!o\",g\u000eI2pk:$X\r\u001a\u0011ge>l\u0007\u0005\u001e5fAA,'o\u001d9fGRLg/\u001a\u0011pM\u0002*\u0017m\u00195!m\u0016\u0014H/\u001a=/AQCWm]3!CJ,\u0007e\u00195be\u0006\u001cG/\u001a:jg\u0016$\u0007EY=!i\",\u0007\u0005Z5sK\u000e$\u0018n\u001c8!_\u001a\u0004S-Y2iA\u0015$w-\u001a\u0017!K:,X.\u001a:bi\u0016$'\u0002\t\u0011+A\u0001Jg\u000e\t;iK\u0002\n'm\u001c<fA=\u0014H-\u001a:/A9{G/\u001a\u0011uQ\u0006$\bEZ8sAQDW\rI4m_\n\fG\u000eI4sCBD\u0007eY8v]R\u001cH\u0006I3bG\"\u0004Sn\u001c;jM\u0002J7\u000fI2pk:$X\r\u001a\u0011j]\u0002\u0012w\u000e\u001e5!I&\u0014Xm\u0019;j_:\u001c\b\u0005K1!g&tw\r\\3!\u0013&K\u0005%\\8uS\u001a\u0004cm\u001c:!_:,\u0007E^3si\u0016D\b%[:!C:\u0004sjT(![>$\u0018N\u001a\u0011g_J\u0004C\u000f[3!_RDWM\u001d\u0011wKJ$X\r_\u0015/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023eI\u0012!)JL\u0017M\\4mKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t+iKJ,\u0007%\u0019:fAa\u0002CO]5b]\u001edW\rI7pi&47\u000f\f\u0011cK2|w\u000fI5tAQDW\rI8sI\u0016\u0014\b%\u001b8!o\"L7\r\u001b\u0011uQ\u0016L\b%\u00199qK\u0006\u0014\b%\u001b8!i\",\u0007E]3ukJtW\r\u001a\u0011beJ\f\u0017P\u000f\u0006!A)R\u0001\u0005\t\u0016!A\u0001\nd\u0006I5![5r\u0004E\u001b\u0017!W\u0002jSF\u0010\u0011kY\u0001J\u0007%L\u0017?A-T\u0001\u0005\t\u0016!A\u0001\u0012d\u0006I5![5r\u0004E\u001b\u0017!W\u0002jSF\u0010\u0011jY\u0001R\u0007%L\u0017?A-T\u0001\u0005\t\u0016!A\u0001\u001ad\u0006I5![5r\u0004E\u001b\u0017!U\u0002jSF\u0010\u0011lY\u0001J\u0007%L\u0017?A-T\u0001\u0005\t\u0016!A\u0001\"d\u0006I5![5r\u0004E\u001b\u0017!S\u0002jSF\u0010\u0011lY\u0001R\u0007%L\u0017?A-T\u0001\u0005\t\u0016!A\u0001*d\u0006I5![5r\u0004E\u001b\u0017!W\u0002jSF\u0010\u0011kY\u0001Z\u0007%L\u0017?A%T\u0001\u0005\t\u0016!A\u00012d\u0006I5![5r\u0004E\u001b\u0017!W\u0002jSF\u0010\u0011jY\u0001Z\u0007%L\u0017?A)T\u0001\u0005\t\u0016!A\u0001:d\u0006I5![5r\u0004E\u001b\u0017!U\u0002jSF\u0010\u0011lY\u0001Z\u0007%L\u0017?A%T\u0001\u0005\t\u0016!A\u0001Bd\u0006I5![5r\u0004E\u001b\u0017!S\u0002jSF\u0010\u0011lY\u0001Z\u0007%L\u0017?A)T\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R\u0003\u0005I>t{\u0002\u001cH/\u0019:D_VtGo\u001d\u001e!\u0003J\u0014\u0018-_.J]Rl\u0006M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!)\"\u0014X-Z\u0017o_\u0012,\u0007e\u001d;be\u0002jw\u000e^5gA\r|WO\u001c;tAM$xN]3eA\u0005\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0011)g\u0016,\u0007%\u001b8eS\u000e,7\u000fI1c_Z,\u0017F\u0003\u0011!U\u0001\u00023p]?ai^|gj\u001c3f\u0007>,h\u000e^:;A\u0005\u0013(/Y=\\\u0013:$X\f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AQ;x.\f8pI\u0016\u0004Sn\u001c;jM\u0002\u001aw.\u001e8ug\u0002\u001aHo\u001c:fI\u0002\n7\u000fI1oA\u0005\u0014(/Y=!QM,W\rI5oI&\u001cWm\u001d\u0011bE>4X-\u000b\u0006!A)\u0002\u0003e_:~AR\u0014\u0018nQ8v]R\u001c(\bI!se\u0006L8,\u00138u;\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t+sS\u0006tw\r\\3![>$\u0018N\u001a\u0011d_VtGo\u001d\u0011ti>\u0014X\r\u001a\u0011bg\u0002\ng\u000eI1se\u0006L\b\u0005K:fK\u0002Jg\u000eZ5dKN\u0004\u0013MY8wK&R\u0001\u0005\t\u00160\u0003=!\u0006N]3f\u001d>$W-T8uS\u001a\u001c\bC\u0001#\n'\u0011I\u0001&a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005\u0011\u0011n\u001c\u0006\u0003\u0003s\tAA[1wC&!\u0011QHA\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\tY\u0003F\u0004D\u0003\u0007\n)%a\u0012\t\u000faZ\u0001\u0013!a\u0001s!9Ah\u0003I\u0001\u0002\u0004i\u0004b\u0002!\f!\u0003\u0005\r!P\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\n\u0016\u0004s\u0005=3FAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m#&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0018\u0002V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"!!\u001a+\u0007u\ny%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u0015i\u0017\r\u001d\u001aE)\u0019\ti'a\u001d\u0002xA\u0019\u0011&a\u001c\n\u0007\u0005E$FA\u0002J]RDq!!\u001e\u0010\u0001\u0004\ti'\u0001\u0002ec!9\u0011\u0011P\bA\u0002\u00055\u0014A\u000133\u0003\u0015i\u0017\r]\u001aE)!\ti'a \u0002\u0002\u0006\r\u0005bBA;!\u0001\u0007\u0011Q\u000e\u0005\b\u0003s\u0002\u0002\u0019AA7\u0011\u001d\t)\t\u0005a\u0001\u0003[\n!\u0001Z\u001a\u0002\r\u0011L'o\u001d\u001aE+\t\tY\t\u0005\u0004\u0002\u000e\u0006u\u00151\u0015\b\u0005\u0003\u001f\u000bIJ\u0004\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)JJ\u0001\u0007yI|w\u000e\u001e \n\u0003-J1!a'+\u0003\u001d\u0001\u0018mY6bO\u0016LA!a(\u0002\"\n!A*[:u\u0015\r\tYJ\u000b\t\bS\u0005\u0015\u0016QNA7\u0013\r\t9K\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u000f\u0011L'o\u001d\u001aEA\u0005\u0011r-\u001a;Ue&\u001cu.\u001e8ugB\u0013X\r\u001e;z+\u0011\ty+a3\u0015\t\u0005E\u0016q\u001b\u000b\u0005\u0003g\u000bi\r\u0005\u0005\u00026\u0006u\u00161YAe\u001d\u0011\t9,!/\u0011\u0007\u0005E%&C\u0002\u0002<*\na\u0001\u0015:fI\u00164\u0017\u0002BA`\u0003\u0003\u00141!T1q\u0015\r\tYL\u000b\t\u0005\u0003k\u000b)-\u0003\u0003\u0002H\u0006\u0005'AB*ue&tw\rE\u0002M\u0003\u0017$Q!Y\nC\u0002\tD\u0011\"a4\u0014\u0003\u0003\u0005\u001d!!5\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0004\u0002\u000e\u0006M\u0017\u0011Z\u0005\u0005\u0003+\f\tKA\u0004Ok6,'/[2\t\u000f\u0005e7\u00031\u0001\u0002\\\u0006IAO]5D_VtGo\u001d\t\u0005Su\u000bI-\u0001\u000bhKR\u0014dj\u001c3f\u0007>,h\u000e^:Qe\u0016$H/_\u000b\u0005\u0003C\fI\u000f\u0006\u0003\u0002d\u0006EH\u0003BAs\u0003W\u0004\u0002\"!.\u0002>\u0006\r\u0017q\u001d\t\u0004\u0019\u0006%H!B1\u0015\u0005\u0004\u0011\u0007\"CAw)\u0005\u0005\t9AAx\u0003))g/\u001b3f]\u000e,Ge\r\t\u0007\u0003\u001b\u000b\u0019.a:\t\u000f\u0005MH\u00031\u0001\u0002v\u000611m\\;oiN\u0004B!K/\u0002h\u0006ar-\u001a;3\u001d>$WmQ8v]R\u001cx+\u001b;i_V$(+\u001a9fCR\u001cX\u0003BA~\u0005\u0007!B!!@\u0003\fQ!\u0011q B\u0003!!\t),!0\u0002D\n\u0005\u0001c\u0001'\u0003\u0004\u0011)\u0011-\u0006b\u0001E\"I!qA\u000b\u0002\u0002\u0003\u000f!\u0011B\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004CBAG\u0003'\u0014\t\u0001C\u0004\u0002tV\u0001\rA!\u0004\u0011\t%j&\u0011A\u0001\u0014O\u0016$8\u000b^1s\u0007>,h\u000e^:Qe\u0016$H/_\u000b\u0005\u0005'\u0011Y\u0002\u0006\u0003\u0003\u0016\t\rB\u0003\u0002B\f\u0005;\u0001\u0002\"!.\u0002>\u0006\r'\u0011\u0004\t\u0004\u0019\nmA!B1\u0017\u0005\u0004\u0011\u0007\"\u0003B\u0010-\u0005\u0005\t9\u0001B\u0011\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0007\u0003\u001b\u000b\u0019N!\u0007\t\u000f\u0005Mh\u00031\u0001\u0003&A!\u0011&\u0018B\r\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0019!\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"\u0002\u0002B\u001c\u0003o\tA\u0001\\1oO&!!1\bB\u001b\u0005\u0019y%M[3di\u0002")
public class ThreeNodeMotifs
implements GenericReduction {
    private final long delta;
    private final boolean graphWide;
    private final boolean prettyPrint;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$3() {
        return ThreeNodeMotifs$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ThreeNodeMotifs$.MODULE$.$lessinit$greater$default$2();
    }

    public static long $lessinit$greater$default$1() {
        return ThreeNodeMotifs$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> Map<String, T> getStarCountsPretty(Object counts, Numeric<T> evidence$5) {
        return ThreeNodeMotifs$.MODULE$.getStarCountsPretty(counts, evidence$5);
    }

    public static <T> Map<String, T> get2NodeCountsWithoutRepeats(Object counts, Numeric<T> evidence$4) {
        return ThreeNodeMotifs$.MODULE$.get2NodeCountsWithoutRepeats(counts, evidence$4);
    }

    public static <T> Map<String, T> get2NodeCountsPretty(Object counts, Numeric<T> evidence$3) {
        return ThreeNodeMotifs$.MODULE$.get2NodeCountsPretty(counts, evidence$3);
    }

    public static <T> Map<String, T> getTriCountsPretty(Object triCounts, Numeric<T> evidence$2) {
        return ThreeNodeMotifs$.MODULE$.getTriCountsPretty(triCounts, evidence$2);
    }

    public static List<Tuple2<Object, Object>> dirs2D() {
        return ThreeNodeMotifs$.MODULE$.dirs2D();
    }

    public static int map3D(int d1, int d2, int d3) {
        return ThreeNodeMotifs$.MODULE$.map3D(d1, d2, d3);
    }

    public static int map2D(int d1, int d2) {
        return ThreeNodeMotifs$.MODULE$.map2D(d1, d2);
    }

    public static boolean apply$default$3() {
        return ThreeNodeMotifs$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$2() {
        return ThreeNodeMotifs$.MODULE$.apply$default$2();
    }

    public static long apply$default$1() {
        return ThreeNodeMotifs$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)graph.reducedView().setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            ThreeNodeMotifs.$anonfun$apply$1(this, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            ThreeNodeMotifs.$anonfun$apply$11(this, v, state);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            ThreeNodeMotifs.$anonfun$apply$26(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            ThreeNodeMotifs.$anonfun$apply$31(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            ThreeNodeMotifs.$anonfun$apply$41(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            ThreeNodeMotifs.$anonfun$apply$50(v);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            ThreeNodeMotifs.$anonfun$apply$54(this, v, state);
            return BoxedUnit.UNIT;
        });
    }

    public <T> Object arrayOp(Object a, Object b, Function2<T, T, T> f, ClassTag<T> evidence$1) {
        Predef$.MODULE$.assert(ScalaRunTime$.MODULE$.array_length(a) == ScalaRunTime$.MODULE$.array_length(b));
        return Array$.MODULE$.tabulate(ScalaRunTime$.MODULE$.array_length(a), (Function1 & Serializable)i -> f.apply(ScalaRunTime$.MODULE$.array_apply(a, BoxesRunTime.unboxToInt((Object)i)), ScalaRunTime$.MODULE$.array_apply(b, BoxesRunTime.unboxToInt((Object)i))), evidence$1);
    }

    public Table tabularise(ReducedGraphPerspective graph) {
        return !this.graphWide ? (this.prettyPrint ? graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(), ThreeNodeMotifs$.MODULE$.getStarCountsPretty(((EntityVisitor)((Object)vertex)).getState("starCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), Numeric.IntIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.get2NodeCountsWithoutRepeats(((EntityVisitor)((Object)vertex)).getState("twoNodeCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), Numeric.IntIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.getTriCountsPretty(((EntityVisitor)((Object)vertex)).getState("triCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), Numeric.IntIsIntegral$.MODULE$)}))) : graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(), Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps((int[])((EntityVisitor)((Object)vertex)).getState("starCounts", ((EntityVisitor)((Object)vertex)).getState$default$2())), ((EntityVisitor)((Object)vertex)).getState("twoNodeCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), (ClassTag)ClassTag$.MODULE$.Int())), ((EntityVisitor)((Object)vertex)).getState("triCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), (ClassTag)ClassTag$.MODULE$.Int())).mkString("(", ";", ")")})))) : (this.prettyPrint ? graph.globalSelect((Function1<GraphState, Row>)(Function1 & Serializable)state -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ThreeNodeMotifs$.MODULE$.getStarCountsPretty(state.apply("starCounts").value(), Numeric.LongIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.get2NodeCountsWithoutRepeats(state.apply("twoNodeCounts").value(), Numeric.IntIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.getTriCountsPretty(state.apply("triCounts").value(), Numeric.IntIsIntegral$.MODULE$)}))) : graph.globalSelect((Function1<GraphState, Row>)(Function1 & Serializable)state -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])state.apply("starCounts").value()), state.apply("twoNodeCounts").value(), ClassTag$.MODULE$.AnyVal())), state.apply("triCounts").value(), ClassTag$.MODULE$.AnyVal())).mkString("(", ";", ")")}))));
    }

    public static final /* synthetic */ void $anonfun$apply$1(ThreeNodeMotifs $this, GraphState state) {
        state.newConcurrentAccumulator("twoNodeCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(x$1, x$2) -> (long[])$this.arrayOp(x$1, x$2, (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$3, x$4) -> x$3 + x$4, (ClassTag)ClassTag$.MODULE$.Long()));
        state.newConcurrentAccumulator("triCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(x$5, x$6) -> (long[])$this.arrayOp(x$5, x$6, (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$7, x$8) -> x$7 + x$8, (ClassTag)ClassTag$.MODULE$.Long()));
        state.newConcurrentAccumulator("starCounts", Array$.MODULE$.fill(24, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(x$9, x$10) -> (long[])$this.arrayOp(x$9, x$10, (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$11, x$12) -> x$11 + x$12, (ClassTag)ClassTag$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$apply$11(ThreeNodeMotifs $this, ReducedVertex v, GraphState state) {
        StarMotifCounter mc = new StarMotifCounter(BoxesRunTime.unboxToLong((Object)v.ID()), (Iterable<Object>)((Iterable)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$13 -> x$13 != BoxesRunTime.unboxToLong((Object)v.ID()))));
        mc.execute((List<Tuple3<Object, Object, Object>>)((List)v.explodeAllEdges(v.explodeAllEdges$default$1(), v.explodeAllEdges$default$2()).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))), $this.delta);
        long[] counts = mc.getCounts();
        ObjectRef twoNodeCounts = ObjectRef.create((Object)((long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long())));
        ((IterableOnceOps)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$14 -> x$14 != BoxesRunTime.unboxToLong((Object)v.ID()))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)vid -> {
            TwoNodeMotifs mc2node = new TwoNodeMotifs(BoxesRunTime.unboxToLong((Object)v.ID()));
            mc2node.execute((Tuple3[])((IterableOnceOps)((List)v.explodedEdge(vid, v.explodedEdge$default$2(), v.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Tuple3.class)), $this.delta);
            long[] twoNC = mc2node.getCounts();
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.longArrayOps(counts)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                counts$1[i] = counts[i] - twoNC[i % 8];
            });
            twoNodeCounts$1.elem = (long[])$this.arrayOp((long[])twoNodeCounts$1.elem, twoNC, (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$15, x$16) -> x$15 + x$16, (ClassTag)ClassTag$.MODULE$.Long());
        });
        ((EntityVisitor)((Object)v)).update("twoNodeCounts", (long[])twoNodeCounts.elem);
        state.apply("twoNodeCounts").$plus$eq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps((long[])twoNodeCounts.elem), (Function1)(JFunction1.mcJJ.sp & Serializable)x$17 -> x$17, (ClassTag)ClassTag$.MODULE$.Long()));
        ((EntityVisitor)((Object)v)).update("starCounts", counts);
        state.apply("starCounts").$plus$eq(counts);
        scala.collection.immutable.Set neighbours = ((IterableOnceOps)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$18 -> x$18 != BoxesRunTime.unboxToLong((Object)v.ID()))).toSet();
        neighbours.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)nb -> v.messageVertex(BoxesRunTime.boxToLong((long)nb), new Tuple2(v.ID(), (Object)neighbours), SchemaProviderInstances$.MODULE$.genericSchemaProvider()));
    }

    public static final /* synthetic */ void $anonfun$apply$28(scala.collection.immutable.Set neighbours$2, ReducedVertex v$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long nb = tuple2._1$mcJ$sp();
        scala.collection.immutable.Set friendsOfFriend = (scala.collection.immutable.Set)tuple2._2();
        friendsOfFriend.intersect((Set)neighbours$2).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)w -> {
            block0: {
                if (nb >= w || RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(w), nb)), BoxesRunTime.unboxToLong((Object)v$2.ID())) != BoxesRunTime.unboxToLong((Object)v$2.ID())) break block0;
                v$2.messageVertex(BoxesRunTime.boxToLong((long)nb), new Tuple3((Object)BoxesRunTime.boxToLong((long)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)v$2.ID())), w)), (Object)BoxesRunTime.boxToLong((long)RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)v$2.ID())), w)), (Object)BoxesRunTime.boxToInteger((int)((SeqOps)v$2.explodedEdge(w, v$2.explodedEdge$default$2(), v$2.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).size())), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            }
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$26(ReducedVertex v) {
        scala.collection.immutable.Set neighbours = ((IterableOnceOps)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$19 -> x$19 != BoxesRunTime.unboxToLong((Object)v.ID()))).toSet();
        Seq queue = v.messageQueue();
        queue.foreach((Function1 & Serializable)x0$1 -> {
            ThreeNodeMotifs.$anonfun$apply$28(neighbours, v, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$apply$36(ReducedEdge x$21) {
        return BoxesRunTime.unboxToLong((Object)x$21.src());
    }

    public static final /* synthetic */ void $anonfun$apply$38(ReducedEdge appendedEdge$1, ConcreteExplodedEdge e) {
        ((EntityVisitor)((Object)appendedEdge$1)).appendToState("a_e", new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp())), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public static final /* synthetic */ void $anonfun$apply$32(ReducedVertex v$3, Tuple3 edge) {
        scala.collection.mutable.Map triMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Tuple3 tuple3 = new Tuple3(edge._1(), edge._2(), edge._3());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        long u = BoxesRunTime.unboxToLong((Object)tuple3._1());
        long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
        int size = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)u), (Object)BoxesRunTime.boxToLong((long)w), (Object)BoxesRunTime.boxToInteger((int)size));
        Tuple3 tuple33 = tuple32;
        long u2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
        long w2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        int size2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        triMap.put((Object)new Tuple2.mcJJ.sp(u2, w2), (Object)BoxesRunTime.boxToInteger((int)size2));
        triMap.put((Object)new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)v$3.ID()), u2), (Object)BoxesRunTime.boxToInteger((int)((SeqOps)v$3.explodedEdge(u2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).size()));
        triMap.put((Object)new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)v$3.ID()), w2), (Object)BoxesRunTime.boxToInteger((int)((SeqOps)v$3.explodedEdge(w2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).size()));
        Tuple2 eMax = (Tuple2)((Tuple2)triMap.maxBy((Function1 & Serializable)x -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp()), (Object)BoxesRunTime.boxToLong((long)((Tuple2)x._1())._1$mcJ$sp()), (Object)BoxesRunTime.boxToLong((long)((Tuple2)x._1())._2$mcJ$sp())), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)))._1();
        if (eMax._1$mcJ$sp() == BoxesRunTime.unboxToLong((Object)v$3.ID())) {
            v$3.messageVertex(BoxesRunTime.boxToLong((long)eMax._2$mcJ$sp()), new RequestEdges(BoxesRunTime.unboxToLong((Object)v$3.ID()), eMax._2$mcJ$sp() == u2 ? w2 : u2), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            ReducedEdge appendedEdge = (ReducedEdge)v$3.getEdge(BoxesRunTime.boxToLong((long)eMax._2$mcJ$sp())).minBy((Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)ThreeNodeMotifs.$anonfun$apply$36(x$21)), (Ordering)Ordering.Long$.MODULE$);
            ((List)v$3.explodedEdge(eMax._2$mcJ$sp() == u2 ? w2 : u2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).foreach((Function1 & Serializable)e -> {
                ThreeNodeMotifs.$anonfun$apply$38(appendedEdge, e);
                return BoxedUnit.UNIT;
            });
        } else {
            v$3.messageVertex(BoxesRunTime.boxToLong((long)u2), new Tuple2((Object)BoxesRunTime.boxToLong((long)w2), (Object)((List)v$3.explodedEdge(w2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp())))), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$31(ReducedVertex v) {
        Seq opEdgeSizes = v.messageQueue();
        opEdgeSizes.foreach((Function1 & Serializable)edge -> {
            ThreeNodeMotifs.$anonfun$apply$32(v, edge);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$apply$46(ReducedEdge x$22) {
        return BoxesRunTime.unboxToLong((Object)x$22.src());
    }

    public static final /* synthetic */ void $anonfun$apply$45(ReducedVertex v$4, Tuple2 x3$1, Tuple3 e) {
        ((EntityVisitor)v$4.getEdge(BoxesRunTime.boxToLong((long)x3$1._1$mcJ$sp())).minBy((Function1 & Serializable)x$22 -> BoxesRunTime.boxToLong((long)ThreeNodeMotifs.$anonfun$apply$46(x$22)), (Ordering)Ordering.Long$.MODULE$)).appendToState("a_e", e, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public static final /* synthetic */ long $anonfun$apply$47(ReducedEdge x$23) {
        return BoxesRunTime.unboxToLong((Object)x$23.src());
    }

    public static final /* synthetic */ void $anonfun$apply$49(ReducedEdge appendedEdge$2, ConcreteExplodedEdge e) {
        ((EntityVisitor)((Object)appendedEdge$2)).appendToState("a_e", new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp())), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public static final /* synthetic */ void $anonfun$apply$42(ReducedVertex v$4, Object x0$2) {
        Object object = x0$2;
        if (object instanceof RequestEdges) {
            RequestEdges requestEdges = (RequestEdges)object;
            long sendTo = requestEdges.sendTo();
            long dst = requestEdges.dst();
            v$4.messageVertex(BoxesRunTime.boxToLong((long)sendTo), new Tuple2(v$4.ID(), (Object)((List)v$4.explodedEdge(dst, v$4.explodedEdge$default$2(), v$4.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp())))), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Tuple2) {
            Tuple2 tuple2 = (Tuple2)object;
            ((List)tuple2._2()).foreach((Function1 & Serializable)e -> {
                ThreeNodeMotifs.$anonfun$apply$45(v$4, tuple2, e);
                return BoxedUnit.UNIT;
            });
            long dst = BoxesRunTime.unboxToLong((Object)((Tuple3)((IterableOps)tuple2._2()).head())._1()) == tuple2._1$mcJ$sp() ? BoxesRunTime.unboxToLong((Object)((Tuple3)((IterableOps)tuple2._2()).head())._2()) : BoxesRunTime.unboxToLong((Object)((Tuple3)((IterableOps)tuple2._2()).head())._1());
            ReducedEdge appendedEdge = (ReducedEdge)v$4.getEdge(BoxesRunTime.boxToLong((long)tuple2._1$mcJ$sp())).minBy((Function1 & Serializable)x$23 -> BoxesRunTime.boxToLong((long)ThreeNodeMotifs.$anonfun$apply$47(x$23)), (Ordering)Ordering.Long$.MODULE$);
            ((List)v$4.explodedEdge(dst, v$4.explodedEdge$default$2(), v$4.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).foreach((Function1 & Serializable)e -> {
                ThreeNodeMotifs.$anonfun$apply$49(appendedEdge, e);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(object);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$41(ReducedVertex v) {
        Seq queue = v.messageQueue();
        queue.foreach((Function1 & Serializable)x0$2 -> {
            ThreeNodeMotifs.$anonfun$apply$42(v, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$apply$53(ReducedEdge x$24) {
        return BoxesRunTime.unboxToLong((Object)x$24.src());
    }

    public static final /* synthetic */ void $anonfun$apply$52(ReducedVertex v$5, Tuple2 edges$1, Tuple3 e) {
        ((EntityVisitor)v$5.getEdge(BoxesRunTime.boxToLong((long)edges$1._1$mcJ$sp())).minBy((Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)ThreeNodeMotifs.$anonfun$apply$53(x$24)), (Ordering)Ordering.Long$.MODULE$)).appendToState("a_e", e, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public static final /* synthetic */ void $anonfun$apply$51(ReducedVertex v$5, Tuple2 edges) {
        ((List)edges._2()).foreach((Function1 & Serializable)e -> {
            ThreeNodeMotifs.$anonfun$apply$52(v$5, edges, e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$50(ReducedVertex v) {
        v.messageQueue().foreach((Function1 & Serializable)edges -> {
            ThreeNodeMotifs.$anonfun$apply$51(v, edges);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$apply$58(ReducedEdge x$26) {
        return BoxesRunTime.unboxToLong((Object)x$26.src());
    }

    public static final /* synthetic */ void $anonfun$apply$54(ThreeNodeMotifs $this, ReducedVertex v, GraphState state) {
        ((EntityVisitor)((Object)v)).update("triCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()));
        ((IterableOnceOps)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$25 -> x$25 != BoxesRunTime.unboxToLong((Object)v.ID()))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)nb -> {
            block0: {
                ReducedEdge edge2 = (ReducedEdge)v.getEdge(BoxesRunTime.boxToLong((long)nb)).minBy((Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)ThreeNodeMotifs.$anonfun$apply$58(x$26)), (Ordering)Ordering.Long$.MODULE$);
                ArrayBuffer a_e = (ArrayBuffer)((EntityVisitor)((Object)edge2)).getStateOrElse("a_e", ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), ((EntityVisitor)((Object)edge2)).getStateOrElse$default$3());
                ((EntityVisitor)((Object)edge2)).clearState("a_e");
                if (!a_e.nonEmpty()) break block0;
                List inputEdges = (List)((IterableOnceOps)a_e.appendedAll((IterableOnce)((List)v.explodedEdge(nb, v.explodedEdge$default$2(), v.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))))).toList().sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
                scala.collection.immutable.Set opNeighbours = (scala.collection.immutable.Set)((SetOps)inputEdges.foldRight(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(edge, nbset) -> (scala.collection.immutable.Set)nbset.union((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)edge._1()), BoxesRunTime.unboxToLong((Object)edge._2())}))))).removedAll((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)v.ID()), nb})));
                TriadMotifCounter mc = new TriadMotifCounter(BoxesRunTime.unboxToLong((Object)v.ID()), nb, (Iterable<Object>)opNeighbours);
                mc.execute((List<Tuple3<Object, Object, Object>>)inputEdges, $this.delta);
                long[] curVal = (long[])((EntityVisitor)((Object)v)).getState("triCounts", ((EntityVisitor)((Object)v)).getState$default$2());
                ((EntityVisitor)((Object)v)).update("triCounts", $this.arrayOp(curVal, mc.getCounts(), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$27, x$28) -> x$27 + x$28, (ClassTag)ClassTag$.MODULE$.Long()));
                state.apply("triCounts").$plus$eq(mc.getCounts());
            }
        });
    }

    public ThreeNodeMotifs(long delta, boolean graphWide, boolean prettyPrint) {
        this.delta = delta;
        this.graphWide = graphWide;
        this.prettyPrint = prettyPrint;
        BaseAlgorithm.$init$(this);
        GenericReduction.$init$(this);
    }
}

